/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  lib_flashiap.h
 * @作  者:  AE Team
 * @版  本:  V1.00
 * @日  期:  2022/07/25
 * @描  述:  FlashIAP库函数头文件
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
 
 
#ifndef __LIBIAP_H__
#define __LIBIAP_H__

#include "FS030.h"


/* IAP Function */
uint8_t EraseAll(void) ;


typedef uint32_t (*iap_pageerase_t)(uint32_t address, uint32_t addressInv, uint32_t sector);
#define  IAP_PageErase  ((iap_pageerase_t)(*((uint32_t *)0x10000004)))

typedef uint32_t (*iap_wordprogrm_t)(uint32_t address, uint32_t addressInv, uint32_t data);
#define  IAP_WordProgram  ((iap_wordprogrm_t)(*((uint32_t *)0x10000008)))

typedef uint32_t (*iap_wordsprogrm_t)(uint32_t address, uint32_t addressInv, uint8_t data[], uint32_t length, uint32_t erase);
#define  IAP_WordsProgram  ((iap_wordsprogrm_t)(*((uint32_t *)0x10000000)))


uint32_t  get_cusum32(uint32_t *data_ptr, uint32_t len);

uint8_t check_empty(uint32_t *data_ptr, uint32_t len);


#define  REMAP_DIS   SCU->TBLREMAPEN.EN = 0;
#define  REMAP_EN    SCU->TBLREMAPEN.EN = 1;

#define  FAILED  0
#define  SUCCESS 1


#endif

/*************************END OF FILE**********************/
