/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd
 * @文件名:  main.c
 * @作  者:  AE Team
 * @版  本:  V1.00
 * @日  期:  2022/07/25
 * @描  述:  XTAL程序
 *        本例程需根据实际使用的晶振，使用ESBurner修改配置字XTAL（默认使用PB8，PB9，8M晶振即可）
 *        该例程需要在PB10，PB11焊接8M晶振，不要使用母板（母板连接线路会对晶振产生影响），只需要使用子板即可
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


#include "main.h"
#include "string.h"

void SetOscPort(void)
{
    GPIO_InitSettingType x;
    memset(&x, 0, sizeof(x));

    x.Signal = GPIO_Pin_Signal_Analog;
    x.Dir = GPIO_Direction_Input;
    x.Func = GPIO_Reuse_Func0;
    x.ODE = GPIO_ODE_Output_Disable;
    x.PUE = GPIO_PUE_Input_Disable;
    x.PDE = GPIO_PDE_Input_Disable;

    GPIO_Init(GPIO_Pin_B10, &x);
    GPIO_Init(GPIO_Pin_B11, &x);
}

int main(void)
{
    SystemInit();
    SetOscPort();
    SCU_OpenXTAL();
    SCU_SysClkSelect(SCU_CLK_XTAL);
    /* 如使用其他规格晶振须修改此处 */
    SystemCoreClock = 8000000;
    DeviceClockAllEnable();

    User_SysTickInit();
    LightInit(LED1_PIN);
    LightOff(LED1_PIN);

    while (1)
    {
        LightOn(LED1_PIN);
        Delay_100us(10000);
        LightOff(LED1_PIN);
        Delay_100us(10000);
    }
}


/*************************END OF FILE**********************/
