/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  irqhandler.c
 * @作  者:  AE Team
 * @版  本:  V1.00
 * @日  期:  2022/07/25
 * @描  述:
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#include "irqhandler.h"
#include "lib_config.h"
#include "systick.h"

void NMI_IRQHandler(void)
{

}

void HardFault_IRQHandler(void)
{
    while (1);
}

void SVC_IRQHandler(void)
{

}

void PendSV_IRQHandler(void)
{

}

void SysTick_IRQHandler(void)
{
    TimingDelay_Decrement();
}

/*********************************************************
函数名: void UART0_IRQHandler(void)
描  述: UART中断服务程序
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void UART0_IRQHandler(void)
{
    if ((UART_GetITStatus(UART0, UART_IT_FE) != RESET) && (UART_GetFlagStatus(UART0, UART_FLAG_FE) != RESET))
    {
        /* 声明配置RX管脚进行外部中断所需的变量 */
        static uint8_t timecounter = 0x0U;
        GPIO_InitSettingType x;
        PINT_InitSettingType y;

        /* 清除中断标志 */
        UART_ClearITPendingBit(UART0, UART_FLAG_FE);
        UART_ClearITPendingBit(UART0, UART_FLAG_TB);
        UART_ClearITPendingBit(UART0, UART_FLAG_TC);
        UART_ClearITPendingBit(UART0, UART_FLAG_RB);

        timecounter++;

        if (timecounter < 3)
        {
        }
        else
        {
            timecounter = 0;
            /* 停止接收 */
            UART0_RxDisable();

            /* 配置RX管脚进行外部中断 */
            x.Signal = GPIO_Pin_Signal_Digital;
            x.Dir = GPIO_Direction_Input;
            x.Func = GPIO_Reuse_Func0;
            x.PUE = GPIO_PUE_Input_Disable;
            x.PDE = GPIO_PDE_Input_Enable;
            GPIO_Init(GPIO_Pin_A22, &x);

            y.IE_Set = PINT_IE_Set_Enable;
            y.Trigger_Style = PINT_Trigger_Rising_Edge;             /* 上升沿触发中断 */
            PINT_Init(GPIO_Pin_A22, &y);
            NVIC_Init(NVIC_PINT1_IRQn, NVIC_Priority_1, Enable);
        }

        return;
    }

    if ((UART_GetITStatus(UART0, UART_IT_RB) != RESET) && (UART_GetFlagStatus(UART0, UART_FLAG_RB) != RESET))
    {
        g_buffer = UART_RecByte(UART0);
        UART_ITConfig(UART0, UART_IT_TB, Enable);               /* UART0发送中断使能 */
    }

    if ((UART_GetITStatus(UART0, UART_IT_TB) != RESET) && (UART_GetFlagStatus(UART0, UART_FLAG_TB) != RESET))
    {
        UART_SendByte(UART0, g_buffer);
        UART_ITConfig(UART0, UART_IT_TB, Disable);              /* UART0发送中断禁止 */
    }
}

/*********************************************************
函数名: void PINT6_IRQHandler(void)
描  述: PINT中断服务程序
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void PINT6_IRQHandler(void)
{
    if ((PINT_GetITFlag(GPIO_Pin_A22) == SET) && (PINT_GetITStatus(GPIO_Pin_A22) == SET))
    {
        /* 声明重新配置RX管脚所需变量 */
        GPIO_InitSettingType x;

        /* 清除端口中断标志位 */
        PINT_ClearITFlag(GPIO_Pin_A22);
        /* 关闭外部端口中断 */
        NVIC_Init(NVIC_PINT6_IRQn, NVIC_Priority_1, Disable);

        /* 配置外部端口中断 */
        x.Signal = GPIO_Pin_Signal_Digital;
        x.Func = GPIO_Reuse_Func1;
        x.Dir = GPIO_Direction_Input;
        x.PUE = GPIO_PUE_Input_Disable;
        x.PDE = GPIO_PDE_Input_Disable;
        GPIO_Init(GPIO_Pin_A22, &x);

        /* 接收缓冲器清除 */
        UART0->CON0.RBCLR = 0x1;
        UART0_RxEnable();
    }
}


/*************************END OF FILE**********************/
