/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  systick.c
 * @作  者:  AE Team
 * @版  本:  V1.00
 * @日  期:  2022/07/25
 * @描  述:  系统滴答模块程序
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


#include "systick.h"
#include "string.h"

__IO uint32_t TimingDelay;

/*********************************************************
函数名: void User_SysTickInit(void)
描  述: 系统滴答初始化：100us
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void User_SysTickInit(void)
{
    SYSTICK_InitStruType x;
	memset(&x, 0, sizeof(x));

    x.SysTick_Value = SystemCoreClock / 100000;  /* 10us */
    x.SysTick_ClkSource = SysTick_ClkS_Cpu;
    x.SysTick_ITEnable = Enable;                /* 中断使能 */
    SysTick_Init(&x);

    SysTick_Disable();
}

/*********************************************************
函数名: void Delay_10us(__IO uint32_t nTime)
描  述: 系统滴答10us定时
输入值: 定时10us
输出值: 无
返回值: 无
**********************************************************/
void Delay_10us(__IO uint32_t nTime)
{
    TimingDelay = nTime;
    SysTick_Enable();

    while (TimingDelay != 0);

    SysTick_Disable();
}

/*********************************************************
函数名: void TimingDelay_Decrement(void)
描  述: 系统滴答中断调用
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void TimingDelay_Decrement(void)
{
    if (TimingDelay != 0)
        TimingDelay --;
}


/*************************END OF FILE**********************/
