/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @ļ:  irqhandler.c
 * @  :  AE Team
 * @  :  V1.01
 * @  :  2022/07/25
 * @  :  
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#include "irqhandler.h"

void NMI_IRQHandler(void)
{

}

void HardFault_IRQHandler(void)
{
    while (1);
}

void SVC_IRQHandler(void)
{

}

void PendSV_IRQHandler(void)
{

}

void SysTick_IRQHandler(void)
{

}

/*********************************************************
: void T16N0_IRQHandler(void)
  : T16N0ʱжϺ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void T16N0_IRQHandler(void)
{
    static uint8_t s_count = 0x0U;

    if ((T16Nx_GetFlagStatus(T16N0, T16Nx_IT_MAT0) == SET) && (T16Nx_GetITStatus(T16N0, T16Nx_IT_MAT0) == SET))
    {
        T16Nx_ClearITPendingBit(T16N0, T16Nx_IT_MAT0);

        s_count++;

        if (s_count % 2 == 0)
        {
            LightOn(LED1_PIN);
        }
        else
        {
            LightOff(LED1_PIN);
        }
    }

    return;
}


/*************************END OF FILE**********************/
