/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  spi.h
 * @作  者:  AE Team
 * @版  本:  V1.01
 * @日  期:  2022/07/25
 * @描  述:  SPI主机模块程序头文件
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


#ifndef __SPI_H__
#define __SPI_H__

#include "lib_config.h"
#include "string.h"

/* 定义宏名：SPI通信管脚 */
#define SPI_NSS     GPIO_Pin_A27
#define SPI_SCK     GPIO_Pin_A3
#define SPI_MISO    GPIO_Pin_A25
#define SPI_MOSI    GPIO_Pin_A24

/* 外部变量 */
extern uint8_t g_wbuf[260];
extern uint8_t g_rbuf[260];
extern volatile uint8_t rbufIndex;
extern volatile uint8_t wbufIndex;
extern volatile uint8_t g_rbufamount;
extern volatile uint8_t g_wbufamount;

/* 函数声明 */
void SPI1Init(void);

#endif


/*************************END OF FILE**********************/
