/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  main.c
 * @作  者:  AE Team
 * @版  本:  V1.01
 * @日  期:  2022/07/25
 * @描  述:  SPI EEPROM demo
          引脚连接：
          ------------------------
          SPI EEPROM:
          ------------------------
          NSS - PA27,
          SCK - PA3,
          MISO - PA25,
          MOSI - PA24
          ------------------------
          UART:
          ------------------------
          TXD - PA23
          RXD - PA22
          ------------------------
          本例程使用的外部FLASH型号为93AA46A，可直接连接通用开发板HRSDK-GMB-01
          上位机使用XCOM接收MCU发送的数据
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


#include "main.h"

int main()
{
    uint8_t w_buffer[1] = {0xCD};
    uint8_t r_buffer[1] = {0x0};

    HRC_Config(Enable, SCU_HRC_48M, Enable);    /* 配置HRC时钟频率 */
    SystemInit();
    DeviceClockAllEnable();
    User_SysTickInit();

    E2rom_init();

    E2romEraseAll();
    E2romWriteData(0x00, w_buffer[0]);
    printf("E2ROM writeten finished, content: 0x%X \n", w_buffer[0]);

    E2romReadData(0x00, r_buffer);
    printf("Content readout from E2ROM: 0x%X\n", r_buffer[0]);

    while (1)
    {
    }
}


/*************************END OF FILE**********************/
