/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  sleep.c
 * @作  者:  AE Team
 * @版  本:  V1.00
 * @日  期:  2022/07/25
 * @描  述:  休眠函数
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


#include "sleep.h"

/***************************************************************
 函数名：void light_sleep(void)
 描  述：进入浅睡眠
 输入值：无
 输出值：无
 返回值：无
***************************************************************/
void light_sleep(void)
{
    SCB_SystemLPConfig(SCB_LP_SleepDeep, Disable);      /* 浅睡眠 */
    SCB_SystemLPConfig(SCB_LP_SleepOnExit, Disable);    /* 从ISR中断处理程序返回到线程模式时不进入休眠 */
    SCB_SystemLPConfig(SCB_LP_SEVOPend, Enable);        /* 中断挂起作为唤醒事件 */

    __NOP();
    __NOP();
    __WFI(); /* 休眠 */
    __NOP();
    __NOP();
}

/***************************************************************
 函数名：void deep_sleep(void)
 描  述：进入深度睡眠
 输入值：无
 输出值：无
 返回值：无
***************************************************************/
void deep_sleep(void)
{
    SCU_RegUnLock();
    SCU_WAKEUPTIME(0x800);                  /* 系统唤醒时间控制 */
    SCU_MOSC_EN(0x00);                      /* 关闭HRC、XTAL以及CLKFLT */
    SCU_CLKFLT_EN(0x00);                    /* 关闭系统时钟滤波器 */
    SCU_VROSCEN(0x0);                       /* 关闭VR工作时钟 */
    SCU_STPRTNEN(0x01);                     /* 深度睡眠下SRAM低功耗 */
    SCU_LDOLP_VOSEL(0x01);                  /* 深度睡眠下，LDO输出1.4 */
    SCU_LP_STOP(0x01);                      /* 深度睡眠下LDO低功耗使能 */
    SCU_BG_STOP(0x01);                      /* 深度睡眠下BG低功耗使能 */
    SCU_FLS_STOP(0x01);                     /* 深度睡眠下FLASH STOP使能 */
    SCB_SystemLPConfig(SCB_LP_SleepDeep, Enable);       /* 深度睡眠 */
    SCB_SystemLPConfig(SCB_LP_SleepOnExit, Disable);    /* 从ISR中断处理程序返回到线程模式时不进入休眠 */
    SCB_SystemLPConfig(SCB_LP_SEVOPend, Enable);        /* 中断挂起作为唤醒事件 */
    SCU_RegLock();

    __NOP();
    __NOP();
    __WFI(); /* 休眠 */
    __NOP();
    __NOP();
}


/*************************END OF FILE**********************/
