/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd
 * @文件名:  main.c
 * @作  者:  AE Team
 * @版  本:  V1.00
 * @日  期:  2022/07/25
 * @描  述:  深度睡眠功耗分析示例程序
 *           需使用ES-Burner修改配置字，禁止Debug，例程测试时，功耗最低1.2uA
 *           进入休眠前，LED亮一秒
 *           外部端口中断唤醒，端口PA1
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


#include "main.h"

int main(void)
{
    HRC_Config(Enable, SCU_HRC_48M, Enable);    /* 配置HRC时钟频率 */
    SystemInit();
    DeviceClockAllEnable();
    User_SysTickInit();

    /* 除PINT外，所有IO口输入输出均关闭 */
    GPIOInit();
    PINTx_Init();

    while (1)
    {
        /* LED1亮一秒 */
        LightInit(LED1_PIN);
        LightOn(LED1_PIN);
        Delay_100us(10000);

        deep_sleep();
        Delay_100us(30000);
    }
}


/*************************END OF FILE**********************/
