/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  gpio.c
 * @作  者:  AE Team
 * @版  本:  V1.00
 * @日  期:  2022/07/25
 * @描  述:  
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


#include "gpio.h"
#include "string.h"


/*********************************************************
函数名:  void GPIOInit(void)
描  述:   初始化IO管脚，配置为模拟
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void GPIOInit(void)
{
    GPIO_InitSettingType x;
	memset(&x, 0, sizeof(x));
	
    x.Signal = GPIO_Pin_Signal_Analog;
    x.Dir = GPIO_Direction_Input;
    x.Func = GPIO_Reuse_Func0;

    /* init PA port */
    GPIO_Init(GPIO_Pin_A1, &x);
    GPIO_Init(GPIO_Pin_A2, &x);
    GPIO_Init(GPIO_Pin_A3, &x);
    GPIO_Init(GPIO_Pin_A4, &x);
    GPIO_Init(GPIO_Pin_A5, &x);
    GPIO_Init(GPIO_Pin_A6, &x);
    GPIO_Init(GPIO_Pin_A7, &x);
    GPIO_Init(GPIO_Pin_A8, &x);
    GPIO_Init(GPIO_Pin_A9, &x);
    GPIO_Init(GPIO_Pin_A10, &x);
    GPIO_Init(GPIO_Pin_A11, &x);
    GPIO_Init(GPIO_Pin_A12, &x);
    GPIO_Init(GPIO_Pin_A13, &x);
    GPIO_Init(GPIO_Pin_A14, &x);
    GPIO_Init(GPIO_Pin_A15, &x);
    GPIO_Init(GPIO_Pin_A16, &x);
    GPIO_Init(GPIO_Pin_A22, &x);
    GPIO_Init(GPIO_Pin_A23, &x);
    GPIO_Init(GPIO_Pin_A24, &x);
    GPIO_Init(GPIO_Pin_A25, &x);
    GPIO_Init(GPIO_Pin_A27, &x);
    GPIO_Init(GPIO_Pin_A28, &x);

    /* init PB port */
    GPIO_Init(GPIO_Pin_B0, &x);
    GPIO_Init(GPIO_Pin_B1, &x);
    GPIO_Init(GPIO_Pin_B8, &x);
    GPIO_Init(GPIO_Pin_B9, &x);
    GPIO_Init(GPIO_Pin_B10, &x);
    GPIO_Init(GPIO_Pin_B11, &x);
    GPIO_Init(GPIO_Pin_B12, &x);
    GPIO_Init(GPIO_Pin_B13, &x);
}


/*************************END OF FILE**********************/
