/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  timer.h
 * @作  者:  AE Team
 * @版  本:  V1.01
 * @日  期:  2022/07/25
 * @描  述:  Timer模块程序头文件
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


#include "timer.h"
#include "string.h"

/*********************************************************
函数名: void T32N_Pin_Init(void)
描  述: T32Nx输出管脚初始化
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T32N_Pin_Init(void)
{
    GPIO_InitSettingType x;
	memset(&x, 0, sizeof(x));
	
    x.Signal = GPIO_Pin_Signal_Digital;
    x.Dir = GPIO_Direction_Output;
    x.Func = GPIO_Reuse_Func2;
    x.ODE = GPIO_ODE_Output_Disable;
    x.DS = GPIO_DS_Output_Normal;
    x.PUE = GPIO_PUE_Input_Enable;
    x.PDE = GPIO_PDE_Input_Disable;

    /* T32N0(PA2、PA3) */
    GPIO_Init(GPIO_Pin_A2, &x);
    GPIO_Init(GPIO_Pin_A3, &x);
}

/*********************************************************
函数名: void T32NxInit(void)
描  述: T32Nx定时器初始化
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T32NxInit(void)
{
    T32Nx_BaseInitStruType x;
    T32Nx_PWMInitStruType z;
	memset(&x, 0, sizeof(x));
	memset(&z, 0, sizeof(z));

    /* 初始化T32Nx定时器 */
    x.T32Nx_ClkS = T32Nx_ClkS_PCLK;
    x.T32Nx_SYNC = Disable;
    x.T32Nx_EDGE = T32Nx_EDGE_Rise;
    x.T32Nx_Mode = T32Nx_Mode_PWM;
    x.T32Nx_PREMAT = 0x01;          /* 预分频比1:1 */
    T32Nx_BaseInit(T32N0, &x);

    /* 初始化T32N0PWM输出端口 */
    z.T32Nx_MOE0 = Enable;
    z.T32Nx_MOE1 = Enable;
    T32Nx_PMWOutInit(T32N0, &z);
    /* 配置T32N0PWM */
    T32Nx_MAT0ITConfig(T32N0, T32Nx_Go_No);
    T32Nx_MAT1ITConfig(T32N0, T32Nx_Go_No);
    T32Nx_MAT2ITConfig(T32N0, T32Nx_Go_No);
    T32Nx_MAT3ITConfig(T32N0, T32Nx_Clr_Int);
    T32Nx_MAT0Out0Config(T32N0, T32Nx_Out_High);
    T32Nx_MAT1Out0Config(T32N0, T32Nx_Out_Low);
    T32Nx_MAT2Out1Config(T32N0, T32Nx_Out_High);
    T32Nx_MAT3Out1Config(T32N0, T32Nx_Out_Low);
    T32Nx_SetCNT(T32N0, 0);
    T32Nx_SetMAT0(T32N0, 800);
    T32Nx_SetMAT1(T32N0, 1600);
    T32Nx_SetMAT2(T32N0, 2400);
    T32Nx_SetMAT3(T32N0, 3200);

    T32Nx_ITConfig(T32N0, T32Nx_IT_MAT3, Enable);
    NVIC_Init(NVIC_T32N0_IRQn, NVIC_Priority_1, Enable);

    T32N_Pin_Init();

    T32Nx_Enable(T32N0);                            /* 使能T32N0定时器 */

    return;
}


/*************************END OF FILE**********************/
