/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  timer.h
 * @作  者:  AE Team
 * @版  本:  V1.01
 * @日  期:  2022/07/25
 * @描  述:  Timer模块程序头文件
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


#include "timer.h"
#include "string.h"


/*********************************************************
函数名: void T16Nx_Pins_Init(void)
描  述: T16Nx PWM输出pin脚初始化
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16Nx_Pins_Init(void)
{
    GPIO_InitSettingType x;
	memset(&x, 0, sizeof(x));

    x.Signal = GPIO_Pin_Signal_Digital;
    x.Dir = GPIO_Direction_Output;
    x.Func = GPIO_Reuse_Func2;
    x.ODE = GPIO_ODE_Output_Disable;
    x.DS = GPIO_DS_Output_Normal;
    x.PUE = GPIO_PUE_Input_Enable;
    x.PDE = GPIO_PDE_Input_Disable;

    /* 配置PA6、PA7分别为T16N0输出通道0和输出通道1 */
    GPIO_Init(GPIO_Pin_A6, &x);
    GPIO_Init(GPIO_Pin_A7, &x);
}

/*********************************************************
函数名: void T16NxInit(void)
描  述: T16Nx定时器初始化
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16NxInit(void)
{
    T16Nx_BaseInitStruType x;
    T16Nx_PWMInitStruType y;
	memset(&x, 0, sizeof(x));
	memset(&y, 0, sizeof(y));

    /* 初始化T16Nx定时器：内部时钟，异步，不分频 */
    x.T16Nx_ClkS = T16Nx_ClkS_PCLK;
    x.T16Nx_SYNC = Disable;
    x.T16Nx_Mode = T16Nx_Mode_PWM;
    x.T16Nx_PREMAT = 0x01;          /* 预分频比1:1 */
    T16Nx_BaseInit(T16N0, &x);

    /* 配置T16N0通道0和通道1同步输出 */
    y.T16Nx_MOE0 = Enable;                      /* 通道0输出开启 */
    y.T16Nx_MOE1 = Enable;                      /* 通道1输出开启 */
    y.T16Nx_POL0 = POSITIVE;
    y.T16Nx_POL1 = POSITIVE;
    y.T16Nx_PWMMODE = T16Nx_PWMMode_SYNC;       /* 同步模式输出 */
    y.PWMDZE = Disable;                         /* 关闭死区互补功能 */
    y.REGBUFEN = Enable;                        /* 缓冲寄存器使能 */
    T16Nx_PMWOutInit(T16N0, &y);

    /* CNT0匹配到MAT0继续计数，CNT0匹配到MAT1清零重新计数 */
    T16Nx_MAT0ITConfig(T16N0, T16Nx_Go_Int);
    T16Nx_MAT1ITConfig(T16N0, T16Nx_Go_Int);
    /* CNT0匹配到MAT0端口输出高，匹配到MAT1端口输出低 */
    T16Nx_MAT0Out0Config(T16N0, T16Nx_Out_Low);
    T16Nx_MAT1Out0Config(T16N0, T16Nx_Out_High);
    /* 初始化MAT0/MAT1 */
    T16Nx_SetCNT0(T16N0, 0);
    T16Nx_SetMAT0(T16N0, 50);
    T16Nx_SetMAT1(T16N0, 100);
    T16Nx_SetTOP0(T16N0, 100);

    T16Nx_Pins_Init();

    T16Nx_Enable(T16N0);

    return;
}


/*************************END OF FILE**********************/
