/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  timer.h
 * @作  者:  AE Team
 * @版  本:  V1.00
 * @日  期:  2022/07/25
 * @描  述:  Timer模块程序头文件
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


#include "timer.h"
#include "string.h"

/*********************************************************
函数名: void T16Nx_Pins_Init(void)
描  述: T16Nx PWM输出pin脚初始化
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16Nx_Pins_Init(void)
{
    GPIO_InitSettingType x;
	memset(&x, 0, sizeof(x));

    x.Signal = GPIO_Pin_Signal_Digital;
    x.Dir = GPIO_Direction_Output;
    x.Func = GPIO_Reuse_Func1;
    x.ODE = GPIO_ODE_Output_Disable;
    x.DS = GPIO_DS_Output_Normal;
    x.PUE = GPIO_PUE_Input_Enable;
    x.PDE = GPIO_PDE_Input_Disable;

    /* 配置PA10、PA11分别为T16N2输出通道0和输出通道1 */
    GPIO_Init(GPIO_Pin_A10, &x);
    GPIO_Init(GPIO_Pin_A11, &x);
}

/*********************************************************
函数名: void T16N2Init(void)
描  述: 配置T16N2输出调制脉冲
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16N2Init(void)
{
    T16Nx_BaseInitStruType x;
    T16Nx_PWMInitStruType y;	
    T16N_TypeDef *T16_timer = T16N2;
	memset(&x, 0, sizeof(x));
	memset(&y, 0, sizeof(y));

    /* 初始化T16Nx定时器：内部时钟，异步，不分频 */
    x.T16Nx_ClkS = T16Nx_ClkS_PCLK;
    x.T16Nx_Mode = T16Nx_Mode_PWM;
    x.T16Nx_PREMAT = 0x01;
    x.T16Nx_SYNC = Disable;
    x.T16Nx_EDGE = T16Nx_EDGE_Rise;
    T16Nx_BaseInit(T16_timer, &x);	

    /* 配置T16N1通道0和通道1同步输出 */
    y.T16Nx_MOE0 = Enable;                      /* 通道0输出开启 */
    y.T16Nx_MOE1 = Enable;                      /* 通道1输出开启 */
    y.T16Nx_POL0 = POSITIVE;
    y.T16Nx_POL1 = POSITIVE;
    y.T16Nx_PWMMODE = T16Nx_PWMMode_SYNC;       /* 同步模式输出 */
    y.PWMDZE = Disable;                         /* 关闭死区互补功能 */
    y.REGBUFEN = Enable;                        /* 缓冲寄存器使能 */
    T16Nx_PMWOutInit(T16_timer, &y);

    /* CNT0匹配到MAT0继续计数，CNT0匹配到MAT1清零重新计数 */
    T16Nx_MAT0ITConfig(T16_timer, T16Nx_Go_No);
    T16Nx_MAT1ITConfig(T16_timer, T16Nx_Go_No);
    /* CNT0匹配到MAT0端口输出高，匹配到MAT1端口输出低 */
    T16Nx_MAT0Out0Config(T16_timer, T16Nx_Out_High);
    T16Nx_MAT1Out0Config(T16_timer, T16Nx_Out_Low);
    /* 初始化MAT0/MAT1 */
    T16Nx_SetCNT0(T16_timer, 0);
    T16Nx_SetMAT0(T16_timer, 50);
    T16Nx_SetMAT1(T16_timer, 100);
    T16Nx_SetTOP0(T16_timer, 100);

    /* PWM通道0匹配1触发ADC使能 */
    T16Nx_PTR_Config(T16_timer, T16Nx_P0MAT1, Enable);

    /* PWM通道0输出管脚初始化 */
    T16Nx_Pins_Init();

    T16Nx_Enable(T16_timer);

    return;
}

/*********************************************************
函数名: void T16N3Init(void)
描  述: T16N3初始化
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16N3Init(void)
{
    T16Nx_BaseInitStruType x;
    T16N_TypeDef *T16_timer = T16N3;
	memset(&x, 0, sizeof(x));

    x.T16Nx_ClkS   = T16Nx_ClkS_PCLK;
    x.T16Nx_Mode   = T16Nx_Mode_TC0;
    x.T16Nx_SYNC   = Disable;
    x.T16Nx_EDGE   = T16Nx_EDGE_Rise;
    x.T16Nx_PREMAT = 0xFF;
    T16Nx_BaseInit(T16_timer, &x);
    T16N1->CON2.REGBUF_EN = 0x00;
    T16Nx_MAT0ITConfig(T16_timer, T16Nx_Clr_Int);
    T16Nx_SetMAT0(T16_timer, SystemCoreClock / (256 * 4));  /* 定时1/4s */
    T16Nx_ITConfig(T16_timer, T16Nx_IT_MAT0, Enable);

    if (T16_timer == T16N0)
    {
        NVIC_Init(NVIC_T16N0_IRQn, NVIC_Priority_1, Enable);
    }
    else if (T16_timer == T16N1)
    {
        NVIC_Init(NVIC_T16N1_IRQn, NVIC_Priority_1, Enable);
    }
    else if (T16_timer == T16N2)
    {
        NVIC_Init(NVIC_T16N2_IRQn, NVIC_Priority_1, Enable);
    }
    else if (T16_timer == T16N3)
    {
        NVIC_Init(NVIC_T16N3_IRQn, NVIC_Priority_1, Enable);
    }

    T16Nx_Enable(T16_timer);

    return;
}


/*************************END OF FILE**********************/
