/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  irqhandler.c
 * @作  者:  AE Team
 * @版  本:  V1.01
 * @日  期:  2022/07/25
 * @描  述:  系统滴答模块程序头文件
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#include "irqhandler.h"

void NMI_IRQHandler(void)
{

}

void HardFault_IRQHandler(void)
{
    while (1)
    {
    }
}

void SVC_IRQHandler(void)
{

}

void PendSV_IRQHandler(void)
{

}

/***************************************************************
 函数名: void SysTick_IRQHandler(void)
 描  述：systick中断函数
 输入值：无
 输出值：无
 返回值：无
***************************************************************/
void SysTick_IRQHandler(void)
{
    TimingDelay_Decrement();
}

/***************************************************************
 函数名: void I2C0_IRQHandler(void)
 描  述：IIC中断函数
 输入值：无
 输出值：无
 返回值：无
***************************************************************/
void I2C0_IRQHandler(void)
{
    if ((IIC_GetFlagStatus(I2C0, IIC_IF_SR) == SET) && IIC_GetITStatus(I2C0, IIC_IT_SR) == SET)
    {
		IIC_ClearITPendingBit(I2C0, IIC_CLR_SR);
		
		if (IIC_GetRWMode(I2C0) == IIC_Mode_Read)	/* 判断I2C工作读写状态读取 */
        {
            IIC0_RDTrigger();						/* I2C接收数据触发 */
        }
        else
        {
            IIC_ClearITPendingBit(I2C0, IIC_CLR_TIDLE);  /* 清除发送空闲中断标志 */
            IIC_SendByte(I2C0, g_txbuf[g_tx_count++]);   /* 发送数据 */
            IIC_ITConfig(I2C0, IIC_IT_TIDLE, Enable);    /* 使能发送空闲中断 */
        }
    }
	
    if ((IIC_GetFlagStatus(I2C0, IIC_IF_SP) == SET) && IIC_GetITStatus(I2C0, IIC_IT_SP) == SET)
    {
		IIC_ClearITPendingBit(I2C0, IIC_CLR_SP);
        g_ending_flag = 1;
    }
	
    if ((IIC_GetFlagStatus(I2C0, IIC_IF_TIDLE) == SET) && IIC_GetITStatus(I2C0, IIC_IT_TIDLE) == SET)
    {
		IIC_ClearITPendingBit(I2C0, IIC_CLR_TIDLE);
		
        if ((g_tx_count < g_tx_length) && (IIC_GetFlagStatus(I2C0, IIC_IF_NA) != SET))
        {
            IIC_SendByte(I2C0, g_txbuf[g_tx_count++]);
        }
		else
        {
			IIC0_SPTrigger();   /* I2C停止位触发 */
			IIC_ITConfig(I2C0, IIC_IT_TIDLE, Disable);    /* 禁止发送空闲中断 */			
        }
    }

    if (IIC_GetFlagStatus(I2C0, IIC_IF_RB) == SET && IIC_GetITStatus(I2C0, IIC_IT_RB) == SET)
    {
		if (g_rx_count < g_rx_length)
        {
			g_rxbuf[g_rx_count++] = IIC_RecByte(I2C0);
			
			/* 接收最后一个字节前需要将RDM配置为接收一字节发送NACK来正确结束接收过程 */
			if (g_rx_count == g_rx_length - 1)
			{
				IIC_RecModeConfig(I2C0, IIC_RecMode_1);
			}
			
			/* 必须每次都设置触发位，否则下次将不会进入中断 */
			IIC0_RDTrigger();
			
			if (g_rx_count == g_rx_length)
			{
				IIC_ITConfig(I2C0, IIC_IT_RB, Disable);
				IIC0_SPTrigger();   /* I2C停止位触发 */
			}
		}
    }
}


/*************************END OF FILE**********************/
