/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  main.c
 * @作  者:  AE Team
 * @版  本:  V1.00
 * @日  期:  2022/07/25
 * @描  述:  IIC E2PROM demo
          引脚连接：
          ------------------------
          IIC EEPROM:
          ------------------------
          PA4 - SCL
          PA5 - SDA
          ------------------------
          UART:
          ------------------------
          TXD - PA23
          RXD - PA22
          ------------------------
          本例程使用的E2PROM型号为24C04B(4K)，可直接连接通用开发板HRSDK-GMB-01
          上位机使用SecureCRT接收MCU发送的数据
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


#include "main.h"
#include "stdio.h"
#include "iic.h"

uint8_t wbuf[20];
uint8_t rbuf[20] ;

int main()
{
    HRC_Config(Enable, SCU_HRC_48M, Enable);    /* 配置HRC时钟频率 */
    SystemInit();                               /* 配置时钟 */
    DeviceClockAllEnable();                     /* 打开所有外设时钟 */

    User_SysTickInit();
    e2prom_init();

    /* 在E2PROM的0x13地址上写入0xCD */
    if (0x0 == e2prom_byte_write(0x13, 0xCD, rom_size_1k))
		printf("byte write finished, write content: 0xCD\r\n");
	else
		printf("byte write error\r\n");

    /* 从E2PROM的0x13地址上读取一字节数据 */
    if (0x0 == e2prom_random_read(0x13, rbuf, rom_size_1k))
		printf("random read finished, readout content: 0x%X\r\n", rbuf[0]);
	else
		printf("random read error\r\n");

    /* 在E2PROM的0xA0地址处写入essemi */
    memcpy(wbuf, "essemi", 6);
    if (0x0 == e2prom_page_write(0xA0, wbuf, page_size_8, rom_size_1k))
		printf("page write finished, write content: essemi\r\n");
	else
		printf("page write error\r\n");

    /* 从E2PROM的0xA0地址处读取6字节数据 */
    if (0x0 == e2prom_sequential_read(0xA0, rbuf, 6, rom_size_1k))
		printf("sequential read finished, readout content: %s\r\n", rbuf);
	else
		printf("sequential read error\r\n");

    while (1)
    {
    }

}


/*************************END OF FILE**********************/

