/**********************************************************************************************************************
    Program Name    : EEPROM Emulation Software (EES)
    
    File Name       : r_ees_sub_api.h
    Program Version : V1.00
    Device(s)       : microcontroller
    Description     : Sub functions for EES
**********************************************************************************************************************/

#ifndef R_EES_SUB_API_H
#define R_EES_SUB_API_H

#include "r_ees.h"

/**********************************************************************************************************************
 Prototype declaration
 *********************************************************************************************************************/

extern __near st_ees_control_flags_t     g_st_ees_control_flags;
extern __near st_ees_control_variables_t g_st_ees_control_variables;

extern R_EES_FAR_FUNC bool r_ees_is_valid_configuration(void);
extern R_EES_FAR_FUNC bool r_ees_is_valid_requester(st_ees_request_t __near * ionp_st_ees_request);
extern R_EES_FAR_FUNC void r_ees_fsm_startup_state_00(void);
extern R_EES_FAR_FUNC void r_ees_fsm_startup_state_01(void);
extern R_EES_FAR_FUNC void r_ees_fsm_startup_state_02(void);
extern R_EES_FAR_FUNC void r_ees_fsm_startup_state_03(void);
extern R_EES_FAR_FUNC void r_ees_fsm_startup_state_05(void);
extern R_EES_FAR_FUNC void r_ees_fsm_startup_state_06(void);
extern R_EES_FAR_FUNC void r_ees_fsm_startup_state_07(void);
extern R_EES_FAR_FUNC void r_ees_fsm_startup_state_08(void);
extern R_EES_FAR_FUNC void r_ees_fsm_startup_state_09(void);
extern R_EES_FAR_FUNC void r_ees_fsm_write_state_00(void);
extern R_EES_FAR_FUNC void r_ees_fsm_write_state_01(void);
extern R_EES_FAR_FUNC void r_ees_fsm_write_state_02(void);
extern R_EES_FAR_FUNC void r_ees_fsm_write_state_03(void);
extern R_EES_FAR_FUNC void r_ees_fsm_write_state_04(void);
extern R_EES_FAR_FUNC void r_ees_fsm_read_state_00(void);
extern R_EES_FAR_FUNC void r_ees_fsm_read_state_01(void);
extern R_EES_FAR_FUNC void r_ees_fsm_refresh_state_00(void);
extern R_EES_FAR_FUNC void r_ees_fsm_refresh_state_01(void);
extern R_EES_FAR_FUNC void r_ees_fsm_refresh_state_02(void);
extern R_EES_FAR_FUNC void r_ees_fsm_refresh_state_03(void);
extern R_EES_FAR_FUNC void r_ees_fsm_refresh_state_04(void);
extern R_EES_FAR_FUNC void r_ees_fsm_refresh_state_05(void);
extern R_EES_FAR_FUNC void r_ees_fsm_refresh_state_06(void);
extern R_EES_FAR_FUNC void r_ees_fsm_refresh_state_07(void);
extern R_EES_FAR_FUNC void r_ees_fsm_refresh_state_08(void);
extern R_EES_FAR_FUNC void r_ees_fsm_refresh_state_09(void);
extern R_EES_FAR_FUNC void r_ees_fsm_refresh_state_10(void);
extern R_EES_FAR_FUNC void r_ees_fsm_refresh_state_11(void);
extern R_EES_FAR_FUNC void r_ees_fsm_refresh_state_12(void);
extern R_EES_FAR_FUNC void r_ees_fsm_refresh_state_13(void);
extern R_EES_FAR_FUNC void r_ees_fsm_refresh_state_14(void);
extern R_EES_FAR_FUNC void r_ees_fsm_refresh_state_15(void);
extern R_EES_FAR_FUNC void r_ees_fsm_refresh_state_16(void);
extern R_EES_FAR_FUNC void r_ees_fsm_refresh_state_17(void);
extern R_EES_FAR_FUNC void r_ees_fsm_format_state_00(void);
extern R_EES_FAR_FUNC void r_ees_fsm_format_state_01(void);
extern R_EES_FAR_FUNC void r_ees_fsm_format_state_02(void);
extern R_EES_FAR_FUNC void r_ees_fsm_format_state_03(void);
extern R_EES_FAR_FUNC void r_ees_fsm_format_state_04(void);
extern R_EES_FAR_FUNC void r_ees_fsm_format_state_05(void);
extern R_EES_FAR_FUNC void r_ees_fsm_format_state_06(void);
extern R_EES_FAR_FUNC void r_ees_fsm_format_state_07(void);
extern R_EES_FAR_FUNC void r_ees_fsm_format_state_08(void);
extern R_EES_FAR_FUNC void r_ees_fsm_format_state_09(void);
extern R_EES_FAR_FUNC void r_ees_fsm_format_state_10(void);
extern R_EES_FAR_FUNC void r_ees_fsm_format_state_11(void);
extern R_EES_FAR_FUNC void r_ees_fsm_shutdown_state_00(void);
extern R_EES_FAR_FUNC void r_ees_fsm_exrfd_cmd_erase_state_00(void);
extern R_EES_FAR_FUNC void r_ees_fsm_exrfd_cmd_bw_state_00(void);
extern R_EES_FAR_FUNC void r_ees_fsm_exrfd_cmd_inner_blankcheck_state_00(void);
extern R_EES_FAR_FUNC void r_ees_fsm_exrfd_cmd_write_state_00(void);
extern R_EES_FAR_FUNC void r_ees_fsm_exrfd_cmd_inner_write_state_00(void);
extern R_EES_FAR_FUNC void r_ees_fsm_exrfd_cmd_read_state_00(void);
extern R_EES_FAR_FUNC void r_ees_fsm_exrfd_cmd_state_01(void);
extern R_EES_FAR_FUNC void r_ees_fsm_exit_state(void);

#endif /* end of R_EES_SUB_API_H */
