/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  irqhandler.c
 * @作  者:  AE Team
 * @版  本:  V1.00
 * @日  期:  2022/07/25
 * @描  述:
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
 
#include "irqhandler.h"

void NMI_IRQHandler(void)
{

}

void HardFault_IRQHandler(void)
{
    while (1);
}

void SVC_IRQHandler(void)
{

}

void PendSV_IRQHandler(void)
{

}

void SysTick_IRQHandler(void)
{
    TimingDelay_Decrement();
}

/*********************************************************
函数名: void ADC_IRQHandler(void)
描  述: ADC中断处理
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void ADC_IRQHandler()
{
    if ((ADC_GetIFStatus(ADC_IF_ACPOVER) == SET) && (ADC_GetIEStatus(ADC_IE_ACPOVER) == SET))
    {
        ADC_ClearIFStatus(ADC_IF_ACPOVER);
        meanvalue = ADC_GetACPMeanValue();
        LightOff(LED1_PIN);
    }

    if ((ADC_GetIFStatus(ADC_IF_ACPMIN) == SET) && (ADC_GetIEStatus(ADC_IE_ACPMIN) == SET))
    {
        ADC_ClearIFStatus(ADC_IF_ACPMIN);
        LightOn(LED1_PIN);
    }

    if ((ADC_GetIFStatus(ADC_IF_ACPMAX) == SET) && (ADC_GetIEStatus(ADC_IE_ACPMAX) == SET))
    {
        ADC_ClearIFStatus(ADC_IF_ACPMAX);
        LightOn(LED1_PIN);
    }

    if ((ADC_GetIFStatus(ADC_IF) == SET) && (ADC_GetIEStatus(ADC_IE) == SET))
    {
        ADC_ClearIFStatus(ADC_IF);
    }
}

 
/*************************END OF FILE**********************/
