/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  adc.c
 * @作  者:  AE Team
 * @版  本:  V1.00
 * @日  期:  2022/07/25
 * @描  述:  ADC模块程序
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


#include "adc.h"
#include "string.h"

/***************************************************************
函数名：ADCInit
描  述：ADC 初始化
输入值：无
输出值：无
返回值：无
***************************************************************/
void ADCInit(void)
{
    ADC_InitStruType x;
    GPIO_InitSettingType y;
    memset(&x, 0, sizeof(x));
    memset(&y, 0, sizeof(y));

    y.Signal = GPIO_Pin_Signal_Analog;
    y.Dir = GPIO_Direction_Input;
    y.Func = GPIO_Reuse_Func0;
    GPIO_Init(GPIO_Pin_B9, &y);

    x.CLKS = ADC_CLKS_PCLK;
    x.CLKDIV = ADC_CLKDIV_1_32;     /* ADC时钟源预分频 */
    x.VREF_SEL = ADC_VREF_SEL_0;    /* 内部参考电压2.048v */
    x.VREFP = ADC_VREFP_VDD;        /* 选择芯片的工作电压VDD */
    x.VREFN = ADC_VREFN_VSS;        /* 负向参考电压选择 */
    x.CHS = ADC_CHS_AIN4;
    x.SMPS = ADC_SMPS_HARD;         /* AD采样模式为硬件控制 */
    x.ST = 10;                      /* AD采样时间选择 */
    x.BITSEL = ADC_BITSEL_12;       /* AD分辨率12位 */
    ADC_Init(&x);

    ADC_ACP_Disable();
    ADC_IE_Enable();                /* ADC中断使能 */
    NVIC_Init(NVIC_ADC_IRQn, NVIC_Priority_1, Enable);
}

/***************************************************************
 函数名：ADCACPConfig
 描  述：ADC ACP功能初始化
 输入值：无
 输出值：无
 返回值：无
***************************************************************/
void ADCACPConfig(void)
{
    ADC_ACP_TypeDef x;
    memset(&x, 0, sizeof(x));

    x.ACP_EN = ENABLE;
    x.ACPC_OVER_TIME = 0x3;             /* 自动转换比较的溢出时间 */
    x.ACPC_TIMES = ADC_ACPC_TIMES_8;    /* 自动转换比较次数选择位 */
    x.ACPC_MIN_TARGET = 0x010;          /* 自动比较低阈值，当mean值小于该值时，会触发中断 */
    x.ACPC_MAX_TARGET = 0x700;          /* 自动比较高阈值，当mean值大于该值时，会触发中断 */
    ADC_ACPConfig(&x);
}


/*************************END OF FILE**********************/
