/*********************************************************
 *Copyright (C), 2015, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  lib_wdt.c
 * @作  者:  AE Team
 * @版  本:  V1.01
 * @日  期:  2022/07/25
 * @描  述:  WDT模块库函数
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
 
 
#include "lib_wdt.h"
#include "system_FS030.h"

/************************************************WWDT*************************************************/
/****************************************
  函数名：WWDT_Init
  描  述：UART初始化
  输入值：初始化结构体
  返回值：无
**************************************/
void WWDT_Init(WWDT_InitStruType *WWDT_InitStruct)
{
    uint32_t tmp;

    WWDT_RegUnLock();

    if (WWDT_InitStruct->WDT_Clock != WWDT_CLOCK_PCLK)
        tmp = (uint32_t)(32 * WWDT_InitStruct->WDT_Tms);
    else
        tmp = SystemCoreClock / 1000 * WWDT_InitStruct->WDT_Tms;

    WWDT->LOAD.LOAD = tmp;
    WWDT->CON.CLKS = WWDT_InitStruct->WDT_Clock;
    WWDT->CON.IE = WWDT_InitStruct->WDT_IE;
    WWDT->CON.RSTEN = WWDT_InitStruct->WDT_Rst;
    WWDT->CON.WWDTWIN = WWDT_InitStruct->WDT_Win;

    WWDT_RegLock();

    return;
}

/*************************************
  函数名：WWDT_SetReloadValue
  描  述：设置WWDT重载的初值
  输入值：初始值，32-bit无符号整数
  返回值：无
 **************************************/
void WWDT_SetReloadValue(uint32_t Value)
{
    WWDT->LOAD.LOAD = Value;
    return;
}

/*************************************
  函数名：WWDT_GetValue
  描  述：获取WWDT当前值
  输入值：无
  返回值：当前值
 **************************************/
uint32_t WWDT_GetValue(void)
{
    return (uint32_t)WWDT->VALUE.Word;
}

/*************************************
  函数名：WWDT_GetFlagStatus
  描  述：获取WWDT中断状态
  输入值：无
  返回值：SET/RESET
 **************************************/
FlagStatus WWDT_GetFlagStatus(void)
{
    FlagStatus bitstatus = RESET;

    if (WWDT->RIS.WWDTIF != RESET)
        bitstatus = SET;

    return  bitstatus;
}

/*************************************
  函数名：WWDT_GetITStatus
  描  述：获取WWDT中断使能状态
  输入值：无
  返回值：SET/RESET
 **************************************/
FlagStatus WWDT_GetITStatus(void)
{
    FlagStatus bitstatus = RESET;

    if (WWDT->CON.IE != RESET)
        bitstatus = SET;

    return  bitstatus;
}


/************************************************IWDT*************************************************/
/*************************************
  函数名：IWDT_Init
  描  述：IWDT初始化
  输入值：初始化结构体
  返回值：无
 **************************************/
void IWDT_Init(IWDT_InitStruType *IWDT_InitStruct)
{
    uint32_t tmp;

    IWDT_RegUnLock();

    if (IWDT_InitStruct->WDT_Clock != IWDT_CLOCK_PCLK)
        tmp = (uint32_t)(32 * IWDT_InitStruct->WDT_Tms);
    else
        tmp = SystemCoreClock / 1000 * IWDT_InitStruct->WDT_Tms;

    IWDT->LOAD.LOAD = tmp;
    IWDT->CON.CLKS = IWDT_InitStruct->WDT_Clock;
    IWDT->CON.IE = IWDT_InitStruct->WDT_IE;
    IWDT->CON.RSTEN = IWDT_InitStruct->WDT_Rst;

    IWDT_RegLock();

    return;
}

/*************************************
  函数名：IWDT_SetReloadValue
  描  述：设置IWDT重载的初值
  输入值：初始值，32-bit无符号整数
  返回值：无
 **************************************/
void IWDT_SetReloadValue(uint32_t Value)
{
    IWDT->LOAD.LOAD = Value;
    return;
}

/*************************************
  函数名：IWDT_GetValue
  描  述：获取IWDT当前值
  输入值：无
  返回值：当前值
 **************************************/
uint32_t IWDT_GetValue(void)
{
    return (uint32_t)IWDT->VALUE.VALUE;
}

/*************************************
  函数名：IWDT_GetFlagStatus
  描  述：获取IWDT中断状态
  输入值：无
  返回值：SET/RESET
 **************************************/
FlagStatus IWDT_GetFlagStatus(void)
{
    FlagStatus bitstatus = RESET;

    if (IWDT->RIS.WDTIF != RESET)
        bitstatus = SET;

    return  bitstatus;
}

/*************************************
  函数名：IWDT_GetITStatus
  描  述：获取IWDT使能中断状态
  输入值：无
  返回值：SET/RESET
 **************************************/
FlagStatus IWDT_GetITStatus(void)
{
    FlagStatus bitstatus = RESET;

    if (IWDT->CON.IE != RESET)
        bitstatus = SET;

    return  bitstatus;
}

 
/*************************END OF FILE**********************/
