﻿ /*********************************************************
 *Copyright (C), 2015, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  initram.c
 * @作  者:  AE Team
 * @版  本:  V1.01
 * @日  期:  2022/07/25
 * @描  述:  This file provides ram init functions for idesigner IDE.
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
 
 
 /***********************************************************************
若用户需要初始化全局变量，需要在进入主函数前调用该函数
************************************************************************/

extern unsigned long _sidata;
extern unsigned long __data_start__;
extern unsigned long __data_end__;
extern unsigned long __bss_start__;
extern unsigned long __bss_end__;

extern unsigned long _my_ram1_start;
extern unsigned long _my_ram1_size;
extern unsigned long _my_ram2_start;
extern unsigned long _my_ram2_size;
extern unsigned long _my_ram3_start;
extern unsigned long _my_ram3_size;
extern unsigned long _my_rom_end;

void  InitRam(void)
{
    unsigned long volatile *pulSrc, *pulDest;
    unsigned int volatile _my_rom_address;

    /***********************************************************************
    初始化有初始值的变量
    _sidata标识符就是初始化变量的rom镜像的起始地址，这是链接文件上定义的。
    __data_start__标识符就是全局变量在ram中的起始地址,__data_end__标识符就是ram中的结束地址
    ************************************************************************/
    pulSrc = &_sidata;

    for (pulDest = (unsigned long volatile *)&__data_start__; pulDest < (unsigned long volatile *)&__data_end__;)
    {
        *(pulDest++) = *(pulSrc++);
    }


    /*同理下面就是无初始值的变量，全清零*/
    for (pulDest = (unsigned long volatile *)&__bss_start__; pulDest < (unsigned long volatile *)&__bss_end__;)
    {
        *(pulDest++) = 0;
    }

    /*初始化Ram程序*/
    memcpy(&_my_ram1_start, &_my_rom_end, &_my_ram1_size);
    _my_rom_address = (unsigned int)&_my_rom_end + (unsigned int)&_my_ram1_size;
    memcpy(&_my_ram2_start, _my_rom_address, &_my_ram2_size);
    _my_rom_address = (unsigned int)&_my_rom_end + (unsigned int)&_my_ram1_size + (unsigned int)&_my_ram2_size;
    memcpy(&_my_ram3_start, _my_rom_address, &_my_ram3_size);
}

 
/*************************END OF FILE**********************/
