/**
  **************************************************************************************
  * @file    REG_FS030.h
  * @brief   FS030 Head File
  *
  * @version V0.01
  * @data    25/07/2022
  * @author  Eastsoft MCU Software Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __FS030_H__
#define __FS030_H__


#define __I volatile const /* defines 'read only' permissions */
#define __O volatile /* defines 'write only' permissions */
#define __IO volatile /* defines 'read / write' permissions */


#define __CM0_REV 0 /* Core Revision r0p0 */
#define __NVIC_PRIO_BITS 2 /* 2 Bits for the Priority Levels */
#define __Vendor_SysTickConfig 0 /* Set to 1 if different SysTick Config is used */

typedef enum IRQn
{
    /******************************* Cortex-M0 Kernel Exceptions Numbers *****************************/
    RST_IRQn = -15,
    NonMaskableInt_IRQn = -14,
    HardFault_IRQn = -13,
    SVC_IRQn = -5,
    PendSV_IRQn = -2,
    SysTick_IRQn = -1,
    /*******************************  FS030 Processor Peripheral Exceptions Numbers **************/
    PINT0_IRQn = 0,
    PINT1_IRQn = 1,
    PINT2_IRQn = 2,
    PINT3_IRQn = 3,
    PINT4_IRQn = 4,
    PINT5_IRQn = 5,
    PINT6_IRQn = 6,
    PINT7_IRQn = 7,
    T16N0_IRQn = 8,
    T16N1_IRQn = 9,
    T16N2_IRQn = 10,
    T16N3_IRQn = 11,
    T32N0_IRQn = 12,
    Reserved0_IRQn = 13,
    Reserved1_IRQn = 14,
    WWDT_IRQn = 15,
    IWDT_IRQn = 16,
    Reserved6_IRQn = 17,
    KINT_IRQn = 18,
    ADC_IRQn = 19,
    Reserved3_IRQn = 20,
    LVD_IRQn = 21,
    Reserved2_IRQn = 22,
    UART0_IRQn = 23,
    UART1_IRQn = 24,
    UART2_IRQn = 25,
    Reserved4_IRQn = 26,
    Reserved7_IRQn = 27,
    SPI1_IRQn = 28,
    I2C0_IRQn = 29,
    Reserved5_IRQn = 30,
    CCM_IRQn = 31,
} IRQn_Type;


#include "core_cm0.h"
#include <stdint.h>

/******************************************************************************/
/*                              设备特殊寄存器结构定义                        */
/******************************************************************************/

/*   允许匿名结构和匿名联合    */
#if   defined ( __CC_ARM )
    #pragma anon_unions
#endif

typedef union
{
    struct
    {
        uint32_t PROT: 1;
        uint32_t RESERVED0: 31;
    };
    uint32_t Word;
} SCU_PROT_Typedef;

typedef union
{
    struct
    {
        uint32_t NMIEN: 1;
        uint32_t NMICS: 5;
        uint32_t RESERVED0: 26;
    };
    uint32_t Word;
} SCU_NMICON_Typedef;

typedef union
{
    struct
    {
        uint32_t PORF: 1;
        uint32_t PORRCF: 1;
        uint32_t PORRSTF: 1;
        uint32_t BORF: 1;
        uint32_t WDTRSTF: 1;
        uint32_t MRSTF: 1;
        uint32_t SOFT_RSTF: 1;
        uint32_t POR_LOST: 1;
        uint32_t CFG_RST: 1;
        uint32_t LKRSTF: 1;
        uint32_t RESERVED0: 22;
    };
    uint32_t Word;
} SCU_PWRC_Typedef;

typedef union
{
    struct
    {
        uint32_t FLAG0: 1;
        uint32_t FLAG1: 1;
        uint32_t FLAG2: 1;
        uint32_t RESERVED0: 29;
    };
    uint32_t Word;
} SCU_FAULTFLAG_Typedef;

typedef union
{
    struct
    {
        uint32_t ACCT: 4;
        uint32_t RESERVED0: 28;
    };
    uint32_t Word;
} SCU_FLASHWAIT_Typedef;

typedef union
{
    struct
    {
        uint32_t EN: 1;
        uint32_t FLTEN: 1;
        uint32_t RESERVED0: 2;
        uint32_t VS: 4;
        uint32_t IF: 1;
        uint32_t IE: 1;
        uint32_t IFS: 3;
        uint32_t RESERVED1: 2;
        uint32_t LVDO: 1;
        uint32_t RESERVED2: 16;
    };
    uint32_t Word;
} SCU_LVDCON_Typedef;

typedef union
{
    struct
    {
        uint32_t EN: 1;
        uint32_t RESERVED0: 3;
        uint32_t IE: 1;
        uint32_t IFS: 3;
        uint32_t IF: 1;
        uint32_t RESERVED1: 7;
        uint32_t FLAG: 1;
        uint32_t RESERVED2: 15;
    };
    uint32_t Word;
} SCU_CCM_Typedef;

typedef union
{
    struct
    {
        uint32_t T16N0EN: 1;
        uint32_t T16N1EN: 1;
        uint32_t T16N2EN: 1;
        uint32_t T16N3EN: 1;
        uint32_t RESERVED0: 4;
        uint32_t T32N0EN: 1;
        uint32_t RESERVED1: 23;
    };
    uint32_t Word;
} SCU_TIMEREN_Typedef;

typedef union
{
    struct
    {
        uint32_t T16N0DIS: 1;
        uint32_t T16N1DIS: 1;
        uint32_t T16N2DIS: 1;
        uint32_t T16N3DIS: 1;
        uint32_t RESERVED0: 4;
        uint32_t T32N0DIS: 1;
        uint32_t RESERVED1: 23;
    };
    uint32_t Word;
} SCU_TIMERDIS_Typedef;

typedef union
{
    struct
    {
        uint32_t CLK_SEL: 2;
        uint32_t RESERVED0: 10;
        uint32_t SYSCLK_DIV: 3;
        uint32_t RESERVED1: 1;
        uint32_t CLKFLT_BY: 8;
        uint32_t CLKOUT0_SEL: 2;
        uint32_t CLKOUT1_SEL: 2;
        uint32_t RESERVED2: 4;
    };
    uint32_t Word;
} SCU_SCLKEN0_Typedef;

typedef union
{
    struct
    {
        uint32_t XTAL_EN: 1;
        uint32_t HRC_EN: 1;
        uint32_t HRC_FRE: 2;
        uint32_t RESERVED0: 12;
        uint32_t XTAL_RDY: 1;
        uint32_t HRC_RDY: 1;
        uint32_t RESERVED1: 14;
    };
    uint32_t Word;
} SCU_SCLKEN1_Typedef;

typedef union
{
    struct
    {
        uint32_t SCU_EN: 1;
        uint32_t GPIO_EN: 1;
        uint32_t IAP_EN: 1;
        uint32_t RESERVED0: 1;
        uint32_t ADC_EN: 1;
        uint32_t RESERVED1: 1;
        uint32_t WWDT_EN: 1;
        uint32_t IWDT_EN: 1;
        uint32_t T16N0_EN: 1;
        uint32_t T16N1_EN: 1;
        uint32_t T16N2_EN: 1;
        uint32_t T16N3_EN: 1;
        uint32_t T32N0_EN: 1;
        uint32_t RESERVED2: 3;
        uint32_t UART0_EN: 1;
        uint32_t UART1_EN: 1;
        uint32_t UART2_EN: 1;
        uint32_t RESERVED3: 6;
        uint32_t SPI1_EN: 1;
        uint32_t RESERVED4: 2;
        uint32_t I2C0_EN: 1;
        uint32_t RESERVED5: 3;
    };
    uint32_t Word;
} SCU_PCLKEN_Typedef;

typedef union
{
    struct
    {
        uint32_t WAKEUPTIME: 12;
        uint32_t MOSC_EN: 1;
        uint32_t CLKFLT_EN: 1;
        uint32_t VROSCEN: 1;
        uint32_t STPRTNEN: 1;
        uint32_t RESERVED0: 1;
        uint32_t LDOLP_VOSEL: 2;
        uint32_t RESERVED1: 1;
        uint32_t LP_STOP: 1;
        uint32_t BG_STOP: 1;
        uint32_t RESERVED2: 1;
        uint32_t FLS_STOP: 1;
        uint32_t RESERVED3: 8;
    };
    uint32_t Word;
} SCU_WAKEUPTIME_Typedef;

typedef union
{
    struct
    {
        uint32_t EN: 1;
        uint32_t RESERVED0: 31;
    };
    uint32_t Word;
} SCU_TBLREMAPEN_Typedef;

typedef union
{
    struct
    {
        uint32_t TBLOFF: 32;
    };
    uint32_t Word;
} SCU_TBLOFF_Typedef;

typedef struct
{
    __IO SCU_PROT_Typedef PROT;
    __IO SCU_NMICON_Typedef NMICON;
    __IO SCU_PWRC_Typedef PWRC;
    __IO SCU_FAULTFLAG_Typedef FAULTFLAG;
    uint32_t RESERVED0[4] ;
    __IO SCU_FLASHWAIT_Typedef FLASHWAIT;
    uint32_t RESERVED1 ;
    __IO SCU_LVDCON_Typedef LVDCON;
    __IO SCU_CCM_Typedef CCM;
    uint32_t RESERVED2 ;
    __IO SCU_TIMEREN_Typedef TIMEREN;
    __IO SCU_TIMERDIS_Typedef TIMERDIS;
    uint32_t RESERVED3 ;
    __IO SCU_SCLKEN0_Typedef SCLKEN0;
    __IO SCU_SCLKEN1_Typedef SCLKEN1;
    __IO SCU_PCLKEN_Typedef PCLKEN;
    __IO SCU_WAKEUPTIME_Typedef WAKEUPTIME;
    uint32_t RESERVED4[4] ;
    __IO SCU_TBLREMAPEN_Typedef TBLREMAPEN;
    __IO SCU_TBLOFF_Typedef TBLOFF;
} SCU_TypeDef;

typedef union
{
    struct
    {
        uint32_t PORT_0: 1;
        uint32_t PORT_1: 1;
        uint32_t PORT_2: 1;
        uint32_t PORT_3: 1;
        uint32_t PORT_4: 1;
        uint32_t PORT_5: 1;
        uint32_t PORT_6: 1;
        uint32_t PORT_7: 1;
        uint32_t PORT_8: 1;
        uint32_t PORT_9: 1;
        uint32_t PORT_10: 1;
        uint32_t PORT_11: 1;
        uint32_t PORT_12: 1;
        uint32_t PORT_13: 1;
        uint32_t PORT_14: 1;
        uint32_t PORT_15: 1;
        uint32_t PORT_16: 1;
        uint32_t PORT_17: 1;
        uint32_t PORT_18: 1;
        uint32_t PORT_19: 1;
        uint32_t PORT_20: 1;
        uint32_t PORT_21: 1;
        uint32_t PORT_22: 1;
        uint32_t PORT_23: 1;
        uint32_t PORT_24: 1;
        uint32_t PORT_25: 1;
        uint32_t PORT_26: 1;
        uint32_t PORT_27: 1;
        uint32_t PORT_28: 1;
        uint32_t PORT_29: 1;
        uint32_t PORT_30: 1;
        uint32_t PORT_31: 1;
    };
    uint32_t Word;
} GPIO_PAPORT_Typedef;

typedef union
{
    struct
    {
        uint32_t DATA_0: 1;
        uint32_t DATA_1: 1;
        uint32_t DATA_2: 1;
        uint32_t DATA_3: 1;
        uint32_t DATA_4: 1;
        uint32_t DATA_5: 1;
        uint32_t DATA_6: 1;
        uint32_t DATA_7: 1;
        uint32_t DATA_8: 1;
        uint32_t DATA_9: 1;
        uint32_t DATA_10: 1;
        uint32_t DATA_11: 1;
        uint32_t DATA_12: 1;
        uint32_t DATA_13: 1;
        uint32_t DATA_14: 1;
        uint32_t DATA_15: 1;
        uint32_t DATA_16: 1;
        uint32_t DATA_17: 1;
        uint32_t DATA_18: 1;
        uint32_t DATA_19: 1;
        uint32_t DATA_20: 1;
        uint32_t DATA_21: 1;
        uint32_t DATA_22: 1;
        uint32_t DATA_23: 1;
        uint32_t DATA_24: 1;
        uint32_t DATA_25: 1;
        uint32_t DATA_26: 1;
        uint32_t DATA_27: 1;
        uint32_t DATA_28: 1;
        uint32_t DATA_29: 1;
        uint32_t DATA_30: 1;
        uint32_t DATA_31: 1;
    };
    uint32_t Word;
} GPIO_PADATA_Typedef;

typedef union
{
    struct
    {
        uint32_t DATABSR_0: 1;
        uint32_t DATABSR_1: 1;
        uint32_t DATABSR_2: 1;
        uint32_t DATABSR_3: 1;
        uint32_t DATABSR_4: 1;
        uint32_t DATABSR_5: 1;
        uint32_t DATABSR_6: 1;
        uint32_t DATABSR_7: 1;
        uint32_t DATABSR_8: 1;
        uint32_t DATABSR_9: 1;
        uint32_t DATABSR_10: 1;
        uint32_t DATABSR_11: 1;
        uint32_t DATABSR_12: 1;
        uint32_t DATABSR_13: 1;
        uint32_t DATABSR_14: 1;
        uint32_t DATABSR_15: 1;
        uint32_t DATABSR_16: 1;
        uint32_t DATABSR_17: 1;
        uint32_t DATABSR_18: 1;
        uint32_t DATABSR_19: 1;
        uint32_t DATABSR_20: 1;
        uint32_t DATABSR_21: 1;
        uint32_t DATABSR_22: 1;
        uint32_t DATABSR_23: 1;
        uint32_t DATABSR_24: 1;
        uint32_t DATABSR_25: 1;
        uint32_t DATABSR_26: 1;
        uint32_t DATABSR_27: 1;
        uint32_t DATABSR_28: 1;
        uint32_t DATABSR_29: 1;
        uint32_t DATABSR_30: 1;
        uint32_t DATABSR_31: 1;
    };
    uint32_t Word;
} GPIO_PADATABSR_Typedef;

typedef union
{
    struct
    {
        uint32_t DATABCR_0: 1;
        uint32_t DATABCR_1: 1;
        uint32_t DATABCR_2: 1;
        uint32_t DATABCR_3: 1;
        uint32_t DATABCR_4: 1;
        uint32_t DATABCR_5: 1;
        uint32_t DATABCR_6: 1;
        uint32_t DATABCR_7: 1;
        uint32_t DATABCR_8: 1;
        uint32_t DATABCR_9: 1;
        uint32_t DATABCR_10: 1;
        uint32_t DATABCR_11: 1;
        uint32_t DATABCR_12: 1;
        uint32_t DATABCR_13: 1;
        uint32_t DATABCR_14: 1;
        uint32_t DATABCR_15: 1;
        uint32_t DATABCR_16: 1;
        uint32_t DATABCR_17: 1;
        uint32_t DATABCR_18: 1;
        uint32_t DATABCR_19: 1;
        uint32_t DATABCR_20: 1;
        uint32_t DATABCR_21: 1;
        uint32_t DATABCR_22: 1;
        uint32_t DATABCR_23: 1;
        uint32_t DATABCR_24: 1;
        uint32_t DATABCR_25: 1;
        uint32_t DATABCR_26: 1;
        uint32_t DATABCR_27: 1;
        uint32_t DATABCR_28: 1;
        uint32_t DATABCR_29: 1;
        uint32_t DATABCR_30: 1;
        uint32_t DATABCR_31: 1;
    };
    uint32_t Word;
} GPIO_PADATABCR_Typedef;

typedef union
{
    struct
    {
        uint32_t DATABRR_0: 1;
        uint32_t DATABRR_1: 1;
        uint32_t DATABRR_2: 1;
        uint32_t DATABRR_3: 1;
        uint32_t DATABRR_4: 1;
        uint32_t DATABRR_5: 1;
        uint32_t DATABRR_6: 1;
        uint32_t DATABRR_7: 1;
        uint32_t DATABRR_8: 1;
        uint32_t DATABRR_9: 1;
        uint32_t DATABRR_10: 1;
        uint32_t DATABRR_11: 1;
        uint32_t DATABRR_12: 1;
        uint32_t DATABRR_13: 1;
        uint32_t DATABRR_14: 1;
        uint32_t DATABRR_15: 1;
        uint32_t DATABRR_16: 1;
        uint32_t DATABRR_17: 1;
        uint32_t DATABRR_18: 1;
        uint32_t DATABRR_19: 1;
        uint32_t DATABRR_20: 1;
        uint32_t DATABRR_21: 1;
        uint32_t DATABRR_22: 1;
        uint32_t DATABRR_23: 1;
        uint32_t DATABRR_24: 1;
        uint32_t DATABRR_25: 1;
        uint32_t DATABRR_26: 1;
        uint32_t DATABRR_27: 1;
        uint32_t DATABRR_28: 1;
        uint32_t DATABRR_29: 1;
        uint32_t DATABRR_30: 1;
        uint32_t DATABRR_31: 1;
    };
    uint32_t Word;
} GPIO_PADATABRR_Typedef;

typedef union
{
    struct
    {
        uint32_t DIR_0: 1;
        uint32_t DIR_1: 1;
        uint32_t DIR_2: 1;
        uint32_t DIR_3: 1;
        uint32_t DIR_4: 1;
        uint32_t DIR_5: 1;
        uint32_t DIR_6: 1;
        uint32_t DIR_7: 1;
        uint32_t DIR_8: 1;
        uint32_t DIR_9: 1;
        uint32_t DIR_10: 1;
        uint32_t DIR_11: 1;
        uint32_t DIR_12: 1;
        uint32_t DIR_13: 1;
        uint32_t DIR_14: 1;
        uint32_t DIR_15: 1;
        uint32_t DIR_16: 1;
        uint32_t DIR_17: 1;
        uint32_t DIR_18: 1;
        uint32_t DIR_19: 1;
        uint32_t DIR_20: 1;
        uint32_t DIR_21: 1;
        uint32_t DIR_22: 1;
        uint32_t DIR_23: 1;
        uint32_t DIR_24: 1;
        uint32_t DIR_25: 1;
        uint32_t DIR_26: 1;
        uint32_t DIR_27: 1;
        uint32_t DIR_28: 1;
        uint32_t DIR_29: 1;
        uint32_t DIR_30: 1;
        uint32_t DIR_31: 1;
    };
    uint32_t Word;
} GPIO_PADIR_Typedef;

typedef union
{
    struct
    {
        uint32_t DIRBSR_0: 1;
        uint32_t DIRBSR_1: 1;
        uint32_t DIRBSR_2: 1;
        uint32_t DIRBSR_3: 1;
        uint32_t DIRBSR_4: 1;
        uint32_t DIRBSR_5: 1;
        uint32_t DIRBSR_6: 1;
        uint32_t DIRBSR_7: 1;
        uint32_t DIRBSR_8: 1;
        uint32_t DIRBSR_9: 1;
        uint32_t DIRBSR_10: 1;
        uint32_t DIRBSR_11: 1;
        uint32_t DIRBSR_12: 1;
        uint32_t DIRBSR_13: 1;
        uint32_t DIRBSR_14: 1;
        uint32_t DIRBSR_15: 1;
        uint32_t DIRBSR_16: 1;
        uint32_t DIRBSR_17: 1;
        uint32_t DIRBSR_18: 1;
        uint32_t DIRBSR_19: 1;
        uint32_t DIRBSR_20: 1;
        uint32_t DIRBSR_21: 1;
        uint32_t DIRBSR_22: 1;
        uint32_t DIRBSR_23: 1;
        uint32_t DIRBSR_24: 1;
        uint32_t DIRBSR_25: 1;
        uint32_t DIRBSR_26: 1;
        uint32_t DIRBSR_27: 1;
        uint32_t DIRBSR_28: 1;
        uint32_t DIRBSR_29: 1;
        uint32_t DIRBSR_30: 1;
        uint32_t DIRBSR_31: 1;
    };
    uint32_t Word;
} GPIO_PADIRBSR_Typedef;

typedef union
{
    struct
    {
        uint32_t DIRBCR_0: 1;
        uint32_t DIRBCR_1: 1;
        uint32_t DIRBCR_2: 1;
        uint32_t DIRBCR_3: 1;
        uint32_t DIRBCR_4: 1;
        uint32_t DIRBCR_5: 1;
        uint32_t DIRBCR_6: 1;
        uint32_t DIRBCR_7: 1;
        uint32_t DIRBCR_8: 1;
        uint32_t DIRBCR_9: 1;
        uint32_t DIRBCR_10: 1;
        uint32_t DIRBCR_11: 1;
        uint32_t DIRBCR_12: 1;
        uint32_t DIRBCR_13: 1;
        uint32_t DIRBCR_14: 1;
        uint32_t DIRBCR_15: 1;
        uint32_t DIRBCR_16: 1;
        uint32_t DIRBCR_17: 1;
        uint32_t DIRBCR_18: 1;
        uint32_t DIRBCR_19: 1;
        uint32_t DIRBCR_20: 1;
        uint32_t DIRBCR_21: 1;
        uint32_t DIRBCR_22: 1;
        uint32_t DIRBCR_23: 1;
        uint32_t DIRBCR_24: 1;
        uint32_t DIRBCR_25: 1;
        uint32_t DIRBCR_26: 1;
        uint32_t DIRBCR_27: 1;
        uint32_t DIRBCR_28: 1;
        uint32_t DIRBCR_29: 1;
        uint32_t DIRBCR_30: 1;
        uint32_t DIRBCR_31: 1;
    };
    uint32_t Word;
} GPIO_PADIRBCR_Typedef;

typedef union
{
    struct
    {
        uint32_t DIRBRR_0: 1;
        uint32_t DIRBRR_1: 1;
        uint32_t DIRBRR_2: 1;
        uint32_t DIRBRR_3: 1;
        uint32_t DIRBRR_4: 1;
        uint32_t DIRBRR_5: 1;
        uint32_t DIRBRR_6: 1;
        uint32_t DIRBRR_7: 1;
        uint32_t DIRBRR_8: 1;
        uint32_t DIRBRR_9: 1;
        uint32_t DIRBRR_10: 1;
        uint32_t DIRBRR_11: 1;
        uint32_t DIRBRR_12: 1;
        uint32_t DIRBRR_13: 1;
        uint32_t DIRBRR_14: 1;
        uint32_t DIRBRR_15: 1;
        uint32_t DIRBRR_16: 1;
        uint32_t DIRBRR_17: 1;
        uint32_t DIRBRR_18: 1;
        uint32_t DIRBRR_19: 1;
        uint32_t DIRBRR_20: 1;
        uint32_t DIRBRR_21: 1;
        uint32_t DIRBRR_22: 1;
        uint32_t DIRBRR_23: 1;
        uint32_t DIRBRR_24: 1;
        uint32_t DIRBRR_25: 1;
        uint32_t DIRBRR_26: 1;
        uint32_t DIRBRR_27: 1;
        uint32_t DIRBRR_28: 1;
        uint32_t DIRBRR_29: 1;
        uint32_t DIRBRR_30: 1;
        uint32_t DIRBRR_31: 1;
    };
    uint32_t Word;
} GPIO_PADIRBRR_Typedef;

typedef union
{
    struct
    {
        uint32_t RESERVED0: 4;
        uint32_t PA1: 2;
        uint32_t RESERVED1: 2;
        uint32_t PA2: 2;
        uint32_t RESERVED2: 2;
        uint32_t PA3: 2;
        uint32_t RESERVED3: 2;
        uint32_t PA4: 2;
        uint32_t RESERVED4: 2;
        uint32_t PA5: 2;
        uint32_t RESERVED5: 2;
        uint32_t PA6: 2;
        uint32_t RESERVED6: 2;
        uint32_t PA7: 2;
        uint32_t RESERVED7: 2;
    };
    uint32_t Word;
} GPIO_PAFUNC0_Typedef;

typedef union
{
    struct
    {
        uint32_t PA8: 2;
        uint32_t RESERVED0: 2;
        uint32_t PA9: 2;
        uint32_t RESERVED1: 2;
        uint32_t PA10: 2;
        uint32_t RESERVED2: 2;
        uint32_t PA11: 2;
        uint32_t RESERVED3: 2;
        uint32_t PA12: 2;
        uint32_t RESERVED4: 2;
        uint32_t PA13: 2;
        uint32_t RESERVED5: 2;
        uint32_t PA14: 2;
        uint32_t RESERVED6: 2;
        uint32_t PA15: 2;
        uint32_t RESERVED7: 2;
    };
    uint32_t Word;
} GPIO_PAFUNC1_Typedef;

typedef union
{
    struct
    {
        uint32_t PA16: 2;
        uint32_t RESERVED0: 22;
        uint32_t PA22: 2;
        uint32_t RESERVED1: 2;
        uint32_t PA23: 2;
        uint32_t RESERVED2: 2;
    };
    uint32_t Word;
} GPIO_PAFUNC2_Typedef;

typedef union
{
    struct
    {
        uint32_t PA24: 2;
        uint32_t RESERVED0: 2;
        uint32_t PA25: 2;
        uint32_t RESERVED1: 6;
        uint32_t PA27: 2;
        uint32_t RESERVED2: 2;
        uint32_t PA28: 2;
        uint32_t RESERVED3: 14;
    };
    uint32_t Word;
} GPIO_PAFUNC3_Typedef;

typedef union
{
    struct
    {
        uint32_t INEB_0: 1;
        uint32_t INEB_1: 1;
        uint32_t INEB_2: 1;
        uint32_t INEB_3: 1;
        uint32_t INEB_4: 1;
        uint32_t INEB_5: 1;
        uint32_t INEB_6: 1;
        uint32_t INEB_7: 1;
        uint32_t INEB_8: 1;
        uint32_t INEB_9: 1;
        uint32_t INEB_10: 1;
        uint32_t INEB_11: 1;
        uint32_t INEB_12: 1;
        uint32_t INEB_13: 1;
        uint32_t INEB_14: 1;
        uint32_t INEB_15: 1;
        uint32_t INEB_16: 1;
        uint32_t INEB_17: 1;
        uint32_t INEB_18: 1;
        uint32_t INEB_19: 1;
        uint32_t INEB_20: 1;
        uint32_t INEB_21: 1;
        uint32_t INEB_22: 1;
        uint32_t INEB_23: 1;
        uint32_t INEB_24: 1;
        uint32_t INEB_25: 1;
        uint32_t INEB_26: 1;
        uint32_t INEB_27: 1;
        uint32_t INEB_28: 1;
        uint32_t INEB_29: 1;
        uint32_t INEB_30: 1;
        uint32_t INEB_31: 1;
    };
    uint32_t Word;
} GPIO_PAINEB_Typedef;

typedef union
{
    struct
    {
        uint32_t ODE_0: 1;
        uint32_t ODE_1: 1;
        uint32_t ODE_2: 1;
        uint32_t ODE_3: 1;
        uint32_t ODE_4: 1;
        uint32_t ODE_5: 1;
        uint32_t ODE_6: 1;
        uint32_t ODE_7: 1;
        uint32_t ODE_8: 1;
        uint32_t ODE_9: 1;
        uint32_t ODE_10: 1;
        uint32_t ODE_11: 1;
        uint32_t ODE_12: 1;
        uint32_t ODE_13: 1;
        uint32_t ODE_14: 1;
        uint32_t ODE_15: 1;
        uint32_t ODE_16: 1;
        uint32_t ODE_17: 1;
        uint32_t ODE_18: 1;
        uint32_t ODE_19: 1;
        uint32_t ODE_20: 1;
        uint32_t ODE_21: 1;
        uint32_t ODE_22: 1;
        uint32_t ODE_23: 1;
        uint32_t ODE_24: 1;
        uint32_t ODE_25: 1;
        uint32_t ODE_26: 1;
        uint32_t ODE_27: 1;
        uint32_t ODE_28: 1;
        uint32_t ODE_29: 1;
        uint32_t ODE_30: 1;
        uint32_t ODE_31: 1;
    };
    uint32_t Word;
} GPIO_PAODE_Typedef;

typedef union
{
    struct
    {
        uint32_t PUE_0: 1;
        uint32_t PUE_1: 1;
        uint32_t PUE_2: 1;
        uint32_t PUE_3: 1;
        uint32_t PUE_4: 1;
        uint32_t PUE_5: 1;
        uint32_t PUE_6: 1;
        uint32_t PUE_7: 1;
        uint32_t PUE_8: 1;
        uint32_t PUE_9: 1;
        uint32_t PUE_10: 1;
        uint32_t PUE_11: 1;
        uint32_t PUE_12: 1;
        uint32_t PUE_13: 1;
        uint32_t PUE_14: 1;
        uint32_t PUE_15: 1;
        uint32_t PUE_16: 1;
        uint32_t PUE_17: 1;
        uint32_t PUE_18: 1;
        uint32_t PUE_19: 1;
        uint32_t PUE_20: 1;
        uint32_t PUE_21: 1;
        uint32_t PUE_22: 1;
        uint32_t PUE_23: 1;
        uint32_t PUE_24: 1;
        uint32_t PUE_25: 1;
        uint32_t PUE_26: 1;
        uint32_t PUE_27: 1;
        uint32_t PUE_28: 1;
        uint32_t PUE_29: 1;
        uint32_t PUE_30: 1;
        uint32_t PUE_31: 1;
    };
    uint32_t Word;
} GPIO_PAPUE_Typedef;

typedef union
{
    struct
    {
        uint32_t PDE_0: 1;
        uint32_t PDE_1: 1;
        uint32_t PDE_2: 1;
        uint32_t PDE_3: 1;
        uint32_t PDE_4: 1;
        uint32_t PDE_5: 1;
        uint32_t PDE_6: 1;
        uint32_t PDE_7: 1;
        uint32_t PDE_8: 1;
        uint32_t PDE_9: 1;
        uint32_t PDE_10: 1;
        uint32_t PDE_11: 1;
        uint32_t PDE_12: 1;
        uint32_t PDE_13: 1;
        uint32_t PDE_14: 1;
        uint32_t PDE_15: 1;
        uint32_t PDE_16: 1;
        uint32_t PDE_17: 1;
        uint32_t PDE_18: 1;
        uint32_t PDE_19: 1;
        uint32_t PDE_20: 1;
        uint32_t PDE_21: 1;
        uint32_t PDE_22: 1;
        uint32_t PDE_23: 1;
        uint32_t PDE_24: 1;
        uint32_t PDE_25: 1;
        uint32_t PDE_26: 1;
        uint32_t PDE_27: 1;
        uint32_t PDE_28: 1;
        uint32_t PDE_29: 1;
        uint32_t PDE_30: 1;
        uint32_t PDE_31: 1;
    };
    uint32_t Word;
} GPIO_PAPDE_Typedef;

typedef union
{
    struct
    {
        uint32_t DS_0: 1;
        uint32_t DS_1: 1;
        uint32_t DS_2: 1;
        uint32_t DS_3: 1;
        uint32_t DS_4: 1;
        uint32_t DS_5: 1;
        uint32_t DS_6: 1;
        uint32_t DS_7: 1;
        uint32_t DS_8: 1;
        uint32_t DS_9: 1;
        uint32_t DS_10: 1;
        uint32_t DS_11: 1;
        uint32_t DS_12: 1;
        uint32_t DS_13: 1;
        uint32_t DS_14: 1;
        uint32_t DS_15: 1;
        uint32_t DS_16: 1;
        uint32_t DS_17: 1;
        uint32_t DS_18: 1;
        uint32_t DS_19: 1;
        uint32_t DS_20: 1;
        uint32_t DS_21: 1;
        uint32_t DS_22: 1;
        uint32_t DS_23: 1;
        uint32_t DS_24: 1;
        uint32_t DS_25: 1;
        uint32_t DS_26: 1;
        uint32_t DS_27: 1;
        uint32_t DS_28: 1;
        uint32_t DS_29: 1;
        uint32_t DS_30: 1;
        uint32_t DS_31: 1;
    };
    uint32_t Word;
} GPIO_PADS_Typedef;

typedef union
{
    struct
    {
        uint32_t TYP_0: 1;
        uint32_t TYP_1: 1;
        uint32_t TYP_2: 1;
        uint32_t TYP_3: 1;
        uint32_t TYP_4: 1;
        uint32_t TYP_5: 1;
        uint32_t TYP_6: 1;
        uint32_t TYP_7: 1;
        uint32_t TYP_8: 1;
        uint32_t TYP_9: 1;
        uint32_t TYP_10: 1;
        uint32_t TYP_11: 1;
        uint32_t TYP_12: 1;
        uint32_t TYP_13: 1;
        uint32_t TYP_14: 1;
        uint32_t TYP_15: 1;
        uint32_t TYP_16: 1;
        uint32_t TYP_17: 1;
        uint32_t TYP_18: 1;
        uint32_t TYP_19: 1;
        uint32_t TYP_20: 1;
        uint32_t TYP_21: 1;
        uint32_t TYP_22: 1;
        uint32_t TYP_23: 1;
        uint32_t TYP_24: 1;
        uint32_t TYP_25: 1;
        uint32_t TYP_26: 1;
        uint32_t TYP_27: 1;
        uint32_t TYP_28: 1;
        uint32_t TYP_29: 1;
        uint32_t TYP_30: 1;
        uint32_t TYP_31: 1;
    };
    uint32_t Word;
} GPIO_PATYP_Typedef;

typedef union
{
    struct
    {
        uint32_t FLT_0: 1;
        uint32_t FLT_1: 1;
        uint32_t FLT_2: 1;
        uint32_t FLT_3: 1;
        uint32_t FLT_4: 1;
        uint32_t FLT_5: 1;
        uint32_t FLT_6: 1;
        uint32_t FLT_7: 1;
        uint32_t FLT_8: 1;
        uint32_t FLT_9: 1;
        uint32_t FLT_10: 1;
        uint32_t FLT_11: 1;
        uint32_t FLT_12: 1;
        uint32_t FLT_13: 1;
        uint32_t FLT_14: 1;
        uint32_t FLT_15: 1;
        uint32_t FLT_16: 1;
        uint32_t FLT_17: 1;
        uint32_t FLT_18: 1;
        uint32_t FLT_19: 1;
        uint32_t FLT_20: 1;
        uint32_t FLT_21: 1;
        uint32_t FLT_22: 1;
        uint32_t FLT_23: 1;
        uint32_t FLT_24: 1;
        uint32_t FLT_25: 1;
        uint32_t FLT_26: 1;
        uint32_t FLT_27: 1;
        uint32_t FLT_28: 1;
        uint32_t FLT_29: 1;
        uint32_t FLT_30: 1;
        uint32_t FLT_31: 1;
    };
    uint32_t Word;
} GPIO_PAFLT_Typedef;

typedef union
{
    struct
    {
        uint32_t PORT_0: 1;
        uint32_t PORT_1: 1;
        uint32_t PORT_2: 1;
        uint32_t PORT_3: 1;
        uint32_t PORT_4: 1;
        uint32_t PORT_5: 1;
        uint32_t PORT_6: 1;
        uint32_t PORT_7: 1;
        uint32_t PORT_8: 1;
        uint32_t PORT_9: 1;
        uint32_t PORT_10: 1;
        uint32_t PORT_11: 1;
        uint32_t PORT_12: 1;
        uint32_t PORT_13: 1;
        uint32_t RESERVED0: 18;
    };
    uint32_t Word;
} GPIO_PBPORT_Typedef;

typedef union
{
    struct
    {
        uint32_t DATA_0: 1;
        uint32_t DATA_1: 1;
        uint32_t DATA_2: 1;
        uint32_t DATA_3: 1;
        uint32_t DATA_4: 1;
        uint32_t DATA_5: 1;
        uint32_t DATA_6: 1;
        uint32_t DATA_7: 1;
        uint32_t DATA_8: 1;
        uint32_t DATA_9: 1;
        uint32_t DATA_10: 1;
        uint32_t DATA_11: 1;
        uint32_t DATA_12: 1;
        uint32_t DATA_13: 1;
        uint32_t RESERVED0: 18;
    };
    uint32_t Word;
} GPIO_PBDATA_Typedef;

typedef union
{
    struct
    {
        uint32_t DATABSR_0: 1;
        uint32_t DATABSR_1: 1;
        uint32_t DATABSR_2: 1;
        uint32_t DATABSR_3: 1;
        uint32_t DATABSR_4: 1;
        uint32_t DATABSR_5: 1;
        uint32_t DATABSR_6: 1;
        uint32_t DATABSR_7: 1;
        uint32_t DATABSR_8: 1;
        uint32_t DATABSR_9: 1;
        uint32_t DATABSR_10: 1;
        uint32_t DATABSR_11: 1;
        uint32_t DATABSR_12: 1;
        uint32_t DATABSR_13: 1;
        uint32_t RESERVED0: 18;
    };
    uint32_t Word;
} GPIO_PBDATABSR_Typedef;

typedef union
{
    struct
    {
        uint32_t DATABCR_0: 1;
        uint32_t DATABCR_1: 1;
        uint32_t DATABCR_2: 1;
        uint32_t DATABCR_3: 1;
        uint32_t DATABCR_4: 1;
        uint32_t DATABCR_5: 1;
        uint32_t DATABCR_6: 1;
        uint32_t DATABCR_7: 1;
        uint32_t DATABCR_8: 1;
        uint32_t DATABCR_9: 1;
        uint32_t DATABCR_10: 1;
        uint32_t DATABCR_11: 1;
        uint32_t DATABCR_12: 1;
        uint32_t DATABCR_13: 1;
        uint32_t RESERVED0: 18;
    };
    uint32_t Word;
} GPIO_PBDATABCR_Typedef;

typedef union
{
    struct
    {
        uint32_t DATABRR_0: 1;
        uint32_t DATABRR_1: 1;
        uint32_t DATABRR_2: 1;
        uint32_t DATABRR_3: 1;
        uint32_t DATABRR_4: 1;
        uint32_t DATABRR_5: 1;
        uint32_t DATABRR_6: 1;
        uint32_t DATABRR_7: 1;
        uint32_t DATABRR_8: 1;
        uint32_t DATABRR_9: 1;
        uint32_t DATABRR_10: 1;
        uint32_t DATABRR_11: 1;
        uint32_t DATABRR_12: 1;
        uint32_t DATABRR_13: 1;
        uint32_t RESERVED0: 18;
    };
    uint32_t Word;
} GPIO_PBDATABRR_Typedef;

typedef union
{
    struct
    {
        uint32_t DIR_0: 1;
        uint32_t DIR_1: 1;
        uint32_t DIR_2: 1;
        uint32_t DIR_3: 1;
        uint32_t DIR_4: 1;
        uint32_t DIR_5: 1;
        uint32_t DIR_6: 1;
        uint32_t DIR_7: 1;
        uint32_t DIR_8: 1;
        uint32_t DIR_9: 1;
        uint32_t DIR_10: 1;
        uint32_t DIR_11: 1;
        uint32_t DIR_12: 1;
        uint32_t DIR_13: 1;
        uint32_t RESERVED0: 18;
    };
    uint32_t Word;
} GPIO_PBDIR_Typedef;

typedef union
{
    struct
    {
        uint32_t DIRBSR_0: 1;
        uint32_t DIRBSR_1: 1;
        uint32_t DIRBSR_2: 1;
        uint32_t DIRBSR_3: 1;
        uint32_t DIRBSR_4: 1;
        uint32_t DIRBSR_5: 1;
        uint32_t DIRBSR_6: 1;
        uint32_t DIRBSR_7: 1;
        uint32_t DIRBSR_8: 1;
        uint32_t DIRBSR_9: 1;
        uint32_t DIRBSR_10: 1;
        uint32_t DIRBSR_11: 1;
        uint32_t DIRBSR_12: 1;
        uint32_t DIRBSR_13: 1;
        uint32_t RESERVED0: 18;
    };
    uint32_t Word;
} GPIO_PBDIRBSR_Typedef;

typedef union
{
    struct
    {
        uint32_t DIRBCR_0: 1;
        uint32_t DIRBCR_1: 1;
        uint32_t DIRBCR_2: 1;
        uint32_t DIRBCR_3: 1;
        uint32_t DIRBCR_4: 1;
        uint32_t DIRBCR_5: 1;
        uint32_t DIRBCR_6: 1;
        uint32_t DIRBCR_7: 1;
        uint32_t DIRBCR_8: 1;
        uint32_t DIRBCR_9: 1;
        uint32_t DIRBCR_10: 1;
        uint32_t DIRBCR_11: 1;
        uint32_t DIRBCR_12: 1;
        uint32_t DIRBCR_13: 1;
        uint32_t RESERVED0: 18;
    };
    uint32_t Word;
} GPIO_PBDIRBCR_Typedef;

typedef union
{
    struct
    {
        uint32_t DIRBRR_0: 1;
        uint32_t DIRBRR_1: 1;
        uint32_t DIRBRR_2: 1;
        uint32_t DIRBRR_3: 1;
        uint32_t DIRBRR_4: 1;
        uint32_t DIRBRR_5: 1;
        uint32_t DIRBRR_6: 1;
        uint32_t DIRBRR_7: 1;
        uint32_t DIRBRR_8: 1;
        uint32_t DIRBRR_9: 1;
        uint32_t DIRBRR_10: 1;
        uint32_t DIRBRR_11: 1;
        uint32_t DIRBRR_12: 1;
        uint32_t DIRBRR_13: 1;
        uint32_t RESERVED0: 18;
    };
    uint32_t Word;
} GPIO_PBDIRBRR_Typedef;

typedef union
{
    struct
    {
        uint32_t PB0: 2;
        uint32_t RESERVED0: 2;
        uint32_t PB1: 2;
        uint32_t RESERVED1: 26;
    };
    uint32_t Word;
} GPIO_PBFUNC0_Typedef;

typedef union
{
    struct
    {
        uint32_t PB8: 2;
        uint32_t RESERVED0: 2;
        uint32_t PB9: 2;
        uint32_t RESERVED1: 2;
        uint32_t PB10: 2;
        uint32_t RESERVED2: 2;
        uint32_t PB11: 2;
        uint32_t RESERVED3: 2;
        uint32_t PB12: 2;
        uint32_t RESERVED4: 2;
        uint32_t PB13: 2;
        uint32_t RESERVED5: 10;
    };
    uint32_t Word;
} GPIO_PBFUNC1_Typedef;

typedef union
{
    struct
    {
        uint32_t INEB_0: 1;
        uint32_t INEB_1: 1;
        uint32_t INEB_2: 1;
        uint32_t INEB_3: 1;
        uint32_t INEB_4: 1;
        uint32_t INEB_5: 1;
        uint32_t INEB_6: 1;
        uint32_t INEB_7: 1;
        uint32_t INEB_8: 1;
        uint32_t INEB_9: 1;
        uint32_t INEB_10: 1;
        uint32_t INEB_11: 1;
        uint32_t INEB_12: 1;
        uint32_t INEB_13: 1;
        uint32_t RESERVED0: 18;
    };
    uint32_t Word;
} GPIO_PBINEB_Typedef;

typedef union
{
    struct
    {
        uint32_t ODE_0: 1;
        uint32_t ODE_1: 1;
        uint32_t ODE_2: 1;
        uint32_t ODE_3: 1;
        uint32_t ODE_4: 1;
        uint32_t ODE_5: 1;
        uint32_t ODE_6: 1;
        uint32_t ODE_7: 1;
        uint32_t ODE_8: 1;
        uint32_t ODE_9: 1;
        uint32_t ODE_10: 1;
        uint32_t ODE_11: 1;
        uint32_t ODE_12: 1;
        uint32_t ODE_13: 1;
        uint32_t RESERVED0: 18;
    };
    uint32_t Word;
} GPIO_PBODE_Typedef;

typedef union
{
    struct
    {
        uint32_t PUEN_0: 1;
        uint32_t PUEN_1: 1;
        uint32_t PUEN_2: 1;
        uint32_t PUEN_3: 1;
        uint32_t PUEN_4: 1;
        uint32_t PUEN_5: 1;
        uint32_t PUEN_6: 1;
        uint32_t PUEN_7: 1;
        uint32_t PUEN_8: 1;
        uint32_t PUEN_9: 1;
        uint32_t PUEN_10: 1;
        uint32_t PUEN_11: 1;
        uint32_t PUEN_12: 1;
        uint32_t PUEN_13: 1;
        uint32_t RESERVED0: 18;
    };
    uint32_t Word;
} GPIO_PBPUE_Typedef;

typedef union
{
    struct
    {
        uint32_t PDEN_0: 1;
        uint32_t PDEN_1: 1;
        uint32_t PDEN_2: 1;
        uint32_t PDEN_3: 1;
        uint32_t PDEN_4: 1;
        uint32_t PDEN_5: 1;
        uint32_t PDEN_6: 1;
        uint32_t PDEN_7: 1;
        uint32_t PDEN_8: 1;
        uint32_t PDEN_9: 1;
        uint32_t PDEN_10: 1;
        uint32_t PDEN_11: 1;
        uint32_t PDEN_12: 1;
        uint32_t PDEN_13: 1;
        uint32_t RESERVED0: 18;
    };
    uint32_t Word;
} GPIO_PBPDE_Typedef;

typedef union
{
    struct
    {
        uint32_t DS_0: 1;
        uint32_t DS_1: 1;
        uint32_t DS_2: 1;
        uint32_t DS_3: 1;
        uint32_t DS_4: 1;
        uint32_t DS_5: 1;
        uint32_t DS_6: 1;
        uint32_t DS_7: 1;
        uint32_t DS_8: 1;
        uint32_t DS_9: 1;
        uint32_t DS_10: 1;
        uint32_t DS_11: 1;
        uint32_t DS_12: 1;
        uint32_t DS_13: 1;
        uint32_t RESERVED0: 18;
    };
    uint32_t Word;
} GPIO_PBDS_Typedef;

typedef union
{
    struct
    {
        uint32_t TYP_0: 1;
        uint32_t TYP_1: 1;
        uint32_t TYP_2: 1;
        uint32_t TYP_3: 1;
        uint32_t TYP_4: 1;
        uint32_t TYP_5: 1;
        uint32_t TYP_6: 1;
        uint32_t TYP_7: 1;
        uint32_t TYP_8: 1;
        uint32_t TYP_9: 1;
        uint32_t TYP_10: 1;
        uint32_t TYP_11: 1;
        uint32_t TYP_12: 1;
        uint32_t TYP_13: 1;
        uint32_t TYP_14: 1;
        uint32_t TYP_15: 1;
        uint32_t TYP_16: 1;
        uint32_t TYP_17: 1;
        uint32_t TYP_18: 1;
        uint32_t TYP_19: 1;
        uint32_t TYP_20: 1;
        uint32_t TYP_21: 1;
        uint32_t TYP_22: 1;
        uint32_t TYP_23: 1;
        uint32_t TYP_24: 1;
        uint32_t TYP_25: 1;
        uint32_t TYP_26: 1;
        uint32_t TYP_27: 1;
        uint32_t TYP_28: 1;
        uint32_t TYP_29: 1;
        uint32_t TYP_30: 1;
        uint32_t TYP_31: 1;
    };
    uint32_t Word;
} GPIO_PBTYP_Typedef;

typedef union
{
    struct
    {
        uint32_t FLT_0: 1;
        uint32_t FLT_1: 1;
        uint32_t FLT_2: 1;
        uint32_t FLT_3: 1;
        uint32_t FLT_4: 1;
        uint32_t FLT_5: 1;
        uint32_t FLT_6: 1;
        uint32_t FLT_7: 1;
        uint32_t FLT_8: 1;
        uint32_t FLT_9: 1;
        uint32_t FLT_10: 1;
        uint32_t FLT_11: 1;
        uint32_t FLT_12: 1;
        uint32_t FLT_13: 1;
        uint32_t FLT_14: 1;
        uint32_t FLT_15: 1;
        uint32_t FLT_16: 1;
        uint32_t FLT_17: 1;
        uint32_t FLT_18: 1;
        uint32_t FLT_19: 1;
        uint32_t FLT_20: 1;
        uint32_t FLT_21: 1;
        uint32_t FLT_22: 1;
        uint32_t FLT_23: 1;
        uint32_t FLT_24: 1;
        uint32_t FLT_25: 1;
        uint32_t FLT_26: 1;
        uint32_t FLT_27: 1;
        uint32_t FLT_28: 1;
        uint32_t FLT_29: 1;
        uint32_t FLT_30: 1;
        uint32_t FLT_31: 1;
    };
    uint32_t Word;
} GPIO_PBFLT_Typedef;

typedef union
{
    struct
    {
        uint32_t PINTIE: 8;
        uint32_t PMASK: 8;
        uint32_t RESERVED0: 16;
    };
    uint32_t Word;
} GPIO_PINTIE_Typedef;

typedef union
{
    struct
    {
        uint32_t PINTIF_0: 1;
        uint32_t PINTIF_1: 1;
        uint32_t PINTIF_2: 1;
        uint32_t PINTIF_3: 1;
        uint32_t PINTIF_4: 1;
        uint32_t PINTIF_5: 1;
        uint32_t PINTIF_6: 1;
        uint32_t PINTIF_7: 1;
        uint32_t RESERVED0: 24;
    };
    uint32_t Word;
} GPIO_PINTIF_Typedef;

typedef union
{
    struct
    {
        uint32_t PINT0SEL: 3;
        uint32_t RESERVED0: 1;
        uint32_t PINT1SEL: 3;
        uint32_t RESERVED1: 1;
        uint32_t PINT2SEL: 3;
        uint32_t RESERVED2: 1;
        uint32_t PINT3SEL: 3;
        uint32_t RESERVED3: 1;
        uint32_t PINT4SEL: 3;
        uint32_t RESERVED4: 1;
        uint32_t PINT5SEL: 3;
        uint32_t RESERVED5: 1;
        uint32_t PINT6SEL: 3;
        uint32_t RESERVED6: 1;
        uint32_t PINT7SEL: 3;
        uint32_t RESERVED7: 1;
    };
    uint32_t Word;
} GPIO_PINTSEL_Typedef;

typedef union
{
    struct
    {
        uint32_t PINT0CFG: 3;
        uint32_t RESERVED0: 1;
        uint32_t PINT1CFG: 3;
        uint32_t RESERVED1: 1;
        uint32_t PINT2CFG: 3;
        uint32_t RESERVED2: 1;
        uint32_t PINT3CFG: 3;
        uint32_t RESERVED3: 1;
        uint32_t PINT4CFG: 3;
        uint32_t RESERVED4: 1;
        uint32_t PINT5CFG: 3;
        uint32_t RESERVED5: 1;
        uint32_t PINT6CFG: 3;
        uint32_t RESERVED6: 1;
        uint32_t PINT7CFG: 3;
        uint32_t RESERVED7: 1;
    };
    uint32_t Word;
} GPIO_PINTCFG_Typedef;

typedef union
{
    struct
    {
        uint32_t KINTIE: 8;
        uint32_t KMASK: 8;
        uint32_t RESERVED0: 16;
    };
    uint32_t Word;
} GPIO_KINTIE_Typedef;

typedef union
{
    struct
    {
        uint32_t KINTIF_0: 1;
        uint32_t KINTIF_1: 1;
        uint32_t KINTIF_2: 1;
        uint32_t KINTIF_3: 1;
        uint32_t KINTIF_4: 1;
        uint32_t KINTIF_5: 1;
        uint32_t KINTIF_6: 1;
        uint32_t KINTIF_7: 1;
        uint32_t RESERVED0: 24;
    };
    uint32_t Word;
} GPIO_KINTIF_Typedef;

typedef union
{
    struct
    {
        uint32_t KINT0SEL: 3;
        uint32_t RESERVED0: 1;
        uint32_t KINT1SEL: 3;
        uint32_t RESERVED1: 1;
        uint32_t KINT2SEL: 3;
        uint32_t RESERVED2: 1;
        uint32_t KINT3SEL: 3;
        uint32_t RESERVED3: 1;
        uint32_t KINT4SEL: 3;
        uint32_t RESERVED4: 1;
        uint32_t KINT5SEL: 3;
        uint32_t RESERVED5: 1;
        uint32_t KINT6SEL: 3;
        uint32_t RESERVED6: 1;
        uint32_t KINT7SEL: 3;
        uint32_t RESERVED7: 1;
    };
    uint32_t Word;
} GPIO_KINTSEL_Typedef;

typedef union
{
    struct
    {
        uint32_t KINT0CFG: 3;
        uint32_t RESERVED0: 1;
        uint32_t KINT1CFG: 3;
        uint32_t RESERVED1: 1;
        uint32_t KINT2CFG: 3;
        uint32_t RESERVED2: 1;
        uint32_t KINT3CFG: 3;
        uint32_t RESERVED3: 1;
        uint32_t KINT4CFG: 3;
        uint32_t RESERVED4: 1;
        uint32_t KINT5CFG: 3;
        uint32_t RESERVED5: 1;
        uint32_t KINT6CFG: 3;
        uint32_t RESERVED6: 1;
        uint32_t KINT7CFG: 3;
        uint32_t RESERVED7: 1;
    };
    uint32_t Word;
} GPIO_KINTCFG_Typedef;

typedef union
{
    struct
    {
        uint32_t TX0PS: 2;
        uint32_t TX0PLV: 1;
        uint32_t RESERVED0: 1;
        uint32_t TX0_S0: 1;
        uint32_t TX0_S1: 1;
        uint32_t TX0_S2: 1;
        uint32_t TX0_S3: 1;
        uint32_t RESERVED1: 24;
    };
    uint32_t Word;
} GPIO_TXPWM_Typedef;

typedef union
{
    struct
    {
        uint32_t BUZEN: 1;
        uint32_t RESERVED0: 7;
        uint32_t BUZ_LOAD: 20;
        uint32_t RESERVED1: 4;
    };
    uint32_t Word;
} GPIO_BUZC_Typedef;

typedef struct
{
    __I GPIO_PAPORT_Typedef PAPORT;
    __IO GPIO_PADATA_Typedef PADATA;
    __O GPIO_PADATABSR_Typedef PADATABSR;
    __O GPIO_PADATABCR_Typedef PADATABCR;
    __O GPIO_PADATABRR_Typedef PADATABRR;
    __IO GPIO_PADIR_Typedef PADIR;
    __O GPIO_PADIRBSR_Typedef PADIRBSR;
    __O GPIO_PADIRBCR_Typedef PADIRBCR;
    __O GPIO_PADIRBRR_Typedef PADIRBRR;
    __IO GPIO_PAFUNC0_Typedef PAFUNC0;
    __IO GPIO_PAFUNC1_Typedef PAFUNC1;
    __IO GPIO_PAFUNC2_Typedef PAFUNC2;
    __IO GPIO_PAFUNC3_Typedef PAFUNC3;
    __IO GPIO_PAINEB_Typedef PAINEB;
    __IO GPIO_PAODE_Typedef PAODE;
    __IO GPIO_PAPUE_Typedef PAPUE;
    __IO GPIO_PAPDE_Typedef PAPDE;
    __IO GPIO_PADS_Typedef PADS;
    __IO GPIO_PATYP_Typedef PATYP;
    __IO GPIO_PAFLT_Typedef PAFLT;
    uint32_t RESERVED0[12] ;
    __I GPIO_PBPORT_Typedef PBPORT;
    __IO GPIO_PBDATA_Typedef PBDATA;
    __O GPIO_PBDATABSR_Typedef PBDATABSR;
    __O GPIO_PBDATABCR_Typedef PBDATABCR;
    __O GPIO_PBDATABRR_Typedef PBDATABRR;
    __IO GPIO_PBDIR_Typedef PBDIR;
    __O GPIO_PBDIRBSR_Typedef PBDIRBSR;
    __O GPIO_PBDIRBCR_Typedef PBDIRBCR;
    __O GPIO_PBDIRBRR_Typedef PBDIRBRR;
    __IO GPIO_PBFUNC0_Typedef PBFUNC0;
    __IO GPIO_PBFUNC1_Typedef PBFUNC1;
    uint32_t RESERVED1[2] ;
    __IO GPIO_PBINEB_Typedef PBINEB;
    __IO GPIO_PBODE_Typedef PBODE;
    __IO GPIO_PBPUE_Typedef PBPUE;
    __IO GPIO_PBPDE_Typedef PBPDE;
    __IO GPIO_PBDS_Typedef PBDS;
    __IO GPIO_PBTYP_Typedef PBTYP;
    __IO GPIO_PBFLT_Typedef PBFLT;
    uint32_t RESERVED2[140] ;
    __IO GPIO_PINTIE_Typedef PINTIE;
    __IO GPIO_PINTIF_Typedef PINTIF;
    __IO GPIO_PINTSEL_Typedef PINTSEL;
    __IO GPIO_PINTCFG_Typedef PINTCFG;
    __IO GPIO_KINTIE_Typedef KINTIE;
    __IO GPIO_KINTIF_Typedef KINTIF;
    __IO GPIO_KINTSEL_Typedef KINTSEL;
    __IO GPIO_KINTCFG_Typedef KINTCFG;
    uint32_t RESERVED3[24] ;
    __IO GPIO_TXPWM_Typedef TXPWM;
    __IO GPIO_BUZC_Typedef BUZC;
} GPIO_TypeDef;

typedef union
{
    struct
    {
        uint32_t STATUS: 2;
        uint32_t RESERVED0: 30;
    };
    uint32_t Word;
} IAP_FLASHKEY_Typedef;

typedef union
{
    struct
    {
        uint32_t ADDR: 16;
        uint32_t RESERVED0: 16;
    };
    uint32_t Word;
} IAP_FLASHADDR_Typedef;

typedef union
{
    struct
    {
        uint32_t FIFO: 32;
    };
    uint32_t Word;
} IAP_FLASHFIFO_Typedef;

typedef union
{
    struct
    {
        uint32_t DATA: 32;
    };
    uint32_t Word;
} IAP_FLASHDR_Typedef;

typedef union
{
    struct
    {
        uint32_t CMD: 32;
    };
    uint32_t Word;
} IAP_FLASHCMD_Typedef;

typedef union
{
    struct
    {
        uint32_t IAPEN: 1;
        uint32_t IAPRST: 1;
        uint32_t OTFEN: 1;
        uint32_t RESERVED0: 1;
        uint32_t FLASHREQ: 1;
        uint32_t FIFOEN: 1;
        uint32_t RESERVED1: 1;
        uint32_t FIFODF: 1;
        uint32_t PGSZ: 1;
        uint32_t RESERVED2: 23;
    };
    uint32_t Word;
} IAP_FLASHCR_Typedef;

typedef union
{
    struct
    {
        uint32_t FLASHACK: 1;
        uint32_t BUSY: 1;
        uint32_t WPE: 1;
        uint32_t WAE: 1;
        uint32_t MASE: 1;
        uint32_t SERA: 1;
        uint32_t PROG: 1;
        uint32_t TIMEOUT: 1;
        uint32_t RESERVED0: 8;
        uint32_t UPCEBUSY: 1;
        uint32_t UPCEDONE: 1;
        uint32_t RESERVED1: 5;
        uint32_t ADDERR: 1;
        uint32_t MASEUL: 1;
        uint32_t UPCEUL: 1;
        uint32_t RESERVED2: 6;
    };
    uint32_t Word;
} IAP_FLASHSR_Typedef;

typedef union
{
    struct
    {
        uint32_t ADDRINV: 16;
        uint32_t RESERVED0: 16;
    };
    uint32_t Word;
} IAP_FLASHADDINV_Typedef;

typedef struct
{
    __IO IAP_FLASHKEY_Typedef FLASHKEY;
    uint32_t RESERVED0 ;
    __IO IAP_FLASHADDR_Typedef FLASHADDR;
    __O IAP_FLASHFIFO_Typedef FLASHFIFO;
    __IO IAP_FLASHDR_Typedef FLASHDR;
    uint32_t RESERVED1 ;
    __O IAP_FLASHCMD_Typedef FLASHCMD;
    __IO IAP_FLASHCR_Typedef FLASHCR;
    __I IAP_FLASHSR_Typedef FLASHSR;
    uint32_t RESERVED2[2] ;
    __IO IAP_FLASHADDINV_Typedef FLASHADDINV;
} IAP_TypeDef;

typedef union
{
    struct
    {
        uint32_t DR: 12;
        uint32_t RESERVED0: 20;
    };
    uint32_t Word;
} ADC_DR_Typedef;

typedef union
{
    struct
    {
        uint32_t RESERVED0: 1;
        uint32_t RESERVED1: 1;
        uint32_t ACP_EN: 1;
        uint32_t RESERVED2: 1;
        uint32_t BIT_SEL: 2;
        uint32_t RESERVED3: 26;
    };
    uint32_t Word;
} ADC_CON0_Typedef;

typedef union
{
    struct
    {
        uint32_t CLKDIV: 3;
        uint32_t CLKS: 1;
        uint32_t RESERVED0: 4;
        uint32_t VREFP: 2;
        uint32_t VREFN: 1;
        uint32_t RESERVED1: 1;
        uint32_t SMPS: 1;
        uint32_t SMPON: 1;
        uint32_t HSEN: 1;
        uint32_t RESERVED2: 1;
        uint32_t ST: 5;
        uint32_t RESERVED3: 2;
        uint32_t CALZERO: 1;
        uint32_t RESERVED4: 8;
    };
    uint32_t Word;
} ADC_CON1_Typedef;

typedef union
{
    struct
    {
        uint32_t CHS: 5;
        uint32_t RESERVED0: 27;
    };
    uint32_t Word;
} ADC_CHS_Typedef;

typedef union
{
    struct
    {
        uint32_t IE: 1;
        uint32_t ACPMINIE: 1;
        uint32_t ACPMAXIE: 1;
        uint32_t ACPOVIE: 1;
        uint32_t RESERVED0: 28;
    };
    uint32_t Word;
} ADC_IE_Typedef;

typedef union
{
    struct
    {
        uint32_t IF: 1;
        uint32_t ACPMINIF: 1;
        uint32_t ACPMAXIF: 1;
        uint32_t ACPOVIF: 1;
        uint32_t RESERVED0: 28;
    };
    uint32_t Word;
} ADC_IF_Typedef;

typedef union
{
    struct
    {
        uint32_t OVFL_TIME: 12;
        uint32_t RESERVED0: 4;
        uint32_t TIMES: 2;
        uint32_t RESERVED1: 2;
        uint32_t CLKS: 1;
        uint32_t RESERVED2: 11;
    };
    uint32_t Word;
} ADC_ACPC_Typedef;

typedef union
{
    struct
    {
        uint32_t CMP_MIN: 12;
        uint32_t RESERVED0: 4;
        uint32_t CMP_MAX: 12;
        uint32_t RESERVED1: 4;
    };
    uint32_t Word;
} ADC_ACPCMP_Typedef;

typedef union
{
    struct
    {
        uint32_t MEAN_DATA: 12;
        uint32_t RESERVED0: 20;
    };
    uint32_t Word;
} ADC_ACPMEAN_Typedef;

typedef union
{
    struct
    {
        uint32_t OFFDATA: 12;
        uint32_t RESERVED0: 20;
    };
    uint32_t Word;
} ADC_OFFDR_Typedef;

typedef union
{
    struct
    {
        uint32_t VREF_EN: 1;
        uint32_t VREF_SEL: 1;
        uint32_t IREF_EN: 1;
        uint32_t CHOP_EN: 1;
        uint32_t RESERVED0: 28;
    };
    uint32_t Word;
} ADC_VREFCON_Typedef;

typedef struct
{
    __I ADC_DR_Typedef DR;
    __IO ADC_CON0_Typedef CON0;
    __IO ADC_CON1_Typedef CON1;
    __IO ADC_CHS_Typedef CHS;
    __IO ADC_IE_Typedef IE;
    __IO ADC_IF_Typedef IF;
    uint32_t RESERVED0[4] ;
    __IO ADC_ACPC_Typedef ACPC;
    uint32_t RESERVED1 ;
    __IO ADC_ACPCMP_Typedef ACPCMP;
    __I ADC_ACPMEAN_Typedef ACPMEAN;
    __IO ADC_OFFDR_Typedef OFFDR;
    uint32_t RESERVED2 ;
    __IO ADC_VREFCON_Typedef VREFCON;
} ADC_TypeDef;

typedef union
{
    struct
    {
        uint32_t LOAD: 32;
    };
    uint32_t Word;
} IWDT_LOAD_Typedef;

typedef union
{
    struct
    {
        uint32_t VALUE: 32;
    };
    uint32_t Word;
} IWDT_VALUE_Typedef;

typedef union
{
    struct
    {
        uint32_t EN: 1;
        uint32_t IE: 1;
        uint32_t RSTEN: 1;
        uint32_t CLKS: 1;
        uint32_t RESERVED0: 28;
    };
    uint32_t Word;
} IWDT_CON_Typedef;

typedef union
{
    struct
    {
        uint32_t INTCLR: 32;
    };
    uint32_t Word;
} IWDT_INTCLR_Typedef;

typedef union
{
    struct
    {
        uint32_t WDTIF: 1;
        uint32_t RESERVED0: 31;
    };
    uint32_t Word;
} IWDT_RIS_Typedef;

typedef union
{
    struct
    {
        uint32_t LOCK: 1;
        uint32_t RESERVED0: 31;
    };
    uint32_t Word;
} IWDT_LOCK_Typedef;

typedef struct
{
    __O IWDT_LOAD_Typedef LOAD;
    __I IWDT_VALUE_Typedef VALUE;
    __IO IWDT_CON_Typedef CON;
    __O IWDT_INTCLR_Typedef INTCLR;
    __I IWDT_RIS_Typedef RIS;
    uint32_t RESERVED0[59] ;
    __IO IWDT_LOCK_Typedef LOCK;
} IWDT_TypeDef;

typedef union
{
    struct
    {
        uint32_t LOAD: 32;
    };
    uint32_t Word;
} WWDT_LOAD_Typedef;

typedef union
{
    struct
    {
        uint32_t VALUE: 32;
    };
    uint32_t Word;
} WWDT_VALUE_Typedef;

typedef union
{
    struct
    {
        uint32_t EN: 1;
        uint32_t IE: 1;
        uint32_t RSTEN: 1;
        uint32_t CLKS: 1;
        uint32_t WWDTWIN: 2;
        uint32_t RESERVED0: 26;
    };
    uint32_t Word;
} WWDT_CON_Typedef;

typedef union
{
    struct
    {
        uint32_t INTCLR: 32;
    };
    uint32_t Word;
} WWDT_INTCLR_Typedef;

typedef union
{
    struct
    {
        uint32_t WWDTIF: 1;
        uint32_t RESERVED0: 31;
    };
    uint32_t Word;
} WWDT_RIS_Typedef;

typedef union
{
    struct
    {
        uint32_t LOCK: 1;
        uint32_t RESERVED0: 31;
    };
    uint32_t Word;
} WWDT_LOCK_Typedef;

typedef struct
{
    __O WWDT_LOAD_Typedef LOAD;
    __I WWDT_VALUE_Typedef VALUE;
    __IO WWDT_CON_Typedef CON;
    __O WWDT_INTCLR_Typedef INTCLR;
    __I WWDT_RIS_Typedef RIS;
    uint32_t RESERVED0[59] ;
    __IO WWDT_LOCK_Typedef LOCK;
} WWDT_TypeDef;

typedef union
{
    struct
    {
        uint32_t CNT0: 16;
        uint32_t RESERVED0: 16;
    };
    uint32_t Word;
} T16N_CNT0_Typedef;

typedef union
{
    struct
    {
        uint32_t CNT1: 16;
        uint32_t RESERVED0: 16;
    };
    uint32_t Word;
} T16N_CNT1_Typedef;

typedef union
{
    struct
    {
        uint32_t PRECNT: 8;
        uint32_t RESERVED0: 24;
    };
    uint32_t Word;
} T16N_PRECNT_Typedef;

typedef union
{
    struct
    {
        uint32_t PREMAT: 8;
        uint32_t RESERVED0: 24;
    };
    uint32_t Word;
} T16N_PREMAT_Typedef;

typedef union
{
    struct
    {
        uint32_t EN: 1;
        uint32_t CS: 2;
        uint32_t SYNC: 1;
        uint32_t EDGE: 2;
        uint32_t MOD: 2;
        uint32_t MAT0S: 2;
        uint32_t MAT1S: 2;
        uint32_t MAT2S: 2;
        uint32_t MAT3S: 2;
        uint32_t ASYWEN: 1;
        uint32_t RESERVED0: 15;
    };
    uint32_t Word;
} T16N_CON0_Typedef;

typedef union
{
    struct
    {
        uint32_t CAPPE: 1;
        uint32_t CAPNE: 1;
        uint32_t CAPIS0: 1;
        uint32_t CAPIS1: 1;
        uint32_t CAPT: 4;
        uint32_t CAPL0: 1;
        uint32_t CAPL1: 1;
        uint32_t RESERVED0: 22;
    };
    uint32_t Word;
} T16N_CON1_Typedef;

typedef union
{
    struct
    {
        uint32_t MOE0: 1;
        uint32_t MOE1: 1;
        uint32_t POL0: 1;
        uint32_t POL1: 1;
        uint32_t PWMMOD: 2;
        uint32_t PWMDZE: 1;
        uint32_t REGBUF_EN: 1;
        uint32_t MOM0: 2;
        uint32_t MOM1: 2;
        uint32_t MOM2: 2;
        uint32_t MOM3: 2;
        uint32_t PWMBKE0: 1;
        uint32_t PWMBKE1: 1;
        uint32_t PWMBKL0: 1;
        uint32_t PWMBKL1: 1;
        uint32_t RESERVED0: 2;
        uint32_t PWMBKP0: 1;
        uint32_t PWMBKP1: 1;
        uint32_t PWMBKF: 1;
        uint32_t RESERVED1: 7;
    };
    uint32_t Word;
} T16N_CON2_Typedef;

typedef union
{
    struct
    {
        uint32_t MAT0IE: 1;
        uint32_t MAT1IE: 1;
        uint32_t MAT2IE: 1;
        uint32_t MAT3IE: 1;
        uint32_t TOP0IE: 1;
        uint32_t TOP1IE: 1;
        uint32_t CAP0IE: 1;
        uint32_t CAP1IE: 1;
        uint32_t PBK0IE: 1;
        uint32_t PBK1IE: 1;
        uint32_t RESERVED0: 22;
    };
    uint32_t Word;
} T16N_IE_Typedef;

typedef union
{
    struct
    {
        uint32_t MAT0IF: 1;
        uint32_t MAT1IF: 1;
        uint32_t MAT2IF: 1;
        uint32_t MAT3IF: 1;
        uint32_t TOP0IF: 1;
        uint32_t TOP1IF: 1;
        uint32_t CAP0IF: 1;
        uint32_t CAP1IF: 1;
        uint32_t PBK0IF: 1;
        uint32_t PBK1IF: 1;
        uint32_t RESERVED0: 22;
    };
    uint32_t Word;
} T16N_IF_Typedef;

typedef union
{
    struct
    {
        uint32_t PDZ: 8;
        uint32_t RESERVED0: 24;
    };
    uint32_t Word;
} T16N_PDZ_Typedef;

typedef union
{
    struct
    {
        uint32_t RESERVED0: 1;
        uint32_t P0MAT0TRE: 1;
        uint32_t P0MAT1TRE: 1;
        uint32_t P0TOP0TRE: 1;
        uint32_t RESERVED1: 1;
        uint32_t P1MAT2TRE: 1;
        uint32_t P1MAT3TRE: 1;
        uint32_t P1TOP1TRE: 1;
        uint32_t RESERVED2: 24;
    };
    uint32_t Word;
} T16N_PTR_Typedef;

typedef union
{
    struct
    {
        uint32_t MAT0: 16;
        uint32_t RESERVED0: 16;
    };
    uint32_t Word;
} T16N_MAT0_Typedef;

typedef union
{
    struct
    {
        uint32_t MAT1: 16;
        uint32_t RESERVED0: 16;
    };
    uint32_t Word;
} T16N_MAT1_Typedef;

typedef union
{
    struct
    {
        uint32_t MAT2: 16;
        uint32_t RESERVED0: 16;
    };
    uint32_t Word;
} T16N_MAT2_Typedef;

typedef union
{
    struct
    {
        uint32_t MAT3: 16;
        uint32_t RESERVED0: 16;
    };
    uint32_t Word;
} T16N_MAT3_Typedef;

typedef union
{
    struct
    {
        uint32_t TOP0: 16;
        uint32_t RESERVED0: 16;
    };
    uint32_t Word;
} T16N_TOP0_Typedef;

typedef union
{
    struct
    {
        uint32_t TOP1: 16;
        uint32_t RESERVED0: 16;
    };
    uint32_t Word;
} T16N_TOP1_Typedef;

typedef struct
{
    __IO T16N_CNT0_Typedef CNT0;
    __IO T16N_CNT1_Typedef CNT1;
    __IO T16N_PRECNT_Typedef PRECNT;
    __IO T16N_PREMAT_Typedef PREMAT;
    __IO T16N_CON0_Typedef CON0;
    __IO T16N_CON1_Typedef CON1;
    __IO T16N_CON2_Typedef CON2;
    uint32_t RESERVED0 ;
    __IO T16N_IE_Typedef IE;
    __IO T16N_IF_Typedef IF;
    __IO T16N_PDZ_Typedef PDZ;
    __IO T16N_PTR_Typedef PTR;
    __IO T16N_MAT0_Typedef MAT0;
    __IO T16N_MAT1_Typedef MAT1;
    __IO T16N_MAT2_Typedef MAT2;
    __IO T16N_MAT3_Typedef MAT3;
    __IO T16N_TOP0_Typedef TOP0;
    __IO T16N_TOP1_Typedef TOP1;
} T16N_TypeDef;

typedef union
{
    struct
    {
        uint32_t CNT: 32;
    };
    uint32_t Word;
} T32N_CNT_Typedef;

typedef union
{
    struct
    {
        uint32_t EN: 1;
        uint32_t CS: 2;
        uint32_t SYNC: 1;
        uint32_t EDGE: 2;
        uint32_t MOD: 2;
        uint32_t MAT0S: 2;
        uint32_t MAT1S: 2;
        uint32_t MAT2S: 2;
        uint32_t MAT3S: 2;
        uint32_t ASYNC_WREN: 1;
        uint32_t RESERVED0: 15;
    };
    uint32_t Word;
} T32N_CON0_Typedef;

typedef union
{
    struct
    {
        uint32_t CAPPE: 1;
        uint32_t CAPNE: 1;
        uint32_t CAPIS0: 1;
        uint32_t CAPIS1: 1;
        uint32_t CAPT: 4;
        uint32_t CAPL0: 1;
        uint32_t CAPL1: 1;
        uint32_t RESERVED0: 6;
        uint32_t MOE0: 1;
        uint32_t MOE1: 1;
        uint32_t RESERVED1: 6;
        uint32_t MOM0: 2;
        uint32_t MOM1: 2;
        uint32_t MOM2: 2;
        uint32_t MOM3: 2;
    };
    uint32_t Word;
} T32N_CON1_Typedef;

typedef union
{
    struct
    {
        uint32_t PRECNT: 8;
        uint32_t RESERVED0: 24;
    };
    uint32_t Word;
} T32N_PRECNT_Typedef;

typedef union
{
    struct
    {
        uint32_t PREMAT: 8;
        uint32_t RESERVED0: 24;
    };
    uint32_t Word;
} T32N_PREMAT_Typedef;

typedef union
{
    struct
    {
        uint32_t MAT0IE: 1;
        uint32_t MAT1IE: 1;
        uint32_t MAT2IE: 1;
        uint32_t MAT3IE: 1;
        uint32_t IE: 1;
        uint32_t CAP0IE: 1;
        uint32_t CAP1IE: 1;
        uint32_t RESERVED0: 25;
    };
    uint32_t Word;
} T32N_IE_Typedef;

typedef union
{
    struct
    {
        uint32_t MAT0IF: 1;
        uint32_t MAT1IF: 1;
        uint32_t MAT2IF: 1;
        uint32_t MAT3IF: 1;
        uint32_t IF: 1;
        uint32_t CAP0IF: 1;
        uint32_t CAP1IF: 1;
        uint32_t RESERVED0: 25;
    };
    uint32_t Word;
} T32N_IF_Typedef;

typedef union
{
    struct
    {
        uint32_t MAT0: 32;
    };
    uint32_t Word;
} T32N_MAT0_Typedef;

typedef union
{
    struct
    {
        uint32_t MAT1: 32;
    };
    uint32_t Word;
} T32N_MAT1_Typedef;

typedef union
{
    struct
    {
        uint32_t MAT2: 32;
    };
    uint32_t Word;
} T32N_MAT2_Typedef;

typedef union
{
    struct
    {
        uint32_t MAT3: 32;
    };
    uint32_t Word;
} T32N_MAT3_Typedef;

typedef struct
{
    __IO T32N_CNT_Typedef CNT;
    __IO T32N_CON0_Typedef CON0;
    __IO T32N_CON1_Typedef CON1;
    uint32_t RESERVED0 ;
    __IO T32N_PRECNT_Typedef PRECNT;
    __IO T32N_PREMAT_Typedef PREMAT;
    __IO T32N_IE_Typedef IE;
    __IO T32N_IF_Typedef IF;
    __IO T32N_MAT0_Typedef MAT0;
    __IO T32N_MAT1_Typedef MAT1;
    __IO T32N_MAT2_Typedef MAT2;
    __IO T32N_MAT3_Typedef MAT3;
} T32N_TypeDef;

typedef union
{
    struct
    {
        uint32_t TXEN: 1;
        uint32_t TRST: 1;
        uint32_t TBCLR: 1;
        uint32_t TXI: 1;
        uint32_t RESERVED0: 4;
        uint32_t TXMOD: 4;
        uint32_t TXP: 1;
        uint32_t TXFS: 1;
        uint32_t RESERVED1: 2;
        uint32_t RXEN: 1;
        uint32_t RRST: 1;
        uint32_t RBCLR: 1;
        uint32_t RXI: 1;
        uint32_t BDEN: 1;
        uint32_t IDEN: 1;
        uint32_t RESERVED2: 2;
        uint32_t RXMOD: 4;
        uint32_t RXP: 1;
        uint32_t RESERVED3: 3;
    };
    uint32_t Word;
} UART_CON0_Typedef;

typedef union
{
    struct
    {
        uint32_t TBIM: 2;
        uint32_t RESERVED0: 2;
        uint32_t RBIM: 2;
        uint32_t RESERVED1: 2;
        uint32_t BCS: 3;
        uint32_t RESERVED2: 1;
        uint32_t BDM: 2;
        uint32_t RESERVED3: 2;
        uint32_t IDM: 2;
        uint32_t RESERVED4: 14;
    };
    uint32_t Word;
} UART_CON1_Typedef;

typedef union
{
    struct
    {
        uint32_t BRFRA: 4;
        uint32_t BRINT: 12;
        uint32_t RESERVED0: 16;
    };
    uint32_t Word;
} UART_BRR_Typedef;

typedef union
{
    struct
    {
        uint32_t RESERVED0: 4;
        uint32_t TBOV: 1;
        uint32_t TXBUSY: 1;
        uint32_t RESERVED1: 6;
        uint32_t RBOV: 1;
        uint32_t RXBUSY: 1;
        uint32_t RESERVED2: 2;
        uint32_t FER0: 1;
        uint32_t PER0: 1;
        uint32_t FER1: 1;
        uint32_t PER1: 1;
        uint32_t FER2: 1;
        uint32_t PER2: 1;
        uint32_t FER3: 1;
        uint32_t PER3: 1;
        uint32_t RESERVED3: 8;
    };
    uint32_t Word;
} UART_STA_Typedef;

typedef union
{
    struct
    {
        uint32_t TBIE: 1;
        uint32_t TCIE: 1;
        uint32_t RESERVED0: 6;
        uint32_t TBWEIE: 1;
        uint32_t TBWOIE: 1;
        uint32_t RESERVED1: 6;
        uint32_t RBIE: 1;
        uint32_t IDIE: 1;
        uint32_t RESERVED2: 6;
        uint32_t ROIE: 1;
        uint32_t FEIE: 1;
        uint32_t PEIE: 1;
        uint32_t BDEIE: 1;
        uint32_t RBREIE: 1;
        uint32_t RBROIE: 1;
        uint32_t RESERVED3: 2;
    };
    uint32_t Word;
} UART_IE_Typedef;

typedef union
{
    struct
    {
        uint32_t TBIF: 1;
        uint32_t TCIF: 1;
        uint32_t RESERVED0: 6;
        uint32_t TBWEIF: 1;
        uint32_t TBWOIF: 1;
        uint32_t RESERVED1: 6;
        uint32_t RBIF: 1;
        uint32_t IDIF: 1;
        uint32_t RESERVED2: 6;
        uint32_t ROIF: 1;
        uint32_t FEIF: 1;
        uint32_t PEIF: 1;
        uint32_t BDEIF: 1;
        uint32_t RBREIF: 1;
        uint32_t RBROIF: 1;
        uint32_t RESERVED3: 2;
    };
    uint32_t Word;
} UART_IF_Typedef;

typedef union
{
    uint8_t Byte[4];
    uint16_t HalfWord[2];
    uint32_t Word;
} UART_TBW_Typedef;

typedef union
{
    uint8_t Byte[4];
    uint16_t HalfWord[2];
    uint32_t Word;
} UART_RBR_Typedef;

typedef union
{
    struct
    {
        uint32_t TB0: 9;
        uint32_t RESERVED0: 3;
        uint32_t TP0: 1;
        uint32_t TBFF0: 1;
        uint32_t RESERVED1: 18;
    };
    uint32_t Word;
} UART_TB0_Typedef;

typedef union
{
    struct
    {
        uint32_t RB0: 9;
        uint32_t RESERVED0: 3;
        uint32_t RP0: 1;
        uint32_t RBFF0: 1;
        uint32_t FE0: 1;
        uint32_t PE0: 1;
        uint32_t RESERVED1: 16;
    };
    uint32_t Word;
} UART_RB0_Typedef;

typedef struct
{
    __IO UART_CON0_Typedef CON0;
    __IO UART_CON1_Typedef CON1;
    uint32_t RESERVED0[2] ;
    __IO UART_BRR_Typedef BRR;
    __I UART_STA_Typedef STA;
    __IO UART_IE_Typedef IE;
    __IO UART_IF_Typedef IF;
    __O UART_TBW_Typedef TBW;
    __I UART_RBR_Typedef RBR;
    uint32_t RESERVED1[6] ;
    __I UART_TB0_Typedef TB0;
    uint32_t RESERVED2[7] ;
    __I UART_RB0_Typedef RB0;
} UART_TypeDef;

typedef union
{
    struct
    {
        uint32_t EN: 1;
        uint32_t RST: 1;
        uint32_t MS: 1;
        uint32_t REN: 1;
        uint32_t RESERVED0: 1;
        uint32_t DRE: 1;
        uint32_t DFS: 2;
        uint32_t RESERVED1: 8;
        uint32_t TME: 1;
        uint32_t TMS: 1;
        uint32_t TMP: 6;
        uint32_t DW: 3;
        uint32_t RESERVED2: 3;
        uint32_t TXCLR: 1;
        uint32_t RXCLR: 1;
    };
    uint32_t Word;
} SPI_CON_Typedef;

typedef union
{
    uint8_t Byte[4];
    uint16_t HalfWord[2];
    uint32_t Word;
} SPI_TBW_Typedef;

typedef union
{
    uint8_t Byte[4];
    uint16_t HalfWord[2];
    uint32_t Word;
} SPI_RBR_Typedef;

typedef union
{
    struct
    {
        uint32_t TBIE: 1;
        uint32_t RBIE: 1;
        uint32_t TEIE: 1;
        uint32_t ROIE: 1;
        uint32_t IDIE: 1;
        uint32_t NSSIE: 1;
        uint32_t TBWEIE: 1;
        uint32_t RESERVED0: 1;
        uint32_t TBIM: 2;
        uint32_t RBIM: 2;
        uint32_t RESERVED1: 20;
    };
    uint32_t Word;
} SPI_IE_Typedef;

typedef union
{
    struct
    {
        uint32_t TBIF: 1;
        uint32_t RBIF: 1;
        uint32_t TEIF: 1;
        uint32_t ROIF: 1;
        uint32_t IDIF: 1;
        uint32_t NSSIF: 1;
        uint32_t TBWEIF: 1;
        uint32_t RESERVED0: 25;
    };
    uint32_t Word;
} SPI_IF_Typedef;

typedef union
{
    struct
    {
        uint32_t TB0: 8;
        uint32_t TB1: 8;
        uint32_t TB2: 8;
        uint32_t TB3: 8;
    };
    uint32_t Word;
} SPI_TB_Typedef;

typedef union
{
    struct
    {
        uint32_t RB0: 8;
        uint32_t RB1: 8;
        uint32_t RB2: 8;
        uint32_t RB3: 8;
    };
    uint32_t Word;
} SPI_RB_Typedef;

typedef union
{
    struct
    {
        uint32_t RESERVED0: 7;
        uint32_t NSS: 1;
        uint32_t TBEF0: 1;
        uint32_t TBEF1: 1;
        uint32_t TBEF2: 1;
        uint32_t TBEF3: 1;
        uint32_t RBFF0: 1;
        uint32_t RBFF1: 1;
        uint32_t RBFF2: 1;
        uint32_t RBFF3: 1;
        uint32_t IDLE: 1;
        uint32_t RESERVED1: 15;
    };
    uint32_t Word;
} SPI_STA_Typedef;

typedef union
{
    struct
    {
        uint32_t CKS: 8;
        uint32_t RESERVED0: 24;
    };
    uint32_t Word;
} SPI_CKS_Typedef;

typedef struct
{
    __IO SPI_CON_Typedef CON;
    uint32_t RESERVED0 ;
    __O SPI_TBW_Typedef TBW;
    __I SPI_RBR_Typedef RBR;
    __IO SPI_IE_Typedef IE;
    __IO SPI_IF_Typedef IF;
    __I SPI_TB_Typedef TB;
    __I SPI_RB_Typedef RB;
    __I SPI_STA_Typedef STA;
    __IO SPI_CKS_Typedef CKS;
} SPI_TypeDef;

typedef union
{
    struct
    {
        uint32_t EN: 1;
        uint32_t RST: 1;
        uint32_t SCLOD: 1;
        uint32_t SDAOD: 1;
        uint32_t SCLSE: 1;
        uint32_t SDASE: 1;
        uint32_t RESERVED0: 1;
        uint32_t TJE: 1;
        uint32_t TJP: 8;
        uint32_t RW: 1;
        uint32_t SA: 7;
        uint32_t RESERVED1: 8;
    };
    uint32_t Word;
} I2C_CON_Typedef;

typedef union
{
    struct
    {
        uint32_t MS: 1;
        uint32_t RDM: 3;
        uint32_t CSE: 1;
        uint32_t ANAE: 1;
        uint32_t SRAE: 1;
        uint32_t SPAE: 1;
        uint32_t ADLY: 3;
        uint32_t ADE: 1;
        uint32_t TIS: 4;
        uint32_t SRT: 1;
        uint32_t SPT: 1;
        uint32_t RDT: 1;
        uint32_t BLD: 1;
        uint32_t RESERVED0: 4;
        uint32_t TAS: 1;
        uint32_t RESERVED1: 7;
    };
    uint32_t Word;
} I2C_MOD_Typedef;

typedef union
{
    struct
    {
        uint32_t SRIE: 1;
        uint32_t SPIE: 1;
        uint32_t TBIE: 1;
        uint32_t RBIE: 1;
        uint32_t TEIE: 1;
        uint32_t ROIE: 1;
        uint32_t NAIE: 1;
        uint32_t TBWEIE: 1;
        uint32_t TBIM: 2;
        uint32_t RBIM: 2;
        uint32_t TIDLEIE: 1;
        uint32_t RESERVED0: 19;
    };
    uint32_t Word;
} I2C_IE_Typedef;

typedef union
{
    struct
    {
        uint32_t SRIF: 1;
        uint32_t SPIF: 1;
        uint32_t TBIF: 1;
        uint32_t RBIF: 1;
        uint32_t TEIF: 1;
        uint32_t ROIF: 1;
        uint32_t NAIF: 1;
        uint32_t TBWEIF: 1;
        uint32_t RESERVED0: 4;
        uint32_t TIDLEIF: 1;
        uint32_t RESERVED1: 19;
    };
    uint32_t Word;
} I2C_IF_Typedef;

typedef union
{
    uint8_t Byte[4];
    uint16_t HalfWord[2];
    uint32_t Word;
} I2C_TBW_Typedef;

typedef union
{
    uint8_t Byte[4];
    uint16_t HalfWord[2];
    uint32_t Word;
} I2C_RBR_Typedef;

typedef union
{
    struct
    {
        uint32_t TB0: 8;
        uint32_t TB1: 8;
        uint32_t TB2: 8;
        uint32_t TB3: 8;
    };
    uint32_t Word;
} I2C_TB_Typedef;

typedef union
{
    struct
    {
        uint32_t RB0: 8;
        uint32_t RB1: 8;
        uint32_t RB2: 8;
        uint32_t RB3: 8;
    };
    uint32_t Word;
} I2C_RB_Typedef;

typedef union
{
    struct
    {
        uint32_t RESERVED0: 8;
        uint32_t TBEF0: 1;
        uint32_t TBEF1: 1;
        uint32_t TBEF2: 1;
        uint32_t TBEF3: 1;
        uint32_t RBFF0: 1;
        uint32_t RBFF1: 1;
        uint32_t RBFF2: 1;
        uint32_t RBFF3: 1;
        uint32_t ACK: 1;
        uint32_t IDLE: 1;
        uint32_t RESERVED1: 14;
    };
    uint32_t Word;
} I2C_STA_Typedef;

typedef struct
{
    __IO I2C_CON_Typedef CON;
    __IO I2C_MOD_Typedef MOD;
    __IO I2C_IE_Typedef IE;
    __IO I2C_IF_Typedef IF;
    __O I2C_TBW_Typedef TBW;
    __I I2C_RBR_Typedef RBR;
    __I I2C_TB_Typedef TB;
    __I I2C_RB_Typedef RB;
    __I I2C_STA_Typedef STA;
} I2C_TypeDef;






/******************************************************************************/
/* 物理地址映射 */
/******************************************************************************/

/* Base addresses */
#define FLASH_BASE (0x00000000UL)
#define SRAM_BASE (0x20000000UL)
#define APB_BASE (0x40000000UL)
#define RAM_BASE (0x60000000UL)
#define SYS_BASE (0xE0000000UL)

/* APB peripherals */
#define SCU_BASE (APB_BASE + 0x00000)
#define GPIO_BASE (APB_BASE + 0x00400)
#define IAP_BASE (APB_BASE + 0x00800)
#define ADC_BASE (APB_BASE + 0x01000)
#define WWDT_BASE (APB_BASE + 0x01800)
#define IWDT_BASE (APB_BASE + 0x01C00)
#define T16N0_BASE (APB_BASE + 0x02000)
#define T16N1_BASE (APB_BASE + 0x02400)
#define T16N2_BASE (APB_BASE + 0x02800)
#define T16N3_BASE (APB_BASE + 0x02C00)
#define T32N0_BASE (APB_BASE + 0x04000)
#define UART0_BASE (APB_BASE + 0x06000)
#define UART1_BASE (APB_BASE + 0x06400)
#define UART2_BASE (APB_BASE + 0x06800)
#define SPI1_BASE (APB_BASE + 0x08400)
#define I2C0_BASE (APB_BASE + 0x09000)


/******************************************************************************/
/* 外设定义 */
/******************************************************************************/
#define SCU ((SCU_TypeDef *) SCU_BASE )
#define GPIO ((GPIO_TypeDef *) GPIO_BASE )
#define IAP ((IAP_TypeDef *) IAP_BASE )
#define ADC ((ADC_TypeDef *) ADC_BASE )
#define WWDT ((WWDT_TypeDef *) WWDT_BASE )
#define IWDT ((IWDT_TypeDef *) IWDT_BASE )
#define T16N0 ((T16N_TypeDef *) T16N0_BASE )
#define T16N1 ((T16N_TypeDef *) T16N1_BASE )
#define T16N2 ((T16N_TypeDef *) T16N2_BASE )
#define T16N3 ((T16N_TypeDef *) T16N3_BASE )
#define T32N0 ((T32N_TypeDef *) T32N0_BASE )
#define UART0 ((UART_TypeDef *) UART0_BASE )
#define UART1 ((UART_TypeDef *) UART1_BASE )
#define UART2 ((UART_TypeDef *) UART2_BASE )
#define SPI1 ((SPI_TypeDef *) SPI1_BASE )
#define I2C0 ((I2C_TypeDef *) I2C0_BASE )

/******************************************************************************/
/* 唯一码定义 */
/******************************************************************************/
#if   defined ( __CC_ARM )
#endif
#endif
 
/*************************END OF FILE**********************/
