/*********************************************************
*Copyright (C), 2024, Shanghai Eastsoft Microelectronics Co., Ltd
*ļ:  uart_single_line.c
*  :  AE Team
*  :  v1.0iDesigner(v4.2.3.197) + HRCC(v1.2.0.140)
*  :  2024/12/31
*  :  UART߷ʱͨʾ
          PA1: TX/RX
          λͨţ9600λһ"www.essemi.com"Ȼѭյԭء
          ע⣺֡βΪ0x0D0x0AѡλġС֡𳬹64ֽڡ
*  ע:  ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>

#define CLRWDT()   {__Asm CWDT;}        //궨幷ָ

unsigned char g_rx_buf[64];
unsigned int g_rx_i = 0;
unsigned int cnt;
unsigned char str[] = "www.essemi.com\r\n";

/******************************************************
void RAMclear(void)
  RAM㣬RAMַ0x0000~0x03FF
ֵ
ֵ
ֵ
*******************************************************/
void RAMclear(void)
{
    for (IAAH = 0; IAAH <= 0x03; IAAH++)
    {
        for (IAAL = 0; IAAL < 0xFF; IAAL++)
            IAD = 0x00;

        IAD = 0x00;
    }
}

/******************************************************
void GPIOInit(void)
  ȳʼδõIOΪ͵ƽ
ֵ
ֵ
ֵ
*******************************************************/
void GPIOInit(void)
{
    ANSL = 0xFF;        //ѡӦ˿ΪIO
    ANSH = 0xFF;        //ѡӦ˿ΪIO
    PAT = 0x00;         //IOΪ͵ƽ
    PBT = 0x00;
    PCT = 0x00;
    PA = 0x00;
    PB = 0x00;
    PC = 0x00;
}

/**********************************************
void main(void)
  
ֵ
ֵ
ֵ
**********************************************/
void main(void)
{
    unsigned char *ptr = str;
//    RAMclear();
    GPIOInit();
    RX0LEN = 0;     //8λݽոʽ
    TX0LEN = 0;     //8λݷ͸ʽ
    BRGH0 = 0;      //ʵģʽ=Fosc/(64*(BRR<7:0>+1))
    BR0R = 0x19;    //=16MHz/(64*(25+1))9600bps
	RX0IOS = 1;     //߷ʱͨģʽ
    PAT1 = 0;       //ΪTX

    RX0EN = 0;       //رս
    TX0EN = 1;       //򿪷

    while (*ptr)        //ͣ"www.essemi.com"
    {
        while (!TRMT0);

        TX0B = *(ptr++);
        CLRWDT();
    }

    while (!TRMT0);

	cnt = 40000U;
	while(--cnt);

	PAT1 = 1;        //ΪRX
    TX0EN = 0;       //رշ
    RX0EN = 1;       //򿪽

    RX0IE = 1;       //ж
    GIE = 1;         //ж

    while (1)
    {
        CLRWDT();
    }
}

/**********************************************
void isr(void) interrupt
  жϷ
ֵ
ֵ
ֵ
**********************************************/
void isr(void) interrupt
{
	unsigned int tx_i;

    if (RX0IE == 1 && RX0IF == 1)
    {
        g_rx_buf[g_rx_i++] = RX0B;

        if (g_rx_i > 64)
            g_rx_i = 0;

        if(g_rx_i >= 2 && g_rx_buf[g_rx_i - 2] == 0x0D && g_rx_buf[g_rx_i - 1] == 0x0A)
		{
			cnt = 40000U;
			while(--cnt);

			PAT1 = 0;        //ΪTX
			RX0EN = 0;       //رս
			TX0EN = 1;       //򿪷

			for(tx_i = 0; tx_i < g_rx_i; tx_i++)
			{
				while (!TRMT0);
			    TX0B = g_rx_buf[tx_i];
			}

			g_rx_i = 0;

			while (!TRMT0);

			cnt = 40000U;
			while(--cnt);

			PAT1 = 1;        //ΪRX
			TX0EN = 0;       //رշ
			RX0EN = 1;       //򿪽
		}
    }
}
