/*********************************************************
*Copyright (C), 2020, Shanghai Eastsoft Microelectronics Co., Ltd
*ļ:  spi_slave.c
*  :  AE Team
*  :  v1.0iDesigner(v4.2.3.166) + HRCC(v1.2.0.106)
*  :  2020/12/28
*  :  SPIӻģʽʾ
          PA6NSS
          PB4SCK
          PB5MOSI
          PB6MISO
          ӻжϷʽдݣдtxbufеݣݴrxbufС
*  ע:  ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>

#define CLRWDT()   {__Asm CWDT;}        //궨幷ָ
#define RXBUF_SIZE 8       //궨ջ
#define TXBUF_SIZE 8       //궨巢ͻ

typedef unsigned char uchar;
typedef unsigned int uint;

uchar rxbuf[RXBUF_SIZE];
uint rxcnt = 0;

uchar txbuf[TXBUF_SIZE] = {0x01, 0x12, 0x23, 0x34, 0x45, 0x56, 0x67, 0x78};
uint txcnt = 0;

/******************************************************
void RAMclear(void)
  RAM㣬RAMַ0x0000~0x03FF
ֵ
ֵ
ֵ
*******************************************************/
void RAMclear(void)
{
    for (IAAH = 0; IAAH <= 0x03; IAAH++)
    {
        for (IAAL = 0; IAAL < 0xFF; IAAL++)
            IAD = 0x00;

        IAD = 0x00;
    }
}

/******************************************************
void GPIOInit(void)
  ȳʼδõIOΪ͵ƽ
ֵ
ֵ
ֵ
*******************************************************/
void GPIOInit(void)
{
    ANSL = 0xFF;        //ѡӦ˿ΪIO
    ANSH = 0xFF;
    PAT = 0x00;         //IOΪ͵ƽ
    PBT = 0x00;
    PCT = 0x00;
    PA = 0x00;
    PB = 0x00;
    PC = 0x00;
    PAT6 = 1;       //NSSΪ
    PBT4 = 1;       //SCKΪ
    PBT5 = 1;       //MOSIΪ
}

/**********************************************
void Init_spi(void)
  SPIʼ
ֵ
ֵ
ֵ
**********************************************/
void Init_spi(void)
{
    SPIRST = 1;     //λSPI

    while (SPIRST);

    SPICON0 = 0xF0;     //CKS = Fosc/16շ
    SPICON1 &= ~(3 << 6);
    SPICON1 |= 0 << 6;    //0:طͣȣ½ؽգ󣩣
    MS = 1;     //0ģʽ1ӻģʽ
}

/**********************************************
void isr(void) interrupt
  жϷ
ֵ
ֵ
ֵ
**********************************************/
void isr(void) interrupt
{
    if (RBIE == 1 && RBIF == 1)     //SPIж
    {
        RBIF = 0;                   //жϱ־

        rxbuf[rxcnt++] = SPIRBR;

        if (rxcnt > RXBUF_SIZE - 1)
            rxcnt = 0;

        CLRWDT();
    }

    if (TBIE == 1 && TBIF == 1)     //SPIж
    {
        TBIF = 0;                   //巢жϱ־

        SPITBW = txbuf[txcnt++];

        if (txcnt > TXBUF_SIZE - 1)
            txcnt = 0;

        CLRWDT();
    }

    SPI_GIEIF = 0;  //жϱ־
}

/**********************************************
void main(void)
  
ֵ
ֵ
ֵ
**********************************************/
void main(void)
{
//    RAMclear();
    GPIOInit();
    Init_spi();
    RBIE = 1;       //򿪽ж
    TBIE = 1;       //򿪷ж
    SPI_GIEIE = 1;  //SPIж
    SPI_GIEIF = 0;  //жϱ־
    GIE = 1;        //ж
    REN = 1;        //򿪽
    SPIEN = 1;      //SPIʹ

    while (1)
    {
        CLRWDT();
    }
}
