/*********************************************************
*Copyright (C), 2023, Shanghai Eastsoft Microelectronics Co., Ltd
*ļ:  rtc.c
*  :  AE Team
*  :  v1.0iDesigner(v4.2.3.187) + HRCC(v1.2.0.136)
*  :  2023/01/31
*  :  RTC
ע:DS1302дĴǵַż,ʱַ+1
:0x80ַд0x01,ȡʱҪ0x81ȡ
DS1302:
bit7  bit6     bit5   bit4    bit3    bit2    bit1     bit0
1    RAM/-CK    A4     A3      A2      A1      A1     RD/-WR
[7]  :ֵЧλ(λ7)߼1,Ϊ 0 ܰдDS1302;
[6]  :Ϊ0ʾȡʱ,Ϊ1ʾȡRAM;
[5:1]:ָʾԪĵַ;
[0]  :0ʾҪд,Ϊ1ʾж;
Ǵλʼ.ڿָһSCLKʱӵʱ
дDS1302,λ(0λ)ʼ.ͬ,ڽ8λĿָһ
SCLK½,DS1302,ҲǴλλ.
ȡʱ(BCD):9~31ַܴ洢
дַ:0x00|0x80~0x3E|0x80   =    0x80~0xBE(ȡż)
ȡַ:0x00|0x81~0x3E|0x81   =    0x81~0xBF(ȡ)
ȡRAM:31ַܴ洢
дַ:0x00|0xC0~0x3E|0xC0   =    0xC0~0xFE(ȡż)
ȡַ:0x00|0xC1~0x3E|0xC1   =    0xC1~0xFF(ȡ)
0x80---ĴBIT7ʾʱͣλ,BIT7Ϊ1ʱֹͣ,0ʱʼ
0x84---СʱĴBITʾ12/24Сʱ,BIT7Ϊ1ʾ12ʱ,Ϊ0ʾ24ʱ;
        BIT5ΪAM/PMλ,BIT5Ϊ1ʾPM,0ʾAM
0x8E---д<д0x00ʾд,0x80ʾд>
дʱĴ:
0x80---
0x82---
0x84---ʱ
0x86---
0x88---
0x8A---
0x8C---
ʱĴ:
0x81---
0x83---
0x85---ʱ
0x87---
0x89---
0x8B---
0x8D---
*****************************************************************************/
#include <string.h>
#include <HIC.h>
#include "types.h"
#include "rtc.h"
 
type_time t_time;
void uart_puts(char *str);

void delay(uint16_t us)
{
	while (us--) {
		NOP(); NOP(); NOP(); NOP(); NOP(); NOP();
		NOP(); NOP(); NOP(); NOP(); NOP(); NOP();
	}
}
 
#if 0
u8 max_day[12]={31,28,31,30,31,30,31,31,30,31,30,31}; //µ
/**********************************************************
Ƿ,صǰ
жʽΪA=X4*10+X3,B=4,A/B;A=B*10+X2,B=4,A/B;A=B*10+X1,B=4,A/B
**********************************************************/
u8 chk_max_day(void)
{
    if(t_time.month == 2)
    {
        if(t_time.year % 4) //t_time.yearȡֵ00~99
            return (29);  //꣬29졣
        else
            return (28);  //Ϊ28졣
    }
    else
    {
        return max_day[t_time.month-1];
    }
}	
#endif
 
void ds1302_write_byte(uint8_t dat)//дһֽ
{
    uint8_t i;

    DS1302_IO_OUT();

    delay(5);

    for(i = 8;i > 0;i --)
    {
        if(dat & 0x01)
        {
            DS1302_IO_HIGH();
        }
        else
        {
            DS1302_IO_LOW();
        }
        dat >>= 1;
        DS1302_CLK_HIGH();
        delay(5);
        DS1302_CLK_LOW();
        delay(5);
    }
}
 
uint8_t ds1302_read_byte(void)//һֽ
{
    uint8_t i = 0;
    uint8_t dat = 0;	
    
	DS1302_IO_IN();
    delay(5);
    
	for(i = 8;i > 0;i --)
    {
        dat >>= 1;
        if(DS1302_IO_IS_HIGH())
        {
            dat |= BIT(7);
        }
        else
        {
            dat &= ~BIT(7);
        }
        DS1302_CLK_HIGH(); //½ضȡ
        delay(5);
        DS1302_CLK_LOW();	
        delay(5);
    }

    return dat;
}
 
void ds1302_write(uint8_t adr,uint8_t dat)//1302оƬдָдַ
{
    DS1302_RST_LOW();
    DS1302_CLK_LOW();	
    DS1302_RST_HIGH();
    ds1302_write_byte(adr);
    ds1302_write_byte(dat);
    DS1302_RST_LOW();
    DS1302_CLK_HIGH();
}
 
uint8_t ds1302_read(uint8_t adr)//1302ݺָȡԴַ
{
    uint8_t temp = 0;
 
    DS1302_RST_LOW();
    DS1302_CLK_LOW();	
    DS1302_RST_HIGH();
    ds1302_write_byte(adr);
    temp = ds1302_read_byte();
    DS1302_RST_LOW();
    //DS1302_CLK_HIGH();
 
    return temp;
}
 
uint8_t bcd_dec(uint8_t bcd)//BCDת10ƺ
{
    return ((bcd/16)*10+(bcd%16));	
}
 
uint8_t dec_bcd(uint8_t dec)//10תBCD
{
    return ((dec/10)*16+(dec%10));
}

//uint8_t a,b,c;
void ds1302_write_time(void)//дʱ
{
	ds1302_write(0x8E, 0x00);        //д
	//t_time.wday = week_conversion(t_time.year,t_time.month,t_time.day);
	ds1302_write(0x80, dec_bcd(t_time.second));   //
	ds1302_write(0x82, dec_bcd(t_time.minute));  //
	//a = t_time.hour/20;
	//b = t_time.hour - a*20;
	//c = b + (a<<5);
	//ds1302_write(0x84, dec_bcd(c));    //ʱ
    ds1302_write(0x84, dec_bcd(t_time.hour));    //ʱ
	ds1302_write(0x86, dec_bcd(t_time.day));     //
	ds1302_write(0x88, dec_bcd(t_time.month));   //
	//ds1302_write(0x8A,dec_bcd(t_time.wday));    //
	ds1302_write(0x8C, dec_bcd(t_time.year));    //
	ds1302_write(0x8E, 0x80);        //ֹд
}

void ds1302_read_time(void) //ȡʱ
{
	t_time.second = bcd_dec(ds1302_read(0x81) & 0x7F);    //
	t_time.minute = bcd_dec(ds1302_read(0x83)); //
	//b = ds1302_read(0x85);
	//t_time.hour = bcd_dec((b)&0x1F+(b>>5)*20);      //ʱ
    t_time.hour = bcd_dec(ds1302_read(0x85));       //ʱ
	t_time.day = bcd_dec(ds1302_read(0x87));        //
	t_time.month = bcd_dec(ds1302_read(0x89));      //
	t_time.year = bcd_dec(ds1302_read(0x8D));       //
	t_time.wday = week_conversion(t_time.year, t_time.month, t_time.day);
}
 
void ds1302_conversion_hourly(uint8_t hourly, uint8_t ampm) //ת12/24Сʱ,AM/PM<˺δ֤>
{
    ds1302_write(0x8E,0x00);	//д
    if(hourly == HOURLY_12) 	//12Сʱ
    {
        t_time.hour |= BIT(7);
        if(ampm == HOURLY_PM) 	//PM
            t_time.hour |= BIT(5);
        else if(ampm == HOURLY_AM)
            t_time.hour &= ~BIT(5);
    }
    else if(hourly == HOURLY_24)	//24Сʱ
    {
        t_time.hour &= ~BIT(7);
    }
    ds1302_write(0x84,dec_bcd(t_time.hour));
    ds1302_write(0x8E,0x80);    	//ֹд
}

void ds1302_write_ram(uint8_t *buf, uint8_t len)
{
	uint8_t i;
	
	ds1302_write(0x8E, 0x00);
	for(i=0; i<len; i++)
	{
		ds1302_write(0xC0 + (i<<1), buf[i]);
	}
	ds1302_write(0x8E, 0x80);
}

void ds1302_read_ram(uint8_t *buf, uint8_t len)
{
	uint8_t i;
	
	ds1302_write(0x8E, 0x00);
	for(i=0; i<len; i++)
	{
		buf[i] = ds1302_read(0xC1 + (i<<1));
	}
	ds1302_write(0x8E, 0x80);
}

void ds1302_reset(void)//λ---дĴʱںͼϢ
{
    //Ĭʱڳʼ
    t_time.second = 0;
    t_time.minute = 0;
    t_time.hour = 0;
    t_time.day = 1;
    t_time.month = 1;
    t_time.year = 23;
    t_time.wday = week_conversion(t_time.year,t_time.month,t_time.day);	
    //дʱ
    //ds1302_write_time();
/*********************************************************************
    //дRAMļϢ
    ds1302_write_ram();
*********************************************************************/
    ds1302_write_time();
 
    ds1302_write(0x8E,0x00);		//д
    ds1302_write(0xFC,0x99);   		//жǷʼʱ
    ds1302_write(0x8E,0x80);    	//ֹд
}

static char buf1[]="DS1302 reinit ......\n";
static char buf2[]="DS1302 init successful !\n";
static char buf3[]="DS1302 init error !\n";
void ds1302_init(void) //1302оƬʼ
{
    uint8_t temp = 0;
 
    DS1302_IO_INIT();
 
    DS1302_RST_LOW();
    DS1302_CLK_LOW();	
 
    temp = ds1302_read(0xFD);	//жǷΪ
    if(temp != 0x99) //ضĴݲĬдֵ---дĬʱ	
    {	
        ds1302_reset(); //дʱ
        uart_puts(buf1);
    }

/********************************************************************************/
    ds1302_write(0x8E,0x00);	//д
    ds1302_write(0xFA,0x89);   	//д0x89
    ds1302_write(0x8E,0x80);    //ֹд
    //delay_ms(10);
    temp = ds1302_read(0xFB);	
    /*if(temp == 0x89)            //ȡдȥֵ
    {	
		char a='c';
        uart_puts(buf2);	
        uart_puts(a);
    }
    else
    {
        uart_puts(buf3);	
    }*/
/********************************************************************************/	
	
    ds1302_read_time();			//ȡʱ

	/********************************************************/	
	ds1302_write(0x8E,0x00);	//д

	if (t_time.second & 0x80) {
		t_time.second &= 0x7F; 		//DS1302ʱ(0x80Ĵbit70)
		ds1302_write(0x80,dec_bcd(t_time.second));
	}

    ds1302_write(0x90,TCS_OFF|DS_OFF);		//类ֹ
 
    //ds1302_conversion_hourly(HOURLY_12,HOURLY_PM);//Сʱ
/********************************************************/	
    ds1302_write(0x8E,0x80);    //ֹд
/*
    if(t_time.second > 59)
        t_time.second = 0;
    if(t_time.minute > 59)
        t_time.minute = 0;
    if(t_time.hour > 23)
        t_time.hour = 0;	
    if(t_time.day > 31)
        t_time.day = 1;		
    if(t_time.month > 12)
        t_time.month = 1;
    if(t_time.year > 99)
        t_time.year = 0;	
*/
}
 
/****************************************************************************
㷨:+++½֮ͳ7 ,ֲ
3·,֮Ҫһٳ7,Ϊ0
century=0 Ϊ21,century=1 Ϊ20
ݾΪBCD
Ϊ16
*****************************************************************************/
uint8_t week_conversion(uint8_t year, uint8_t month, uint8_t day) //ת
{	
    uint16_t y = year + 2000;

    //һºͶ±ǰһ
    if((month==1)||(month==2))
    {
        month+=12;
        y--;
    }

    return (day+2*month+3*(month+1)/5+y+y/4-y/100+y/400)%7+1;
}
