/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:    siic.c
*  :    AE Team
*  :    v1.0iDesigner(v4.2.3.177) + HRCC(v1.2.0.119)
*  :    2021/3/18
*  :    I2Cӻٴ
            1.ʹñŻķʵI2Cĸٴ䣬дһݸ
            ӻٶݣӻյԭͷʽظ
            2.ʹַʵI2CʱҪ
                A.ʹжϣܽI2Cжȼλ
                B.֮ǰҪñڡĿ˵->롱->IIC slave high speed modeѡtrue
                                          ڡĿ˵->롱->Support interrupt vectorsѡtrue
                C.ûڴݣдݵI2CTBĴҪͷSCLI2CTE = 1ܶݣ
                D.ûٶȴ400KHzʱI2C˲ܣϵͳʱӲ32MHz
*  ע:   ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <HIC.h>

sbit  I2C_Restart;
unsigned char I2CRB_REG;
unsigned char I2CTB_REG;

/*********************************************************
: void clear_ram(void)
  : RAMȫ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void clear_ram(void)
{
    __asm
    {
        CLR   IAAL;
        CLR   IAAH;
        CLR   IAD;
        INC   IAAL, 1;
        JBS   PSW, C
        GOTO  $-3;
        INC   IAAH, 1;
        JBS   IAAH, 2
        GOTO  $-6;
    }
}

/*********************************************************
: void delay(void)
  : ʱdelay
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void delay(void)
{
    unsigned char i = 50;

    while (i--);
}

/*********************************************************
: void Init_i2c(void)
  :  I2CSģʼ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void Init_i2c(void)
{
    {
        ANSL = 0xFF;        //ѡӦ˿ΪIO
        ANSH = 0xFF;
        PAT = 0x00;         //IOΪ͵ƽ
        PBT = 0x00;
        PCT = 0x00;
        PA = 0x00;
        PB = 0x00;
        PC = 0x00;

        PBT0 = 1;                   //I2C_SDA,
        PBT1 = 0;                   //I2C_SCL,
    }

    I2C_Restart = 0;        //Դ־
    I2CRST = 1;             //λI2C

    while (I2CRST);

    I2CX16 = 0x0;               //˲ٶȴ400KHzʱرղ˲
    I2CSA = 0x2D << 1;          //ӻַ0x2D
    I2CC = 0xE1;        //ʹI2C˿ڣ©ڲ
    I2CIEC = 0x0B;  //ʹܡʼλ+ӵַƥ+Ӧжʹܣλжʹ
    I2CIE = 1;              //I2Cж
}


/*********************************************************
: void main()
  : 
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void main(void)
{
    clear_ram();
    Init_i2c();
    INTG = 0b11000111;    //ʹȫжϣж
    INTP = 0b01000000;    //жȼ,IG6

    while (1)
    {
        ;
    }
}

/*********************************************************
: void IG6_INT(void) interrupt_high  0x000C
  : IICжϷ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void IG6_INT(void) interrupt_high  0x000C
{
    if (I2CIF && I2CIE)
    {
        if (I2CSRIE && I2CSRIF) /*յʼλ+ַƥ+Ӧλж*/
        {
            I2CSRIF = 0;               //I2Cʼλ+ַƥ+Ӧλ־λ

            if (I2CRW) /**/
            {
                //I2CRBIE = 0;           //I2CжϽֹ
                I2CTBIE = 1;           //I2Cжʹ
                I2C_Restart = 1;
            }
            else /*д*/
            {
                //I2CRBIE = 1;           //I2Cжʹ
                I2CTBIE = 0;           //I2CжϽֹ
            }
        }

        else if (I2CRBIE && I2CRBIF) /*I2Cջн*/
        {
            I2CRB_REG = I2CRB;        //ջӲжϱ־
        }

        else if (I2CTBIE && I2CTBIF) /*I2Cͻδж*/
        {
            I2CTBIF = 0;

            if (I2C_Restart)
            {
                I2CTB = I2CRB_REG;   //дԭͻ
                I2CTE = 1;
                I2C_Restart = 0;
            }
            else
            {
                I2CTB_REG = ~I2CRB_REG;
                I2CTB = I2CTB_REG;   //дͻ
                I2CTE = 1;
            }
        }

        else if ((I2CNAIE && I2CNAIF) || (I2CSPIE && I2CSPIF)) /*NACKֹͣλж*/
        {
            PCT1 = 0;
            PC1 = 0;

            I2C_Restart = 0;        //ԭ־
            I2CRST = 1;             //I2Cģ鸴λʹ

            while (I2CRST);         //I2Cģ鸴λ

            I2CX16 = 0x0;               //˲ٶȴ400KHzʱر
            I2CSA = 0x2D << 1;          //ôӻַ
            I2CC = 0xE1;      //ʹI2C˿ڣ©ڲ
            I2CIEC = 0x0B;    //ʹܡʼλ+ӵַƥ+Ӧжʹܣλжʹ
            I2CIE = 1;              //I2Cж
        }
    }

    I2CIF = 0;
}
