/*********************************************************
*Copyright (C), 2023, Shanghai Eastsoft Microelectronics Co., Ltd
*ļ:  adc_offset.c
*  :  AE Team
*  :  v1.0iDesigner(v4.2.3.187) + HRCC(v1.2.0.136)
*  :  2023/08/07
*  :  ADCͨʾ
          PA7ģ˿
          PB5TX
          PB6RX
          תADֵͨڷ͵λ9600bps궨VDDVREFѡVDDΪοѹˣ
          ѡڲ2.048VΪοѹˡ
          תֵȥoffset_valueADCoffset_valueΪѡڲͨVSSʧУ׼ֵ
          ע⣺
		  1.offset_valueĴڣΪֹתֵСoffset_valueʱADCֱӹ0ADCֻܲ⵽(0xFFF-offset_value)
		  2.ڻȡoffset_valueֵ֮ǰȷVDDȶ
*  ע:  ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>

#define VDDVREF        //궨ѡVDDΪοѹעͱѡڲ2.048VΪοѹ
#define CLRWDT()   {__Asm CWDT;}        //궨幷ָ

typedef unsigned char uchar;
typedef unsigned int uint;

uint adc_value;
uint offset_value = 0;  //ADCУ׼ֵ
uchar str[] = "ͨ תֵΪ:    \r\n\0";

/******************************************************
void RAMclear(void)
  RAM㣬RAMַ0x0000~0x03FF
ֵ
ֵ
ֵ
*******************************************************/
void RAMclear(void)
{
    for (IAAH = 0; IAAH <= 0x03; IAAH++)
    {
        for (IAAL = 0; IAAL < 0xFF; IAAL++)
            IAD = 0x00;

        IAD = 0x00;
    }
}

/******************************************************
void GPIOInit(void)
  ȳʼδõIOΪ͵ƽ
ֵ
ֵ
ֵ
*******************************************************/
void GPIOInit(void)
{
    ANSH = 0xFF;        //ѡӦ˿ΪIO
    ANSL = 0xFF;        //ѡӦ˿ΪIO
    PAT = 0x00;         //IOΪ͵ƽ
    PBT = 0x00;
    PCT = 0x00;
    PA = 0x00;
    PB = 0x00;
    PC = 0x00;
}

/**********************************************
UART_send(uchar *str,uchar ch,uint value)
  UARTͺ
ֵַָ룬ͨADCתֵ
ֵ
ֵ
**********************************************/
void UART_send(uchar *str, uchar ch, uint value)
{
    *(str + 4) = ch + '0';
    *(str + 16) = value / 1000 + '0';
    *(str + 17) = value % 1000 / 100 + '0';
    *(str + 18) = value % 100 / 10 + '0';
    *(str + 19) = value % 10 + '0';

    while (*str)
    {
        while (!TRMT1);

        TX1B = *str++;
    }
}

/**********************************************
ADC_convert(void)
  ADCת
ֵ
ֵ
ֵת12λ
**********************************************/
uint ADC_convert(void)
{
    ADTRG = 1;      //ADת

    while (ADTRG);

    ADIF = 0;

    return (uint)ADCRH << 8 | ADCRL;
}

/*******************************************************
uint GetOffset2048(void)
  ȡοѹΪڲ2.048VʱĳʼʧֵѡڲͨVSSʧУ׼
ֵ
ֵ
ֵoffsetֵ
*******************************************************/
uint GetOffset2048(void)
{
    uint value_tmp = 0;
    uint i = 10000;       //ʱ
    uint j = 3000;        //ʱ

    ADCCL |= 0xF0;      //ADCCL<7:4>ѡͨ
    ADCCL &= 0xEF;      //ѡͨVSS
    ADCCM = 0x6B;       //οԴڲ̶ѡ2.048V,ο̶ѡVSSתλ̶ѡ12λ
    ADCCH = 0xC8;       //λ;ʱFOSC/16
    ADEN = 1;           //ʹADCģ
    VREFEN = 1;         //οѹģʹ

    while (j--);        //ȴ300us

    VREF_CHOPEN = 1;    //ڲοʹܵѹն

    while (i--);        //ȴ1msת

    ADC_LP_EN = 1;      //ADC͹ı̶ʹ
    SMPS = 1;           //ӲƲADTRG=1ʱADת

    value_tmp = ADC_convert();

    return value_tmp;
}

/*******************************************************
uint GetOffsetVDD(void)
  ȡοѹΪVDDʱĳʼʧֵѡڲͨVSSʧУ׼
ֵ
ֵ
ֵoffsetֵ
*******************************************************/
uint GetOffsetVDD(void)
{
    uint value_tmp = 0;

    ADCCL |= 0xF0;      //ADCCL<7:4>ѡͨ
    ADCCL &= 0xEF;      //ѡͨVSS
    ADCCM = 0x4B;       //οԴVDD,ο̶ѡVSSתλ̶ѡ12λ
    ADCCH = 0xC8;       //λ;ʱFOSC/16
    ADEN = 1;           //ʹADCģ

    ADC_LP_EN = 1;      //ADC͹ı̶ʹ
    SMPS = 1;           //ӲƲADTRG=1ʱADת

    value_tmp = ADC_convert();

    return value_tmp;
}

/**********************************************
main(void)
  ,ѡAIN7ֵͨUART͵λ
ֵ
ֵ
ֵ
**********************************************/
void main(void)
{
    uint i = 10000;       //ʱ
    uint j = 3000;        //ʱ

//    RAMclear();
    CLRWDT();
    GPIOInit();

    /****************ʼUART*******************/
	PB5 = 1;        //TXʼߵƽ
    PBT5 = 0;       //TX
    PBT6 = 1;       //RX
    TX1LEN = 0;     //8λݷ͸ʽ
    BRGH1 = 0;      //ʵģʽ=Fosc/(64*(BRR<7:0>+1))
    BR1R = 25;      //=16MHz/(64*26)9600bps

    /****************ʼADC********************/
#ifdef VDDVREF
    offset_value = GetOffsetVDD();  //ȡoffsetֵ

    ANSL7 = 0;          //ѡAIN7Ϊģ
    ADCCL |= 0xF0;      //ADCCL<7:4>ѡͨ
    ADCCL &= 0x7F;      //ѡͨ7
    ADCCM = 0x4B;       //οԴVDD,ο̶ѡVSSתλ̶ѡ12λ
    ADCCH = 0xC8;       //λ;ʱFOSC/16
    ADEN = 1;           //ʹADCģ
#else
    offset_value = GetOffset2048();  //ȡoffsetֵ

    ANSL7 = 0;          //ѡAIN7Ϊģ
    ADCCL |= 0xF0;      //ADCCL<7:4>ѡͨ
    ADCCL &= 0x7F;      //ѡͨ7
    ADCCM = 0x6B;       //οԴڲ̶ѡ2.048V,ο̶ѡVSSתλ̶ѡ12λ
    ADCCH = 0xC8;       //λ;ʱFOSC/16
    ADEN = 1;           //ʹADCģ
    VREFEN = 1;         //οѹģʹ

    while (j--);        //ȴ300us

    VREF_CHOPEN = 1;    //ڲοʹܵѹն

    while (i--);        //ȴ1msת
#endif

    ADC_LP_EN = 1;      //ADC͹ı̶ʹ
    PAT7 = 1;
    SMPS = 1;           //ӲƲADTRG=1ʱADת

    while (1)
    {
        adc_value = ADC_convert();

        if (adc_value > offset_value)  //ADתֵoffsetֵȥoffsetADC0
            adc_value -= offset_value;
        else
            adc_value = 0;

        TX1EN = 1;      //򿪷
        UART_send(str, 7, adc_value);

        for(j = 0; j < 6; j++)
            for (i = 0; i < 50000; i++);   //ʱ

        TX1EN = 0;      //رշ

        CLRWDT();
    }
}
