/*********************************************************
*Copyright (C), 2020, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	tk_lib.c
*  :	AE Team
*  :	V1.0
*  :	2024/03/18
*  :	شӳ
*  ע:    ESD-TKT-7P2124-Button 
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "main.h"

const unsigned char ch_table[TK_NUM] =
{
#if TK_NUM >0
    TK_CHANNEL_0,
#endif
#if TK_NUM >1
    TK_CHANNEL_1,
#endif
#if TK_NUM >2
    TK_CHANNEL_2,
#endif
#if TK_NUM >3
    TK_CHANNEL_3,
#endif
#if TK_NUM >4
    TK_CHANNEL_4,
#endif
#if TK_NUM >5
    TK_CHANNEL_5,
#endif
#if TK_NUM >6
    TK_CHANNEL_6,
#endif
#if TK_NUM >7
    TK_CHANNEL_7,
#endif
#if TK_NUM >8
    TK_CHANNEL_8,
#endif
#if TK_NUM >9
    TK_CHANNEL_9,
#endif
#if TK_NUM >10
    TK_CHANNEL_10,
#endif
#if TK_NUM >11
    TK_CHANNEL_11,
#endif
#if TK_NUM >12
    TK_CHANNEL_12,
#endif
#if TK_NUM >13
    TK_CHANNEL_13,
#endif
#if TK_NUM >14
    TK_CHANNEL_14,
#endif
#if TK_NUM >15
    TK_CHANNEL_15,
#endif
#if TK_NUM >16
    TK_CHANNEL_16,
#endif
#if TK_NUM >17
    TK_CHANNEL_17,
#endif
#if TK_NUM >18
    TK_CHANNEL_18,
#endif
#if TK_NUM >19
    TK_CHANNEL_19
#endif
};

const unsigned int thd_table[TK_NUM] =
{
#if TK_NUM >0
    TK_THD_CHANNEL_0,
#endif
#if TK_NUM >1
    TK_THD_CHANNEL_1,
#endif
#if TK_NUM >2
    TK_THD_CHANNEL_2,
#endif
#if TK_NUM >3
    TK_THD_CHANNEL_3,
#endif
#if TK_NUM >4
    TK_THD_CHANNEL_4,
#endif
#if TK_NUM >5
    TK_THD_CHANNEL_5,
#endif
#if TK_NUM >6
    TK_THD_CHANNEL_6,
#endif
#if TK_NUM >7
    TK_THD_CHANNEL_7,
#endif
#if TK_NUM >8
    TK_THD_CHANNEL_8,
#endif
#if TK_NUM >9
    TK_THD_CHANNEL_9,
#endif
#if TK_NUM >10
    TK_THD_CHANNEL_10,
#endif
#if TK_NUM >11
    TK_THD_CHANNEL_11,
#endif
#if TK_NUM >12
    TK_THD_CHANNEL_12,
#endif
#if TK_NUM >13
    TK_THD_CHANNEL_13,
#endif
#if TK_NUM >14
    TK_THD_CHANNEL_14,
#endif
#if TK_NUM >15
    TK_THD_CHANNEL_15,
#endif
#if TK_NUM >16
    TK_THD_CHANNEL_16,
#endif
#if TK_NUM >17
    TK_THD_CHANNEL_17,
#endif
#if TK_NUM >18
    TK_THD_CHANNEL_18,
#endif
#if TK_NUM >19
    TK_THD_CHANNEL_19
#endif
};

const unsigned int thd_table_9_10[TK_NUM] =
{
#if TK_NUM >0
    TK_THD_CHANNEL_0 * 9 / 10,
#endif
#if TK_NUM >1
    TK_THD_CHANNEL_1 * 9 / 10,
#endif
#if TK_NUM >2
    TK_THD_CHANNEL_2 * 9 / 10,
#endif
#if TK_NUM >3
    TK_THD_CHANNEL_3 * 9 / 10,
#endif
#if TK_NUM >4
    TK_THD_CHANNEL_4 * 9 / 10,
#endif
#if TK_NUM >5
    TK_THD_CHANNEL_5 * 9 / 10,
#endif
#if TK_NUM >6
    TK_THD_CHANNEL_6 * 9 / 10,
#endif
#if TK_NUM >7
    TK_THD_CHANNEL_7 * 9 / 10,
#endif
#if TK_NUM >8
    TK_THD_CHANNEL_8 * 9 / 10,
#endif
#if TK_NUM >9
    TK_THD_CHANNEL_9 * 9 / 10,
#endif
#if TK_NUM >10
    TK_THD_CHANNEL_10 * 9 / 10,
#endif
#if TK_NUM >11
    TK_THD_CHANNEL_11 * 9 / 10,
#endif
#if TK_NUM >12
    TK_THD_CHANNEL_12 * 9 / 10,
#endif
#if TK_NUM >13
    TK_THD_CHANNEL_13 * 9 / 10,
#endif
#if TK_NUM >14
    TK_THD_CHANNEL_14 * 9 / 10,
#endif
#if TK_NUM >15
    TK_THD_CHANNEL_15 * 9 / 10,
#endif
#if TK_NUM >16
    TK_THD_CHANNEL_16 * 9 / 10,
#endif
#if TK_NUM >17
    TK_THD_CHANNEL_17 * 9 / 10,
#endif
#if TK_NUM >18
    TK_THD_CHANNEL_18 * 9 / 10,
#endif
#if TK_NUM >19
    TK_THD_CHANNEL_19 * 9 / 10
#endif
};

sbit tk_enhance_filter;
unsigned int tk_press_timeout,tk_base_up_time,tk_jitter_thd_lv1,tk_jitter_thd_lv2;
unsigned char timer_10ms,tk_ch_num,tk_sample_perscan,tk_debounce_press,tk_debounce_release;
tk_arr_t tk_arr[TK_NUM];

/*********************************************************
:	void tk_init(void)
  :	ģϵʼ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void tk_init(void)
{
#ifdef TK_ENHANCE_FILTER
	tk_enhance_filter = 1;
#else
	tk_enhance_filter = 0;
#endif
	tk_init_state = FIRST_POWER_UP;
	tk_press_timeout = TK_PRESS_TIMEOUT;
	tk_debounce_press = TK_DEBOUNCE_PRESS;
	tk_debounce_release = TK_DEBOUNCE_RELEASE;
	tk_sample_perscan = TK_SAMPLE_PERSCAN;
	tk_jitter_thd_lv1 = TK_JITTER_THD_LV1;
	tk_jitter_thd_lv2 = TK_JITTER_THD_LV2;
	tk_base_up_time = TK_BASE_UP_TIME;
	tk_ch_num = TK_NUM;
}

/*********************************************************
:	void tk_reg_config(void)
  :	ģĴ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void tk_reg_config(void)
{
	unsigned char i;

	TKEN = 0;					//For TK module reset
	TKGO = 0;					//Ӧģر
	TKIF = 0;

	TKCTL6 = TK_REG_TKCTL6;		//TKVREF_EN ʹܺһʱȶ
	TKCTL0 = TK_REG_TKCTL0;
	TKCTL1 = TK_REG_TKCTL1;
	TKCTL2 = TK_REG_TKCTL2;
	TKCTL3 = TK_REG_TKCTL3;            
	TKCTL4 = TK_REG_TKCTL4;              
	TKCTL5 = TK_REG_TKCTL5;
	
	TKINTE = TK_REG_TKINTE;
	TKINTF &= 0xF0;     //жϱ־			

	TKMODL = 0xFF;		//÷ŴϵĴ24λ
	TKMODM = 0xFF;
	TKMODH = 0x0F;
	TKMODU = 0x00;	    //Ŵϵ4λ=0
				
	TKCHSL = (unsigned char)(TK_CHANNEL_SEL & 0xFF);
	TKCHSM = (unsigned char)((TK_CHANNEL_SEL>>8) & 0xFF);
	TKCHSH = (unsigned char)((TK_CHANNEL_SEL>>16) & 0xFF);

	//TKFJCTL = TK_reg_TKFJCTL;
	//TKSFJT0 = 1;  //4M init
	//TKSFJT1 = 1;  

	TKIE = 1;

	for(i = 0; i < 130; i++) {		//ѹȶҪʱ
		__Asm NOP;
		__Asm CWDT;
	}

	TKEN = 1;
	
	for(i = 0; i < 20; i++) {		//ȶҪʱ
		__Asm NOP;
		__Asm CWDT;
	}

	tk_value_get = 0;
	tk_init_state = 0;
}

/*********************************************************
:	void tk_jitter(void)
  :	Ƶ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void tk_jitter(void)
{
#if AUTO_JITTER_SOFTWARE == ON
	if(lock_avg_cnt) {
		if((TKCTL2 & 0xF0) == TK_REG_TKCTL2) {
			TKCTL2 = TK_REG_TKCTL2_bk1;
		}
		else {
			TKCTL2 = TK_REG_TKCTL2;
		}
	}
	else {
		TKCTL2 = TK_REG_TKCTL2;			
	}
#endif
#if AUTO_JITTER_HARDWARE == ON
	if(lock_avg_cnt)  {
		TKFJCTL = 0x02;
	}
	else {
		TKFJCTL = 0x00;
	}
#endif	
	tk_value_get = 0;
	tk_init_state = 0;
}

/*********************************************************
:	void tk_convert_complete(void)
  :	Ӳ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void tk_convert_complete(void)
{
	if(TKIE && TKIF) {					   //ģ鹤
		TKIF = 0;
 
		if(TKOVIF||TKERRIF||SCANOVIF) {    
			tk_value_get = 0;			   //ɨ쳣						  										  			 
		}
		else {
			tk_value_get  = 1;             //ɨ
		}
		TKINTF &= 0xF0;                    //жϱ־
				
		if(tk_value_get == 0) {
			TKGO = 1;					   //
		}
	}
}

/*********************************************************
:	void timer_check(void)
  :	TKʱ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void timer_check(void)
{
	if (timer_10ms < 5)		//2ms*5==10ms ʱʱıʱ޸Ĳ
		return;

	timer_10ms = 0;

	tk_base_up_lock_cnt();  //¼ʱ
#if TK_PRESS_TIMEOUT != 0
	tk_press_to();			//ʱǿƸ»
#endif

#if TK_UART_FUNC == ON
	if(Tx_timer)
	{
		Tx_timer++;
		if(Tx_timer > 125)		   //ͳʱλ
		{
			Tx_timer = 0;
			g_tp = 0;
		}
	}
#endif
}

/*********************************************************
:	void tk_delt_value_sum_calculate(void)
  :	ֵ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void tk_delt_value_sum_calculate(void)
{

}

/*********************************************************
:	void tk_delt_value_sum_process(void)
  :	ֵ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void tk_delt_value_sum_process(void)
{

}
