/*********************************************************
*Copyright (C), 2020, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	tk_lib.h
*  :	AE Team
*  :	V1.0
*  :	2024/03/18
*  :	شӳ
*  ע:    ESD-TKT-7P2131-Button 
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#ifndef   __TK_LIB_H__
#define   __TK_LIB_H__

// ﵽ趨űΪ»ͷţ->ȶ С->
#define  TK_DEBOUNCE_PRESS				10			// µĴ趨
#define  TK_DEBOUNCE_RELEASE			5			// 뿪Ĵ趨

// ÿβۼӲƽ->ȶ С->
#define  TK_SAMPLE_PERSCAN				4			// ۼ趨4--16

// ݵСֵ֮ΪֵֵӦϵͳȶ->ܸţа󴥷 С->ֻܸСţаٶ۷
#define  TK_JITTER_THD_LV1				(TK_THD_CHANNEL_0*1.5*TK_NUM)	// ֵ趨ֵʱ
#define  TK_JITTER_THD_LV2				(TK_THD_CHANNEL_0*2*TK_NUM)		// ֵ趨ֵʱΰ

#define  TK_BASE_UP_TIME				80			// *10msʱ ߸ʱһΰʱ
#define  TK_PRESS_TIMEOUT				6000		// *10msʱ ʱʱ

// Jitter_levelʹʱݶJitter_level1Ƶ
#define  AUTO_JITTER_SOFTWARE			OFF		    // ON/OFF Ƶ
#define  AUTO_JITTER_HARDWARE			OFF		    // ON/OFF ӲƵأıHRCƵʡ25%

// ˲ǿ
#define  TK_ENHANCE_FILTER							// ĬϿǿ˲

// ˿жϿ
#define  PINT_WAKE_FUNC					OFF		    // ON/OFF

// жϿ
#define	 KINT_WAKE_FUNC					OFF		    // ON/OFF

//TK_advance
#define  TK_REG_TKCTL0					0x38
#define  TK_REG_TKCTL1					0x02        // 1/2 ռձ
#define  TK_REG_TKCTL2					0x20        // 0x20 4M  
#define  TK_REG_TKCTL2_bk1				0x30        // 0x30 2M 
#define  TK_REG_TKCTL3					0x00        
#define  TK_REG_TKCTL4					0x32        // ߹ģʽ 128 CLOCK ŵʱ
#define  TK_REG_TKCTL5					0x3D        // CP 2.6V 
#define  TK_REG_TKCTL6					0x80
#define  TK_REG_TKINTE					0x0F
#define  TK_REG_TKFJCTL					0x00        //  <15 ƵЧӲƵ ʱ

#define  PA_PORT						0x00
#define  PB_PORT						0x80
#define  PE_PORT						0x20

#define  TK0							(PA_PORT+0)	   // PA0
#define  TK1							(PA_PORT+1)	   // PA1
#define  TK2							(PA_PORT+2)	   // PA2
#define  TK3							(PA_PORT+3)	   // PA3
#define  TK4							(PA_PORT+4)	   // PA4
#define  TK5							(PA_PORT+5)	   // PA5
#define  TK6							(PA_PORT+6)	   // PA6
#define  TK7							(PA_PORT+7)	   // PA7
#define  TK8							(PB_PORT+8)	   // PB6
#define  TK9							(PB_PORT+9)	   // PB7
#define  TK10							(PE_PORT+10)   // PE0
#define  TK11							(PE_PORT+11)   // PE1
#define  TK12							(PE_PORT+12)   // PE2
#define  TK13							(PE_PORT+13)   // PE3
#define  TK14							(PE_PORT+14)   // PE4
#define  TK15							(PE_PORT+15)   // PE5
#define  TK16							(PE_PORT+16)   // PE6
#define  TK17							(PE_PORT+17)   // PE7
#define  TK18							(PB_PORT+18)   // PB4
#define  TK19							(PB_PORT+19)   // PB5

typedef enum
{
    FIRST_POWER_UP = 0x1U,
    RELOCATION = 0x2U,
} tk_init_state_t;

typedef struct
{
    unsigned long tk_org;       // Origin      data
    unsigned int tk_filter;     // Filter      data
    unsigned int tk_avg;        // Base line   data
    unsigned int tk_to_cnt;     // For TK press time counter
    unsigned char tk_press;     // For press    counter
    unsigned char tk_release;   // For release  counter
    unsigned int _max;          // Origin Max     data
    unsigned int _min;          // Origin Min     data
	unsigned long input[2];
	unsigned long output[2];
} tk_arr_t;

extern sbit tk_value_get;
extern sbit tk_sleep_flag;
extern sbit tk_enhance_filter;
extern unsigned int tk_delt_value_sum_plus,tk_delt_value_sum_minus;
extern unsigned char abnormanl_plus_key_num,abnormanl_minus_key_num;
extern unsigned int tk_press_timeout,tk_base_up_time,tk_jitter_thd_lv1,tk_jitter_thd_lv2;
extern unsigned char tk_ch_num,tk_sample_perscan,tk_debounce_press,tk_debounce_release;
extern unsigned char tkscan_cnt,base_up_cnt,lock_avg_cnt,timer_10ms;
extern unsigned long tk_state;
extern const unsigned char ch_table[],ch_table_lp[];
extern const unsigned int thd_table[],thd_table_9_10[],thd_table_lp[];
extern tk_init_state_t tk_init_state;
extern tk_arr_t curr_tk_value,tk_arr[];

extern void proc_curr_tk_value(unsigned char idx, unsigned char direct);
extern void tk_force_average(unsigned char ch);
extern void tk_press_to(void);
extern void tk_base_up_lock_cnt(void);
extern void tk_pin(void);
extern void tk_service(void);
extern void tk_init(void);
extern void tk_reg_config(void);
extern void tk_jitter(void);
extern void tk_convert_complete(void);
extern void timer_check(void);
extern void tk_delt_value_sum_calculate(void);
extern void tk_delt_value_sum_process(void);
extern void prepareforsleepmode_init(void);
extern void wakeupfromsleepmode_init(void);
extern void tk_standby(void);

#endif
