/*********************************************************
*Copyright (C), 2020, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	init.c
*  :	AE Team
*  :	V1.0
*  :	2024/03/18
*  :	ʼӳ
*  ע:    ESD-TKT-7P2131-Button 
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "init.h"
/*********************************************************
:	void delay100ms(uchar time)
  :	ʱӳ
ֵ: timeʱλ100ms
ֵ: 
ֵ: 
**********************************************************/
void delay100ms(uchar time)
{
	uchar i, j, k;
	for(i = 0; i < time; i++)
	{
		for(j = 0; j < 249; j++)			
		{
			for(k = 0; k < 249; k++)
			{
				nop();
				nop();
				nop();
				nop();
				nop();
				clr_wdt();    // 忴Ź
			}
		}
	}
}

/*********************************************************
:	void ram_clear(void) 
  :	ͨRAMӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
//ݴ洢ռΪ1024 ֽڣΪ8 洢飨SRAM SECTION 0~7ÿSRAM洢Ϊ128 ֽڣѰַַΧΪ0000H~03FFH
void ram_clear(void)
{
    GIE = 0;
    for(IAAH = 0; IAAH < 0x04; IAAH++)
    {
		for(IAAL = 0; IAAL < 0xFF; IAAL++)
		{
		   IAD = 0x00;
		}
		IAD = 0x00;
		//clr_wdt(); 
    }
}

/*********************************************************
:	void wdt_set(uchar time)
  :	ͨWDTӳ
ֵ: uchar time
ֵ: 
ֵ:  
**********************************************************/
void wdt_set(uchar time)
{
	WDTUL = 0xA5;	//
	WDTC = time|0xC0;
	WDTUL = 0xA0;	//
}

/*********************************************************
:	void sysclk_set(void) 
  :	ͨϵͳʱ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void sysclk_set(void)
{
	volatile uchar sys_divs,sys_scks;
    OSCWP = 0x55;
	HRCEN = 1;
	HRCSEL = 1;		//ѡHRCʱƵΪ16MHz
	sys_divs = 0x00;	//1:1Ƶ
	//sys_divs = 0x10;	//1:2Ƶ
	//sys_divs = 0x20;	//1:4Ƶ
	//sys_divs = 0x30;	//1:8Ƶ
	//sys_divs = 0x40;	//1:16Ƶ
	//sys_divs = 0x50;	//1:32Ƶ
	//sys_divs = 0x60;	//1:64Ƶ
	//sys_divs = 0x70;	//1:128Ƶ
	sys_scks = 0x00;	//HRCʱԴ
	//sys_scks = 0x01;	//LRCʱԴ
	//sys_scks = 0x02;	//HOSCʱԴ
	//sys_scks = 0x03;	//EXTCLK(ⲿʱ)
	OSCC1 = sys_divs | sys_scks;
	while(!HRCON){} //ȴHRC״̬λ
	while(CHG){}	//жʱת־
	if((SST0 != 0) || (SST1 != 0))	//((SST0 != 0) || (SST1 != 1))
	{
		while(1);
	}
	CLKOEN = 0;		//ʱʹ
	//CLKO_FSEL = 0;	//ѡϵͳʱ128Ƶʱ
	OSCWP = 0x5A;
}

/*********************************************************
:	void int_vectors_init(void)
  :	ͨжģʽӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void int_vectors_init(void)
{
	INTVEN0 = 1;		// жģʽ
	INTV0   = 0;
	INTV1   = 0;		// ȼ00
	INTP    = 0;
#if  TK_UART_FUNC == ON
	INTP    = 0x20;		// RX TX ȼ
#endif
	GIEL    = 1;
}

/*********************************************************
:	void gpio_set(void) 
  :	ͨGPIOӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void gpio_set(void)
{
/*	ʾ
	PAT = 0x00;		//
	PAS = 0x00;		//
	PA = 0x00;		//͵ƽ

	PAT0 = 0x00;	//
	PAS0 = 0x00;	//
	PA0 = 0x00;		//͵ƽ
*/
}

/***********************************************************
:	void mcu_init(void) 
  :	ϵͳʼӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void mcu_init(void) 
{
	ram_clear();		//ramȫ㣬бֵ㣬ڴ˺ֵ֮
	wdt_set(WDT_4080MS);//Ź4S
	sysclk_set();		//HRC16M
	int_vectors_init(); //жģʽҪ
}
