/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  iap
*  :  AE Team
*  :  V1.2
*  :  2023/05/30
*  :  IAP
          1.ʹES7P0213оƬIAPܣFLASHвдĲ.
		  2.ʵֶ0x0A00ʼַľҳ̣ȻȡõַݣǷдһ¡
*  ע:  ES7P0213
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>

unsigned int RamBuff[16];         //Ram16

union{
    unsigned int Word;
    unsigned char Byte[2];
}FlashAddr;                       //Flashַ

union{
    unsigned int Word[2];
    unsigned char Byte[4];
}FlashData;                       //Flashݱ

typedef enum {
	ERROR = 0x0,
	OK    = 0x1,
} func_status_t;

/********************************************************
:	void ram_clear(void) 
  :	ͨRAMӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void ram_clear(void)
{
    GIE = 0;
    GIEL = 0;
    for(IAAH = 0; IAAH < 0x04; IAAH++)
    {
		for(IAAL = 0; IAAL < 0xFF; IAAL++)
		{
		   IAD = 0x00;
		}
		IAD = 0x00;
		//clr_wdt(); 
    }
}

/*********************************************************
:	void delay(unsigned short times)
  :	ʱ
ֵ: unsigned short times
ֵ: 
ֵ: 
**********************************************************/
void delay(unsigned short times)
{
	unsigned short loop = 0;
	for (; loop < times; loop++) {
		__asm{
			NOP
			NOP
			NOP
			NOP
			NOP
			NOP
			NOP
			NOP
			NOP
			NOP
		}
	}
}

/*********************************************************
:	func_status_t FlashWriteData(void)
  :	Flashд
ֵ: 
ֵ: 
ֵ: OK/ERROR
**********************************************************/
func_status_t FlashWriteData(void)
{	
	unsigned char i = 0;
	unsigned char gie_bk = GIE;
	unsigned char lvd_bk = LVDEN;
	unsigned char lvdflt_bk = LVDFLTEN;
	unsigned char timer_cnt_temp;

	__asm{CWDT};		//幷
        
	while(GIE == 1)     //ȫж
    {
        GIE = 0;
    }

	LVDEN = 0;					//ر
	LVDFLTEN = 0; 				//ֹLVD˲

	timer_cnt_temp = T10;		//
	T10 = 6;					//IAPʱ250*32us

	FRAH = FlashAddr.Byte[1];	//дʼַ
	FRAL = FlashAddr.Byte[0];	

    FRAHN = ~FRAH;
    FRALN = ~FRAL;

    ROMDH = FlashData.Byte[1];  //д
    ROMDL = FlashData.Byte[0];

    ROMDHN = ~ROMDH;            //д
    ROMDLN = ~ROMDL;

    ROMD1H = FlashData.Byte[3]; //д
    ROMD1L = FlashData.Byte[2];

    ROMD1HN = ~ROMD1H;          //д
    ROMD1LN = ~ROMD1L;

	TOEN = 1;					//ʹTimeoutʱ
	IAPIE = 1;					//IAPжʹ
	IAPCLR = 1;					//IAP״̬

	IAPUL = 0xA5;				//
	while (IAPUL == 0) 
	{
		delay(100);
		i++;
		if (i == 100)
		{
			IAPUL = 0x00;				//
	
			IAPIE = 0;					//ж

			T10 = timer_cnt_temp;		//ָ״̬
			GIE = gie_bk;				
			LVDEN = lvd_bk;				
			LVDFLTEN = lvdflt_bk; 	
			return ERROR;
		}
	}							//жǷɹ 

	IAPPRGS = 0xD5;				//д

	while (IAP_DONE != 1) 
	{
		delay(100);
		i++;
		if (i == 100)
		{
			IAPUL = 0x00;				//
	
			IAPIE = 0;					//ж

			T10 = timer_cnt_temp;		//ָ״̬
			GIE = gie_bk;				
			LVDEN = lvd_bk;				
			LVDFLTEN = lvdflt_bk; 	
			return ERROR;
		}
	}							//жϲǷ*/  

	IAPUL = 0x00;				//
	
    IAPIE = 0;					//ж

	T10 = timer_cnt_temp;		//ָ״̬
	GIE = gie_bk;				
	LVDEN = lvd_bk;				
	LVDFLTEN = lvdflt_bk; 		
	return OK;
}

/*********************************************************
:	void FlashReadData(void) 
  :	Flash
ֵ: 
ֵ: bufݻ
ֵ: 
**********************************************************/
void FlashReadData(void)
{
	unsigned char gie_bk = GIE;

	__asm{CWDT};		//幷
	
	while(GIE == 1)     //ȫж
    {
        GIE = 0;
    }

	ROMDH = 0;
	ROMDL = 0;

	ROMD1H = 0;
	ROMD1L = 0;

    FRAH = FlashAddr.Byte[1];    //öʼַ
    FRAL = FlashAddr.Byte[0];

	__Asm TBR;		             //

    FlashData.Byte[1] = ROMDH;
    FlashData.Byte[0] = ROMDL;

    FlashData.Byte[3] = ROMD1H;
    FlashData.Byte[2] = ROMD1L;

	GIE = gie_bk;				 //ȫж
}

/*********************************************************
:	func_status_t FlashErasePage(void)
  :	Flash
ֵ: 
ֵ: 
ֵ: OK/ERROR
**********************************************************/
func_status_t FlashErasePage(void)
{
	unsigned char i = 0;
	unsigned char gie_bk = GIE;
	unsigned char lvd_bk = LVDEN;
	unsigned char lvdflt_bk = LVDFLTEN;

	__asm{CWDT};		//幷
	
	while(GIE == 1)     //ȫж
    {
        GIE = 0;
    }

	LVDEN  = 0;				  //رLVD
	LVDFLTEN = 0; 			  //ֹLVD˲

	FRAH = FlashAddr.Byte[1];
	FRAL = FlashAddr.Byte[0];

	FRAHN = ~FRAH;
	FRALN = ~FRAL;

	IAPIE = 1;
	IAPCLR = 1;

	IAPUL = 0xA5;             //Ᵽ

	while (IAPUL == 0) 
	{
		delay(100);
		i++;
		if (i == 100)
		{
			IAPUL = 0x00;				//
	
			IAPIE = 0;					//ж

			GIE = gie_bk;			//ָ״̬
			LVDEN = lvd_bk;				
			LVDFLTEN = lvdflt_bk; 	
			return ERROR;
		}
	}                         //жǷɹ 

	IAPERSS = 0x9D;

	while (IAP_DONE != 1) 
	{
		delay(100);
		i++;
		if (i == 100)
		{
			IAPUL = 0x00;				//
	
			IAPIE = 0;					//ж

			GIE = gie_bk;			//ָ״̬
			LVDEN = lvd_bk;				
			LVDFLTEN = lvdflt_bk; 	
			return ERROR;
		}
	}                         //жϲǷ*/  

	IAPUL = 0x00;

    IAPIE = 0;				  //ж

	GIE = gie_bk;			  //ָ״̬
	LVDEN = lvd_bk;				
	LVDFLTEN = lvdflt_bk; 	
	return OK;
}

/*********************************************************
:	void main()
  :	
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void main() 
{
	unsigned char i;
	unsigned int addr;

	ram_clear();							//RAMʼ

	WDTUL = 0xA5;							//WDT
	WDTC = 0xD9;							//64ms
	WDTUL = 1;							

	addr = 0x4000;
	FlashAddr.Word = addr;					//ʼַ

    for(i = 0;i < 8;i++)
    {
        FlashReadData();					//Flash 
        RamBuff[2*i] = FlashData.Word[0];   //ݵǰRam
        RamBuff[2*i+1] = FlashData.Word[1]; 
        FlashAddr.Word += 2;      
    }  

	FlashAddr.Word = addr;					//ʼַ 
	FlashErasePage();						//ҳFlash

    for(i = 0;i < 16;i++)
    {
        RamBuff[i] = i;						//޸Ramǰ16ֽ
    }

    for(i = 0;i < 8;i++)
    {
        FlashData.Word[0] = RamBuff[2*i];
        FlashData.Word[1] = RamBuff[2*i+1];
        FlashWriteData();					//дFlash  
        FlashAddr.Word += 2;        
    }

    for(i = 0;i < 16;i++)
    {
        RamBuff[i] = 0;						//޸Ram
    }

    FlashAddr.Word = addr;					//ʼַ 
    for(i = 0;i < 8;i++)
    {
        FlashReadData();					//ٴζFlash 
        RamBuff[2*i] = FlashData.Word[0];   //Ƿд
        RamBuff[2*i+1] = FlashData.Word[1];
        FlashAddr.Word += 2;      
    }
	while (1)
	{
		__Asm CWDT;
	}
}
