/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  rw_flash.c
*  :  AE Team
*  :  V1.00	iDesigner(v4.2.3.182) + HRCC(v1.2.0.122)
*  :  2022/03/29
*  :  Bootloaderʾ
		  PA0ģBootPIN
          PB4TX
		  PB5RX
		  ʣ9600  λ8λ  ֹͣλ1λ  У飺У λǰ
		  ʾοӦñʼǡAN102_Ӧñʼ_BootISPλ7PϵMCU Bootloader롶AN112_UserManual_ES-UART-BOOT
*  ע:  ES7P0213оƬ
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include  <hic.h>
#include  "macrodef.h"
#include  "rw_flash.h"

/**********************************************
check_empty
  ѯFlashǷΪ
ֵword_addr:Flashʼַ;num:յֽ
ֵ
ֵSUCCESSFAILED
**********************************************/
u8 check_empty(u16  word_addr, u16 num)
{
	u16  i,buf16;
    for(i = 0; i < (num / 2); i++)
    {
		if(i % 2 == 1)
		{
			__Asm  TBR;
			buf16 = (((u16)ROMD1H << 8) + ROMD1L);
			++word_addr;
			//buf_Addr += 2;
		}
		if(i % 2 == 0)
		{
			FRAL = word_addr;
			FRAH = word_addr >> 8;
			//FRAHN = ~FRAH;
			//FRALN = ~FRAL;
			__Asm  TBR;
			buf16 = (((u16)ROMDH << 8) + ROMDL);
			++word_addr;
			//buf_Addr += 2;
		}

        if(buf16 != 0xFFFF)
		{
			return  FAILED;
		}
    }
    return  SUCCESS;
}

/**********************************************
Read_Cont
  Flash
ֵword_addr:Flashַ; *buf_Addr:ݱַ; num:ֽ
ֵFlashе
ֵSUCCESSFAILED
**********************************************/
u8 Read_Cont(u16  word_addr, u8 *buf_Addr, u16 num)
{
    u16  i;
    for(i = 0; i < (num / 2); i++)
    {
		if(i % 2 == 1)
		{
			__Asm  TBR;
			*(u16 *)buf_Addr = (((u16)ROMD1H << 8) + ROMD1L);
			word_addr++;
			buf_Addr += 2;
		}
		if(i % 2 == 0)
		{
			FRAL = word_addr;
			FRAH = word_addr >> 8;
			//FRAHN = ~FRAH;
			//FRALN = ~FRAL;
			__Asm  TBR;
			*(u16 *)buf_Addr = (((u16)ROMDH << 8) + ROMDL);
			word_addr++;
			buf_Addr += 2;
		}
    }
    return  SUCCESS;
}

/**********************************************
Erase_Page
  һҳFlash
ֵaddrҳڵĵַ
ֵ
ֵSUCCESSFAILED
**********************************************/
u8 Erase_Page(u16  page_addr)
{
    FRAH = page_addr >> 8;	//ַֽ
	FRAL = page_addr;		//ַֽ
	FRAHN = ~FRAH;
	FRALN = ~FRAL;

	IAPCLR = 1;			//IAP״̬
	IAPUL = 0xA5;		//
	IAPERSS = 0x9D;		//
	//__Asm NOP;
    while(!IAP_DONE)	//ȴ
    {
		;
    }
	IAPUL = 0x00;		//
	return SUCCESS;	
}

/**********************************************
Write_SingleWord
  Flashд
ֵword_addrFlashʼַ;buf_Addr:Ҫдݵʼַ num:ݸ
ֵ
ֵSUCCESSFAILED
**********************************************/
u8 Write_Cont(u16  word_addr, u8 *buf_Addr, u16 num)
{
    u16  i;
    for(i = 0; i < (num / 4); i++)  //ÿд˫(32bit)
    {
		FRAH = word_addr >> 8;		//ַֽ
		FRAL = word_addr;			//ַֽ
		FRAHN = ~FRAH;
		FRALN = ~FRAL;
		ROMD1H = (*((u32 *)buf_Addr)) >> 24;
		ROMD1L = (*((u32 *)buf_Addr)) >> 16;
		ROMDH = (*((u32 *)buf_Addr)) >> 8;
		ROMDL = (*((u32 *)buf_Addr));	 //дFlashֽ
		
		ROMD1HN = ~ROMD1H;
		ROMD1LN = ~ROMD1L;
		ROMDHN =  ~ROMDH;
		ROMDLN =  ~ROMDL; 

		IAPCLR = 1;					//IAP״̬
		IAPUL = 0xA5;				//
		IAPPRGS = 0xD5;				//д
		//__Asm NOP;
		while(!IAP_DONE)			//ȴ
		{
			;
		}
		IAPUL = 0x00;				//
	
		word_addr += 2;
		buf_Addr += 4;
    }
    return  SUCCESS;
}