/*********************************************************
*Copyright (C), 2022, Shanghai Eastsoft Microelectronics Co., Ltd
*ļ:  main.c
*  :  AE Team
*  :  V1.00
*  :  2023/05/30
*  :  APPʾ
          PB4TX
		  PB5RX
		  PE5ƽתܽ
		  ʾοӦñʼǡAN102_Ӧñʼ_BootISPλ7PϵMCU Bootloader롶AN112_UserManual_ES-UART-BOOT
*  ע:  ES7P0213оƬ
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>

/**********************************************
Ram_clear
  Ram0
ֵ
ֵ
ֵ
**********************************************/
void Ram_clear(void)
{
    GIE = 0;
    for(IAAH = 0; IAAH < 0x04; IAAH++)
    {
		for(IAAL = 0; IAAL < 0xFF; IAAL++)
		{
		   IAD = 0x00;
		}
		IAD = 0x00;
		//clr_wdt(); 
    }
}

/**********************************************
Close_wdt
  رտŹ
ֵ
ֵ
ֵ
**********************************************/
void Close_wdt(void)
{
	WDTUL = 0xA5;
	SWDTEN = 0;
	WDTIEN = 0;
	WDTUL = 0xAA;
}

/***********************************************************
:	Init_hrc 
  :	ϵͳʱӳʼ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void Init_hrc(void) 
{
	unsigned char sys_divs,sys_scks;
    OSCWP = 0x55;
	HRCEN = 1;
	HRCSEL = 1;		//ѡHRCʱƵΪ16MHz
	while(!HRCON){} //ȴHRC״̬λ

	sys_divs = 0x00;	//1:1Ƶ
	//sys_divs = 0x10;	//1:2Ƶ
	//sys_divs = 0x20;	//1:4Ƶ
	//sys_divs = 0x30;	//1:8Ƶ
	//sys_divs = 0x40;	//1:16Ƶ
	//sys_divs = 0x50;	//1:32Ƶ
	//sys_divs = 0x60;	//1:64Ƶ
	//sys_divs = 0x70;	//1:128Ƶ
	sys_scks = 0x00;	//HRCʱԴ
	//sys_scks = 0x01;	//LRCʱԴ
	//sys_scks = 0x02;	//HOSCʱԴ
	//sys_scks = 0x03;	//EXTCLK(ⲿʱ)
	
	OSCC1 = sys_divs | sys_scks;

	while(CHG){}	//жʱת־
	if((SST0 != 0) || (SST1 != 0))	//((SST0 != 0) || (SST1 != 1))
	{
		return;
	}
	CLKOEN = 0;		//ʱʹ
	//CLKO_FSEL = 0;	//ѡϵͳʱ128Ƶʱ
	OSCWP = 0x5A;
}

/***********************************************************
:	It_vectors_init
  :	Ϊģʽ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void It_vectors_init(void)
{
	INTVEN0 = 1;		//жģʽ
	INTV0   = 0;
	INTV1   = 0;		//ȼ00
	IGP2 = 1;
	//INTP    = 0x04;		//T10ȼ
	//GIEL    = 1;		//ȼжʹ	
}

/**********************************************
Init_Timer
  ʱʼ
ֵ
ֵ
ֵ
**********************************************/
void  Init_Timer(void)
{
    T10		= 6;			//趨ʱֵʱ4ms    250*16=4000us
	T10C	= 0x0E;			//T10Ϊʱģʽ128Ƶ  8M/128= 62.5k  16us/Clock    
    T10IE	= 1;			//ʹT10ʱж
    T10EN	= 1;			//T10ENʱ
}

/**********************************************
Init_Ports
  ˿ڳʼ
ֵ
ֵ
ֵ
**********************************************/
void  Init_Ports(void)
{
	PET5  = 0;
	PES5  = 0;
	PE5 = 1;
}

/**********************************************
 main
  
ֵ
ֵ
ֵ
**********************************************/
void main()
{
	Ram_clear();
	Close_wdt();
	Init_hrc();
	It_vectors_init();
	Init_Timer();
	Init_Ports();

	GIE = 1;
	while(1){};
}

/**********************************************
isr
  жϴ
ֵ
ֵ
ֵ
**********************************************/
void isr(void) interrupt_high 0x10
{
	static char i = 0;

	if(T10IF && T10IE)
	{
		T10IF = 0;
		T10	= 6;			//趨ʱֵʱ4ms    250*16=4000us
		i++;

		if (i > 250)
		{
			if (PE5 == 0)
			{
				PE5 = 1;
			} 
			else
			{
				PE5 = 0;
			}

			i = 0;
		}
	}
}
