/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  uart
*  :  AE Team
*  :  V1.0
*  :  2022/03/31
*  :  UARTͨ
          1.ʹES7P2131оƬUARTģTXţҪⲿ.
		  2.ʵUARTչܣȷ40123Žմӻ͵45678 ɸTX_numֵʵⳤȵݷ
		  9600bps8λݸʽ
*  ע:  ES7P2131
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>
#define  Mastermode   1   //1 ģʽ  0/ע͵ ģʽ

#define  TX_num       4   //鳤
#define  RX_num_max  16   //󳤶
unsigned char RX_num;     //յĵһֽ

unsigned char RecData,SendData,i;
#if  Mastermode 
 char Tx_arr[TX_num+1]={TX_num,0,1,2,3 };  //Master
#else 
 char Tx_arr[TX_num+1]={TX_num,5,6,7,8 };  //Slave
#endif

unsigned char Rx_arr[RX_num_max];
unsigned char Tx_counter;
unsigned char Rx_counter;
unsigned int  Cycle_cnt;

/*********************************************************
:	void ram_clear(void) 
  :	ͨRAMӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void ram_clear(void)
{
    GIE = 0;
    for(IAAH = 0; IAAH < 0x04; IAAH++)
    {
		for(IAAL = 0; IAAL < 0xFF; IAAL++)
		{
		   IAD = 0x00;
		}
		IAD = 0x00;
		//clr_wdt(); 
    }
}

/*********************************************************
:	void Int_vectors_init(void)
  :	ͨжģʽӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void Int_vectors_init(void)
{
	INTVEN0 = 1;		// жģʽ
	INTV0   = 0;
	INTV1   = 0;		// ȼ00
	INTP    = 0x20;		// IG5ȼ
	GIEL    = 1;
}

/*********************************************************
:	void isr_uart_handler(void) interrupt_high 0x001C
  :	жϷ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void isr_uart_handler(void) interrupt_high 0x001C
{
	if(TX0IE && TX0IF)		     // жϼ
    {			 
		if(Tx_counter < TX_num)
		{
			Tx_counter++;
			TX0B = Tx_arr[Tx_counter];
		}
		else					 // Send over
		{
			                     // Tx_counter = 0;
			while(TRMT0 == 0);   // ȴ
			TX0EN = 0;			 // رUARTʹ
			TX0IE = 0;	         // رUARTж

			RecData = RX0B;      // ־
			RX0EN = 1;			 // UARTʹܣҪ
			RX0IE = 1;	         // ʹUARTж
			Rx_counter = 0;
			Cycle_cnt = 1;       // Start count			
		}        
    }
    else if(RX0IE && RX0IF)		 // ģʽͬʱշ
    {		
        RecData = RX0B;          // ȡֽ
		//if((Rx_counter==0)&&(RecData ==4))				// յĵһֽ Ϊݳ
		if((Rx_counter == 0)&&(RecData < RX_num_max))       // յĵһֽ Ϊݳ Care  RecData < RX_num_max
		{                     			
		   RX_num             = RecData;		  
		   Rx_arr[Rx_counter] = RecData;
		   Rx_counter++;			
		}
		else if(Rx_counter)
		{
           Rx_arr[Rx_counter] = RecData;
		   Rx_counter++;
		}

		if(Rx_counter > RX_num)    //  
		{				  			                   
            #if  Mastermode 
			RX0EN = 0;			   // رUARTʹ
			RX0IE = 0;	           // رUARTж			
			#else                  // Slave mode

			RX0IE = 0;	           // ֹUARTж
	        RX0EN = 0;			   // ֹUARTʹ
			Cycle_cnt  = 0;
			Rx_counter = 0;
			                       // ӻʼ,ȴ
			__Asm NOP;
			__Asm NOP;
			__Asm NOP;
			__Asm NOP;
			__Asm NOP;
           
			TX0EN = 1;			   // UARTʹ
			TX0B = TX_num;         // ֽڳ
			TX0IE = 1;	           // ʹUARTж
			Tx_counter = 0;
			#endif
		}       
    }
}

/*********************************************************
: void main()
  : 
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void main() 
{
	ram_clear();					// RAMʼ Clear all 	
									   
	Int_vectors_init();				// жģʽ
									   
	Rx_arr[0] = 0;					   
	Rx_arr[1] = 0;					   
	Rx_arr[2] = 0;					   
	Rx_arr[3] = 0;					   
	Rx_arr[4] = 0;					   
	Cycle_cnt = 0;					   
									   
	LPBEN =1;                       // Single Line model	
	BRGH0 = 1;						// ģʽ
	BR0R  = 103;					// 9600bps,=Fosc/(16*(BRR<70> + 1),@16MHz)
	TX0LEN = 0;						// 8λݸʽ
	RX0LEN = 0;
	Tx_counter = 0;
	Rx_counter = 0;

	#if  Mastermode 	
	TX0EN = 1;						// UARTʹ
	TX0B  = TX_num;                 // ֽڳȣTX0ENǰTX0B
	TX0IE = 1;	             		// ʹUARTж
	RX0IE = 0;	             	    // ֹUARTж
	RX0EN = 0;					    // ֹUARTʹ
	#else                           // Slave mode
	RX0EN = 1;					    // UARTʹ	
	RX0IE = 1;	             	    // ʹUARTж
	#endif

    GIE = 1;                		// ȫж
    while(1)
	{
		__Asm CWDT;		
		#if  Mastermode 
		if( Cycle_cnt )
		#else 		
		if( Rx_counter )  
		#endif
		{      
			Cycle_cnt++;
			if(Cycle_cnt > 60000)
			{ //ճʱ 			 
				Cycle_cnt = 0;
				__Asm RST;			  			
			}
		}				
	}
}


