/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  double precision pwm
*  :  AE Team
*  :  V1.0
*  :  2021/12/08
*  :  T20˫PWM
          1.ʹоƬ˫PWMģʽPA5˿ڼPA6˿ʵΪ100us~50usռձȷֱΪ25%50%ķڷĴεݼ50us
            ٽװأռձȲ䣬Դη
          2.оƬʹ16MHzϵͳʱӣӦT20ʱʱԴΪ1/16MHzT20ԤƵã1:1T20ڼĴT20Pʼֵ㹫ʽӦΪ
            PWM100us = T20P 1/16MHz 1ԤƵȣT20PֵPERIOD = 16000x0640
            PWM50us = T20PR 1/16MHz 1ԤƵȣT20RֵDUTY21 = 8000x0320PA5˿ڵΪ
            PWMռձ50% = T20R / T20P
*  ע:  ES7P2131
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>

#define PERIOD 1600
#define DUTY21 800
#define DUTY20 400

unsigned int N_Period;
unsigned int N_Duty20;
unsigned int N_Duty21;

/*********************************************************
:	void RAMClear(void) 
  :	ͨRAMӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void ram_clear(void)
{
    GIE = 0;
    for(IAAH = 0; IAAH < 0x04; IAAH++)
    {
		for(IAAL = 0; IAAL < 0xFF; IAAL++)
		{
		   IAD = 0x00;
		}
		IAD = 0x00;
		//clr_wdt(); 
    }
}

/*********************************************************
: void isr(void) interrupt
  : жϷ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void isr(void) interrupt
{
    if(T20PIE &&T20PIF) 
    {                                   //T20ж
        T20PIF = 0;
        if(N_Period >= 1000)
        {
            N_Period -= 200;
            N_Duty20 -= 50;
            N_Duty21 -= 100;   
            
            T20PH = N_Period>>8;
            T20PL = N_Period;            //PWM
            
            T20R1H = N_Duty21 >> 8;
            T20R1L = N_Duty21;           //PWM
            
            T20R0H = N_Duty20 >> 8;
            T20R0L = N_Duty20;           //PWM
        }
        else
        {
            N_Period = PERIOD;
            N_Duty20 = DUTY20;
            N_Duty21 = DUTY21;
            
            T20PH = N_Period>>8;
            T20PL = N_Period;            //PWM
            
            T20R1H = N_Duty21 >> 8;
            T20R1L = N_Duty21;           //PWM
            
            T20R0H = N_Duty20 >> 8;
            T20R0L = N_Duty20;           //PWM
        }
    }
}

/*********************************************************
:	void main(void) 
  :	
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void main() 
{
	// RAMʼ
	ram_clear();

	PAS  = 0;
	PAT5 = 0;					//PA5---PWM200 Ϊ	
	PAT6 = 0;					//PA6---PWM201 Ϊ
	PA5  = 0;
	PA6  = 0;

    N_Period = PERIOD;
    N_Duty20 = DUTY20;
	N_Duty21 = DUTY21;

	T20CL = 0xC1;				// T20˫PWMģʽЧ
	T2nOC = 0x03;				// PWM200,PWM201ʹ

	T20CM = 0;					//T20ԤƵƵ
    T20PH = N_Period >> 8;
    T20PL = N_Period;           //

    T20R1H = N_Duty21 >> 8;
    T20R1L = N_Duty21;          //þ
    T20R0H = N_Duty20 >> 8;    
    T20R0L = N_Duty20;          //þ

    T20CH = 0x80;		        //ʹT20
    T20PIE = 1; 		        //ʹT20ж
    GIE = 1;		            //ʹȫж 
	while (1)
	{	
		__Asm CWDT;	
	}
}
