/*********************************************************
*Copyright (C), 2020, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	int.c
*  :	AE Team
*  :	V1.0
*  :	2021/12/09
*  :	жϴӳ
*  ע:    ESD-TKT-7P2131-Button 
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "main.h"

uchar Timer_counter;         //Timer counter        
uchar Timer_10ms;

#if TK_UARToutput_function == ON

uchar Cnt_Mask;
uchar g_com;				//
uchar g_length;				//ݳ
uchar g_rp;					//ָ
uchar g_tp;					//ָ
uchar g_checksum;			//У
uchar Tx_timer;
uchar UploadSampByte[(TK_NUM*2) + 5];		//ֽ
//uchar UploadRawByte[(TK_NUM*2)+5];		//˲ֽ
//uchar UploadBaseByte[(TK_NUM*2)+5];		//ֽ
uchar UploadBuf[(TK_NUM*2) + 5];	        //ͻ

#endif

/*********************************************************
:	void Timer_T10_init(void)
  :	T10ʱʼ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void Timer_T10_init(void)
{                       
    T10		= 6;			//趨ʱֵʱ125us
	T10C	= 0x09;			//T10Ϊʱģʽ,ؼʹԤƵ4Ƶ  8M/4= 2M  0.5us/Clock    
    T10IE	= 1;			//ʹT10ʱж
    T10EN	= 1;			//T10ENʱ
}

/*********************************************************
:	void isr_T10_handler(void)
  : T10жϴ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void isr_T10_handler(void) interrupt_low 0x0010
{
	if(T10IE && T10IF)		//125us Timer
    {					    //붨ʱж
        T10IF = 0;		    //жϱ־
        T10 = T10 + 6;	    //سֵϽжʱ  T10 + 6;
		
		if(Opr_state & 0x8000)
		{
			if(TKIF)//check if scan complete 
			{
				TKIF = 0;
				
				PC0  = 0;		   // Cxŵ
				PCT0 = 0;          // Output0
		  		 
				if(TKOVIF||TKERRIF||SCANOVIF)                    //TKOV  TKERR SCANOV  Error
				{
					TK_value_get = 0;										  										  			  
				}
				else 
				{
					Timer_counter = 0;              //Clear Measure time	for tk module
					TK_value_get  = 1;              //Set a flag for TK_value  update
				}
				TKINTF &= 0xF0;                     // Clear Flag by software    0 to 1 to TKIF

				#if Auto_Jitter_software_range < 17	// For EMI down 9db
				uchar Random_8;

				Random_8 = TK_jitter_Value % Auto_Jitter_software_range;
				Random_8 += 1;
				TKSFJT0 = Random_8;     // TKf =Hosc /(TKSFJT0 +TKSFJT1+2)
	            TKSFJT1 = Random_8;				  
				#else
				//if(Lock_averageconter > 2)
				//{
					//TKCTL2 = 0x20;  // 4M TKCTL2 = 0x30;  // 2M
				//}
				//else
				//{
					//TKCTL2 = 0x20;  // 4M TKCTL2 = 0x30;  // 2M //TKCTL2 = 0x20;  // 4M
				//}
				TKCTL2_ram &= 0xF0;           // Clear Low 4 bits
				TKCTL2_ram |= (TKCTL2 &0x0F); // Keep  TKCTL2 low 4 bits
				TKCTL2      = TKCTL2_ram;     // 
				#endif
				
				//#if Auto_Jitter_hradware == ON

				//#endif

				if(TK_value_get == 0)
				{
					PCT0 = 1;				//When scan the PC0 must set input
					if(g_wakeup_flag != 2)
					{
						TKGO = 1;
					}
				}
			}
			else if(TK_value_get == 2)
			{
				PCT0 = 1;				//When scan the PC0 must set input
				if(g_wakeup_flag != 2)
				{
					TKGO = 1;	
					TK_value_get = 0;				
				}			
			}			
		}
		Timer_10ms++;
    }
}

#if TK_UARToutput_function == ON
/*********************************************************
:	void isr_uartx_handler(void)
  : UARTжϴ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void isr_uartx_handler(void) interrupt_high 0x001C
{
	uchar i;
	TKValueStru * ptr;   
	if(RX0IE && RX0IF)			//UARTж	
	{  
		g_com = RX0B;			//UARTݼĴͬʱӲRXIF־  
		UploadBuf[0] = 0x68;
		UploadBuf[1] = 0x68;
		//UploadBuf[2] = g_com;
		g_rp = 0;			 //ָ0
		Cnt_Mask = 0;
		g_checksum = 0;		 //У0
		if(g_tp == 0)        //Not in busy send state
		{
			if(g_com == COMMOND1)
			{
				UploadBuf[2] = g_com;
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2];	//Уͣۼֵ
#if TK_Lowpowermode == ON
				if(g_wakeup_flag == 0)
				{
					while(Cnt_Mask < (TK_NUM*2))
					{
						if(((long)0x00000001 << (Cnt_Mask/2)))
						{
							UploadBuf[g_rp + 4] = 0;					
							g_checksum += UploadBuf[g_rp + 4];	//Уͣۼֵ
							g_rp++;
							Cnt_Mask++;
						}
						else
						{
							Cnt_Mask++;
						}
					}
				}
				else
#endif
				{
					while(Cnt_Mask < (TK_NUM*2))
					{
						if(((long)0x00000001 << (Cnt_Mask/2)))
						{
							UploadBuf[g_rp + 4] = UploadSampByte[Cnt_Mask];					
							g_checksum += UploadBuf[g_rp + 4];	//Уͣۼֵ
							g_rp++;
							Cnt_Mask++;
						}
						else
						{
							Cnt_Mask++;
						}
					}
				}

				g_length = g_rp;
				UploadBuf[3] = g_rp;
				g_checksum += UploadBuf[3];
				UploadBuf[g_rp + 4] = g_checksum;
				TX0B = UploadBuf[0];	//дͻ
				g_tp = 1;
				TX0IE = 1;				//ʹTXж 
			}
			else if(g_com == COMMOND2)
			{
				UploadBuf[2] = g_com;
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] ;	//Уͣۼֵ
#if TK_Lowpowermode == ON					
				if(g_wakeup_flag == 0)
				{
					for(i = 0;i < TK_NUM; i++)
					{
						UploadBuf[4+(i*2)] = (uchar)(TK_md2value_origin[i]>>8);
						g_checksum += UploadBuf[g_rp+4];	//Уͣۼֵ
						g_rp ++;
						UploadBuf[4+(i*2) + 1] = (uchar)(TK_md2value_origin[i]);
						g_checksum += UploadBuf[g_rp+4];	//Уͣۼֵ
						g_rp ++;
					}
				}
				else
#endif
				{
					for(i = 0; i < TK_NUM; i++)
					{
						ptr = &TK_Value_Arr[i];
						UploadBuf[4 + (i*2)] = (uchar)(ptr->tk_value_filter>>8);
						g_checksum += UploadBuf[g_rp + 4];	//Уͣۼֵ
						g_rp++;
						UploadBuf[4 + (i*2) + 1] = (uchar)(ptr->tk_value_filter);
						g_checksum += UploadBuf[g_rp + 4];	//Уͣۼֵ
						g_rp++;
					}
				}

				g_length = g_rp;
				UploadBuf[3] = g_rp;
				g_checksum += UploadBuf[3];
				UploadBuf[g_rp + 4] = g_checksum;
				TX0B = UploadBuf[0];	//дͻ
				g_tp = 1;
				TX0IE = 1;				//ʹTXж 
			}
			else if(g_com == COMMOND3)
			{				
				UploadBuf[2] = g_com;
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] ;	//Уͣۼֵ
					
#if TK_Lowpowermode == ON
				if(g_wakeup_flag == 0)
				{
					for(i = 0; i < TK_NUM; i++)
					{
						UploadBuf[4+(i*2)] = (uchar)(TK_md2average_backup[i]>>8);
						g_checksum += UploadBuf[g_rp+4];	//Уͣۼֵ
						g_rp ++;
						UploadBuf[4+(i*2) +1] = (uchar)(TK_md2average_backup[i]);
						g_checksum += UploadBuf[g_rp+4];	//Уͣۼֵ
						g_rp ++;
					}					
				}
				else
#endif
				{
					for(i = 0; i < TK_NUM; i++)
					{
						ptr = &TK_Value_Arr[i];
						UploadBuf[4 + (i*2)] = (uchar)(ptr->tk_value_average>>8);
						g_checksum += UploadBuf[g_rp + 4];	//Уͣۼֵ
						g_rp++;
						UploadBuf[4 + (i*2) + 1] = (uchar)(ptr->tk_value_average);
						g_checksum += UploadBuf[g_rp + 4];	//Уͣۼֵ
						g_rp++;
					}
				}

				g_length = g_rp;
				UploadBuf[3] = g_rp;
				g_checksum += UploadBuf[3];
				UploadBuf[g_rp + 4] = g_checksum;
				TX0B = UploadBuf[0];	//дͻ
				g_tp = 1;
				TX0IE = 1;				//ʹTXж 
#if TK_Lowpowermode == ON
				if(uart_send_flag)
				{
					uart_send_flag++;					
				}
#endif
			}
			else if(g_com == COMMOND4)  //ֵ
			{
				UploadBuf[2] = g_com;
				g_length = 9;
				UploadBuf[3] = 9;

				UploadBuf[4] = (uchar)(Opr_state);	     //Mode
				#if  TK_Singlepress == ON  
				UploadBuf[5] = (uchar)(TK_state_single>>16);    //ֵH
				UploadBuf[6] = (uchar)(TK_state_single>>8);	 //ֵM
				UploadBuf[7] = (uchar)(TK_state_single);		 //ֵL
				#else
				UploadBuf[5] = (uchar)(TK_state>>16);    //ֵH
				UploadBuf[6] = (uchar)(TK_state>>8);	 //ֵM
				UploadBuf[7] = (uchar)(TK_state);		 //ֵL
				#endif

				#if  TK_Slider_Function == ON  
				UploadBuf[8] = (uchar)(TK_slider_value>>8);    //Byte H
				UploadBuf[9] = (uchar)(TK_slider_value);       //Byte L
				#elif TK_JITTER_DEBUG == ON
				UploadBuf[8] = (uchar)(TK_jitter_Value>>8);    //Byte H
				UploadBuf[9] = (uchar)(TK_jitter_Value);       //Byte L
				#else
				UploadBuf[8] = 0;		//Byte H
				UploadBuf[9] = 0;       //Byte L				
				#endif

				#if  TK_Wheel_Function == ON  
				UploadBuf[10] = (uchar)(TK_wheel_value>>8);    //Byte H
				UploadBuf[11] = (uchar)(TK_wheel_value);       //Byte L
				#else
				UploadBuf[10] = 0; // TK_APcnt1;                    //AP תͳ 
				UploadBuf[11] = 0; // TK_APcnt0;
				#endif

				#if  TK_Matrix_Function == ON  
				UploadBuf[12] = TK_Matrix_value ;               //Byte 			
				#else			
				UploadBuf[12] = 0; // TKCTL6 &0x3F;                   //Byte TKCTL6 &0x3F ʱĽ
				#endif
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] + UploadBuf[3] + UploadBuf[4] + UploadBuf[5];	//Уͣۼֵ
				g_checksum += UploadBuf[6] + UploadBuf[7] + UploadBuf[8] + UploadBuf[9] + UploadBuf[10] + UploadBuf[11]+ UploadBuf[12];	//Уͣۼֵ
				UploadBuf[13] = g_checksum;
				TX0B = UploadBuf[0];	//дͻ
				g_tp = 1;
				TX0IE = 1;				//ʹTXж 
			}
			else if(g_com == COMMOND0)  //ͨ
			{
				UploadBuf[2] = g_com;
				g_length     = 1;
				UploadBuf[3] = 1;
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] + UploadBuf[3];	    //Уͣۼֵ				
				UploadBuf[4] = TK_NUM;
				g_checksum += UploadBuf[4];	                                                //Уͣۼֵ
				g_rp++;								
				UploadBuf[g_rp + 4] = g_checksum;
				TX0B = UploadBuf[0];	    //дͻ
				g_tp = 1;
				TX0IE = 1;				//ʹTXж 
			}
			else
			{
				//temp = ((g_com & 0xF0) >> 4 ) -6;
				//ChannelMask &= ~(0x0000000F << (temp*4));
				//ChannelMask |= ((g_com & 0x0F) << (temp*4));
				//g_length     = 0;
				//UploadBuf[3] = 0;
				//g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] + UploadBuf[3];	    //Уͣۼֵ	
				//g_rp ++;								
				//UploadBuf[4] = g_checksum;
				//TX0B = UploadBuf[0];	    //дͻ
				//g_tp =1;
				//TX0IE = 1;				//ʹTXж 
			}
		}					
		else
		{
			if(Tx_timer == 0)
			{
				Tx_timer = 1;
			}
		}
	}	

	if(TX0IE && TX0IF)				//UARTж  
	{	
		if(g_tp < g_length + 5)
		{
			TX0B = UploadBuf[g_tp];	//дͻ
			g_tp++; 
		}
		else
		{
			g_tp = 0;				//ָ0
			TX0IE = 0;				//ֹTXж 	
			Tx_timer = 0;             //Clear counter
			g_length = 0;
#if TK_Lowpowermode == ON
			if(uart_send_flag > 2)
			{
				uart_send_flag = 4;
			}
#endif
		}
	}
}
#endif

