/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  uart.c
*  :  AE Team
*  :  V1.00	iDesigner(v4.2.3.182) + HRCC(v1.2.0.122)
*  :  2022/03/23
*  :  Bootloaderʾ
		  PA0ģBootPIN
          PE7TX
		  PE6RX
		  ʣ9600  λ8λ  ֹͣλ1λ  У飺У λǰ
		  ʾοӦñʼǡAN102_Ӧñʼ_BootISPλ7PϵMCU Bootloader롶AN112_UserManual_ES-UART-BOOT
*  ע:  ES7P2124оƬ
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>
#include "uart.h"
#include "systick.h"
#include "isp_proc.h"
#include "macrodef.h"

/***************************************************************
start_tx
  : UART
ֵ͵ֽ
ֵ
ֵ 
***************************************************************/
void start_tx(u8 len)
{	
	g_isp_data.tx_cnt = 0;
 	g_isp_data.tx_len = len; 
	TX0B = g_isp_data.tx_buf[0];
	while(1)
	{
		g_isp_data.tx_cnt++;
		if(g_isp_data.tx_cnt > g_isp_data.tx_len)    //ɣһ
		{
			while(!TRMT0);
			g_isp_data.triger = 1;      //״̬һ
			g_isp_data.rx_cnt = 0;
			break;
		}
		else
		{
			while(!TRMT0);
			TX0B = g_isp_data.tx_buf[g_isp_data.tx_cnt];
		}
	}
}
/***************************************************************
UartReceive
  : UART
ֵ
ֵ
ֵ 
***************************************************************/
void UartReceive(void)
{
	volatile u8   buf8;

	while(1)				//ûнյֱ˳
	{	
		if(RX0IF)
		{
			buf8 = RX0B;
			g_boot_timer = Boot_OVERTIME_2;   
			if(g_isp_data.syn)  //ͬɹ
			{
				if((buf8 == SYN) && (g_isp_data.step == WAIT_REV_INS))
				{						
					g_isp_data.tx_buf[0] = ACK;
					start_tx(0);
					g_isp_data.triger = 0;
					break;			
				}
				else
				{					
					if(g_isp_data.step == WAIT_REV_INS)
					{	
						g_isp_data.rx_len = 1;
						g_isp_data.rx_cnt = 0;	
						g_isp_data.step = IN_REV_INS;  //ڽָ		
					}
					g_isp_data.rx_buf[g_isp_data.rx_cnt] = buf8;
					g_isp_data.rx_cnt++;
					if(g_isp_data.rx_cnt == 2 && g_isp_data.step == WAIT_REV_PARA1 && g_isp_data.cmd == EX_ERASE)
					{
						g_isp_data.rx_len = (g_isp_data.rx_buf[1] + 2) * 2;
					}
					if(g_isp_data.rx_cnt == 1 && g_isp_data.step == WAIT_REV_PARA2 && g_isp_data.cmd == WRITE_M)
					{
						g_isp_data.rx_len = g_isp_data.rx_buf[0] + 2;
					}
					if(g_isp_data.rx_cnt > g_isp_data.rx_len)    //ɣһ
					{
						g_isp_data.triger = 1;  //״̬һ
						break;
					}
					
				}
			}
			else if(buf8 == SYN)  //յͬɹ
			{
				g_isp_data.tx_buf[0] = ACK;
				g_isp_data.syn = 1;  //ͬ			
				g_isp_data.step = WAIT_REV_INS;
				g_isp_data.triger = 0;
				start_tx(0);
				break;	
			}
		}
		else
		{
			break;
		}
	}
}