/*********************************************************
*Copyright (C), 2020, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	tkm_config.h
*  :	AE Team 
*  :	V1.3
*  :	2023/11/10
*  :	ͷļ
*  ע:    ESD-TKT-7P2124-Spring 
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#ifndef   __TKM_CONFIG_H__
#define   __TKM_CONFIG_H__

/**********************************************************************************************************************************/
#define  TK_NUM						5			// ذ1--20

#define  TK_Channel_Sel				0x0000011E	// ʵӦ ͨʹܼĴ TKSELL TKSELM  TKSELH

#define  TK_Channel0				TK1		    // ֻǰ TK_NUMЧ
#define  TK_Channel1				TK2
#define  TK_Channel2				TK8
#define  TK_Channel3				TK4
#define  TK_Channel4				TK3
#define  TK_Channel5				TK16
#define  TK_Channel6				TK18
#define  TK_Channel7				TK19
#define  TK_Channel8				TK11
#define  TK_Channel9				TK12
#define  TK_Channel10				TK13
#define  TK_Channel11				TK14
#define  TK_Channel12				TK15
#define  TK_Channel13				TK16
#define  TK_Channel14				TK17
#define  TK_Channel15				TK18
#define  TK_Channel16				TK19
#define  TK_Channel17				TK19
#define  TK_Channel18				TK19
#define  TK_Channel19				TK19

//#define  TK_Threshold				80		
#define  TK_Threshold_Channel0		80			// Ӿ 30--3000  ָӰ Dltֵһ
#define  TK_Threshold_Channel1		80			//
#define  TK_Threshold_Channel2		80			//
#define  TK_Threshold_Channel3		80			//
#define  TK_Threshold_Channel4		80			//
#define  TK_Threshold_Channel5		80			//
#define  TK_Threshold_Channel6		80			//
#define  TK_Threshold_Channel7		80			//
#define  TK_Threshold_Channel8		100			//
#define  TK_Threshold_Channel9		100			//
#define  TK_Threshold_Channel10		100			//
#define  TK_Threshold_Channel11		100			//
#define  TK_Threshold_Channel12		100			//
#define  TK_Threshold_Channel13		100			//
#define  TK_Threshold_Channel14		100			//
#define  TK_Threshold_Channel15		100			//
#define  TK_Threshold_Channel16		100			//
#define  TK_Threshold_Channel17		100			//
#define  TK_Threshold_Channel18		100			//
#define  TK_Threshold_Channel19		100			//

// ﵽ趨űΪ»ͷţ->ȶ С->
#define  TK_Debounce_press				10				// µĴ趨
#define  TK_Debounce_release			5				// 뿪Ĵ趨

// ÿβۼӲȥСֵÿͨЧΪ(TK_Samples_perscan - 2)->ȶ С->
#define  TK_Samples_perscan				3				// ۼ趨3--16

// ݵСֵ֮ΪֵֵӦϵͳȶ->ܸţа󴥷 С->ֻܸСţаٶ۷
#define  Jitter_level1_Threshold		(TK_Threshold_Channel0*1.5*TK_NUM)		// ֵ趨ֵʱ
#define  Jitter_level2_Threshold		(TK_Threshold_Channel0*2*TK_NUM)		// ֵ趨ֵʱΰ

// Jitter_levelʹʱݶJitter_level1Ƶ
#define  Auto_Jitter_software			ON		        // ON/OFF Ƶ

#define  TK_Lowpowermode				OFF			// ON/OFF ͹Ӧÿ  
#define  TK_Wdttimer_sleepsetting		WDT_128ms   // mS  16/32/64/128/256/512/1024/2046 ˯ʱ
#define  TK_Mode0_nokeytoswitch_time	10*100		// 10S  0--65535  ģʽ˯ģʽлʱ

#define	 TK_NUM_LP						TK_NUM			// ذ1--20

#define  TK_Channel_Sel_LP				TK_Channel_Sel  // ʵӦ ͨʹܼĴ TKSELL TKSELM  TKSELH

#define  TK_Channel0_LP					TK_Channel0		// ֻǰTK_NUM_LPЧ
#define  TK_Channel1_LP					TK_Channel1
#define  TK_Channel2_LP					TK_Channel2
#define  TK_Channel3_LP					TK_Channel3
#define  TK_Channel4_LP					TK_Channel4
#define  TK_Channel5_LP					TK_Channel5
#define  TK_Channel6_LP					TK_Channel6
#define  TK_Channel7_LP					TK_Channel7
#define  TK_Channel8_LP					TK_Channel8
#define  TK_Channel9_LP					TK_Channel9
#define  TK_Channel10_LP				TK_Channel10
#define  TK_Channel11_LP				TK_Channel11
#define  TK_Channel12_LP				TK_Channel12
#define  TK_Channel13_LP				TK_Channel13
#define  TK_Channel14_LP				TK_Channel14
#define  TK_Channel15_LP				TK_Channel15
#define  TK_Channel16_LP				TK_Channel16
#define  TK_Channel17_LP				TK_Channel17
#define  TK_Channel18_LP				TK_Channel18
#define  TK_Channel19_LP				TK_Channel19

#define  TK_Threshold_Channel0_LP		TK_Threshold_Channel0			// Ӿ 30--3000  ָӰ Dltֵһ
#define  TK_Threshold_Channel1_LP		TK_Threshold_Channel1			//
#define  TK_Threshold_Channel2_LP		TK_Threshold_Channel2			//
#define  TK_Threshold_Channel3_LP		TK_Threshold_Channel3			//
#define  TK_Threshold_Channel4_LP		TK_Threshold_Channel4			//
#define  TK_Threshold_Channel5_LP		TK_Threshold_Channel5			//
#define  TK_Threshold_Channel6_LP		TK_Threshold_Channel6			//
#define  TK_Threshold_Channel7_LP		TK_Threshold_Channel7			//
#define  TK_Threshold_Channel8_LP		TK_Threshold_Channel8			//
#define  TK_Threshold_Channel9_LP		TK_Threshold_Channel9			//
#define  TK_Threshold_Channel10_LP		TK_Threshold_Channel10			//
#define  TK_Threshold_Channel11_LP		TK_Threshold_Channel11			//
#define  TK_Threshold_Channel12_LP		TK_Threshold_Channel12			//
#define  TK_Threshold_Channel13_LP		TK_Threshold_Channel13			//
#define  TK_Threshold_Channel14_LP		TK_Threshold_Channel14			//
#define  TK_Threshold_Channel15_LP		TK_Threshold_Channel15			//
#define  TK_Threshold_Channel16_LP		TK_Threshold_Channel16			//
#define  TK_Threshold_Channel17_LP		TK_Threshold_Channel17			//
#define  TK_Threshold_Channel18_LP		TK_Threshold_Channel18			//
#define  TK_Threshold_Channel19_LP		TK_Threshold_Channel19			//

#define  PINT_WAKE_function			OFF
#define  KINT_WAKE_function			OFF
//
#define  TK_UARToutput_function			OFF				// ON/ OFF
#define  TK_UARToutput_port				PE67			// PB45/ PA01
#define  TK_UARToutput_Baudrate			9600			// 115200  57600 38400 19200 .......9600
#define  TK_UARToutput_Databit			8				// 4,5,6,7,8
#define  TK_UARToutput_Stopbit			1				// 1,2,3(1.5)
#define  TK_UARToutput_Verifybit		No				// No Even Odd

//TK_IOoutput_function  Setting        
#define  TK_IOoutput_NUM			5			// 0 1--16 ˳Ӧ TK_Channelx ״̬
//IO
#define  TK_IOoutput_port0			PB4			// IO bit
#define  TK_IOoutput_port1			PE6
#define  TK_IOoutput_port2			PE7
#define  TK_IOoutput_port3			PE4
#define  TK_IOoutput_port4			PE3

#define  TK_IOoutput_port5			PE7
#define  TK_IOoutput_port6			PE7
#define  TK_IOoutput_port7			PB3
#define  TK_IOoutput_port8			PB2
#define  TK_IOoutput_port9			PB1
#define  TK_IOoutput_port10			PB4
#define  TK_IOoutput_port11			PB5
#define  TK_IOoutput_port12			PE3
#define  TK_IOoutput_port13			PE4
#define  TK_IOoutput_port14			PE5
#define  TK_IOoutput_port15			PE6
#define  TK_IOoutput_port16			PE7
#define  TK_IOoutput_port17			PB3
#define  TK_IOoutput_port18			PB2
#define  TK_IOoutput_port19			PB1
//IO λ
#define  TK_IOoutput_trise0			PBT4		// IO  TRISE bit
#define  TK_IOoutput_trise1			PET6
#define  TK_IOoutput_trise2			PET7
#define  TK_IOoutput_trise3			PET4
#define  TK_IOoutput_trise4			PET3
#define  TK_IOoutput_trise5			PET7

#define  TK_IOoutput_trise6			PET7
#define  TK_IOoutput_trise7			PBT3
#define  TK_IOoutput_trise8			PBT2
#define  TK_IOoutput_trise9			PBT1
#define  TK_IOoutput_trise10		PBT4
#define  TK_IOoutput_trise11		PBT5
#define  TK_IOoutput_trise12		PET3
#define  TK_IOoutput_trise13		PET4
#define  TK_IOoutput_trise14		PET5
#define  TK_IOoutput_trise15		PET6
#define  TK_IOoutput_trise16		PET7
#define  TK_IOoutput_trise17		PBT3
#define  TK_IOoutput_trise18		PBT2
#define  TK_IOoutput_trise19		PBT1

#define	 PE67							0
#define  PE0B7							1

#define  PA_PORT			0x00
#define  PB_PORT			0x80
#define  PE_PORT			0x20

#define  TK0				(PA_PORT+0)	   // PA0
#define  TK1				(PA_PORT+1)	   // PA1
#define  TK2				(PA_PORT+2)	   // PA2
#define  TK3				(PA_PORT+3)	   // PA3
#define  TK4				(PA_PORT+4)	   // PA4
#define  TK5				(PA_PORT+5)	   // PA5
#define  TK6				(PA_PORT+6)	   // PA6
#define  TK7				(PA_PORT+7)	   // PA7
#define  TK8				(PB_PORT+8)	   // PB6
#define  TK9				(PB_PORT+9)	   // PB7
#define  TK10				(PE_PORT+10)   // PE0
#define  TK11				(PE_PORT+11)   // PE1
#define  TK12				(PE_PORT+12)   // PE2
#define  TK13				(PE_PORT+13)   // PE3
#define  TK14				(PE_PORT+14)   // PE4
#define  TK15				(PE_PORT+15)   // PE5
#define  TK16				(PE_PORT+16)   // PE6
#define  TK17				(PE_PORT+17)   // PE7
#define  TK18				(PB_PORT+18)   // PB4
#define  TK19				(PB_PORT+19)   // PB5

#define	 SLAVE_ADDR			0x4E		//ӻַ
#define  COMMOND4			0x50		//4ֵ
#define  COMMOND0			0x51		//0ͨ
#define  COMMOND1			0x5A		//1
#define  COMMOND2			0x5B		//2˲
#define  COMMOND3			0x5C		//3
#define	 COMMOND5			0x5D		//5оƬλ

//TK_advance
#define  TK_reg_TKCTL0					0x38
#define  TK_reg_TKCTL1					0x02        // 1/2 ռձ
#define  TK_reg_TKCTL2					0x20        // 0x20 4M  
#define  TK_reg_TKCTL2_bk1				0x30        // 0x30 2M 
#define  TK_reg_TKCTL2_bk2				0x80        // 0x80 5.3M
#define  TK_reg_TKCTL3					0x00        
#define  TK_reg_TKCTL4					0x32        // ߹ģʽ 128 CLOCK ŵʱ
#define  TK_reg_TKCTL5					0x3D        // CP 2.6V 
#define  TK_reg_TKCTL6					0x80
#define  TK_reg_TKINTE					0x0F
#define  TK_reg_TKFJCTL					0x01        //  <15 ƵЧӲƵ ʱ

typedef struct
{
	uchar tk_press_table;     // For press    counter
	uchar tk_release_table;   // For release  counter
	uint tk_value_origin;     // Origin      data
	uint tk_value_filter;     // Filter data
	uint tk_value_average;    // Base line   data
	uint tk_timeout_counter;  // For TK press time counter	
	uint tk_D_value;          // Base line   data - Filter data
  //#if  Max_Minvalueoff_filter == ON  
    uint tk_value_max;     // Origin Max     data
    uint tk_value_min;     // Origin Min     data
  //#endif

} TKValueStru;

extern TKValueStru TK_Value_Arr[TK_NUM];
extern TKValueStru curr_tk_value;

extern ulong TK_state;
extern ulong TK_state_bk;
extern ulong TK_state_single;
extern uint  TK_Base_percounter;
extern uchar TK_chnum;
extern uchar Tkscan_sampcounter;    //Sample counter  1--TK_Samples_perscan
extern uchar TK_value_get;    
extern uchar Lock_averageconter;
extern uchar Lock_averageconter2;
extern uchar TKCTL2_ram;
extern uint  TK_jitter_Value;
extern uchar BaseLineInitCount;
#if TK_Lowpowermode == ON
extern uchar TK_Sleep_cnt;
extern uint TK_md2average_backup[TK_NUM];
extern uint TK_mode1_nopresstimer;
#if TK_UARToutput_function == ON
extern uint TK_md2value_origin[TK_NUM];
extern uchar uart_send_flag;
#endif
#endif

extern const unsigned long pow_ulong[];
extern const uchar DF_TK_Singlepress;
extern void Singlekeyprocess(void);
extern uchar Mult_inhibition(uint Dlt_data ,uchar Inhibition_data);

extern void TK_init(void);
extern void TK_service(void);
extern void Timer_check(void);
extern void Update_TKdata(void);
extern void TKStandby(void);
extern void TK_IO_output(void);
extern void Force_average(uchar num_th);
extern uint DataFilter(uint Origin,uint Befilter);
extern uint DataJitter(void);
extern void Software_jitterprocess( uint Jitter_ram,uint Jitter_level1_ram,uint Jitter_level2_ram,uchar TK_reg_TKCTL2_ram,uchar TK_reg_TKCTL2_ram1,uchar TK_reg_TKCTL2_ram2 );
/************************************************************************************************************************************/
#endif


