/*********************************************************
*Copyright (C), 2020, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	tkm_config.c
*  :	AE Team
*  :	V1.3
*  :	2023/11/10
*  :	TKӳ
*  ע:    ESD-TKT-7P2131-Button 
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "main.h"

/*ulong pow_ulong(uchar i)
{
	return ((ulong)1<<i);
}*/

const unsigned long pow_ulong[] = {1<<0, 1<<1, 1<<2, 1<<3, 1<<4, 1<<5, 1<<6, 1<<7, 1<<8, 1<<9, 1<<10, 1<<11, 1<<12, 1<<13, 1<<14, 1<<15, 1<<16, 1<<17, 1<<18, 1<<19};

const uchar REG_PORT[20] = {0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x40, 0x80, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x10, 0x20};

const uchar Channel_table[TK_NUM]=     // Channel table for use as tk channel
{
	#if TK_NUM > 0
	TK_Channel0
	#endif
	#if TK_NUM > 1
	,TK_Channel1
	#endif
	#if TK_NUM > 2
	,TK_Channel2
	#endif
	#if TK_NUM > 3
	,TK_Channel3
	#endif
	#if TK_NUM > 4
	,TK_Channel4
	#endif
	#if TK_NUM > 5
	,TK_Channel5
	#endif
	#if TK_NUM > 6
	,TK_Channel6
	#endif
	#if TK_NUM > 7
	,TK_Channel7
	#endif
	#if TK_NUM > 8
	,TK_Channel8
	#endif
	#if TK_NUM > 9
	,TK_Channel9
	#endif
	#if TK_NUM > 10
	,TK_Channel10
	#endif
	#if TK_NUM > 11
	,TK_Channel11
	#endif
	#if TK_NUM > 12
	,TK_Channel12
	#endif
	#if TK_NUM > 13
	,TK_Channel13
	#endif
	#if TK_NUM > 14
	,TK_Channel14
	#endif
	#if TK_NUM > 15
	,TK_Channel15
	#endif
	#if TK_NUM > 16
	,TK_Channel16
	#endif
	#if TK_NUM > 17
	,TK_Channel17
	#endif
	#if TK_NUM > 18
	,TK_Channel18
	#endif
	#if TK_NUM > 19
	,TK_Channel19
	#endif
};

const uchar Channel_table_LP[TK_NUM_LP]=     // Channel table for use as tk channel
{
	#if TK_NUM_LP > 0
	TK_Channel0_LP
	#endif
	#if TK_NUM_LP > 1
	,TK_Channel1_LP
	#endif
	#if TK_NUM_LP > 2
	,TK_Channel2_LP
	#endif
	#if TK_NUM_LP > 3
	,TK_Channel3_LP
	#endif
	#if TK_NUM_LP > 4
	,TK_Channel4_LP
	#endif
	#if TK_NUM_LP > 5
	,TK_Channel5_LP
	#endif
	#if TK_NUM_LP > 6
	,TK_Channel6_LP
	#endif
	#if TK_NUM_LP > 7
	,TK_Channel7_LP
	#endif
	#if TK_NUM_LP > 8
	,TK_Channel8_LP
	#endif
	#if TK_NUM_LP > 9
	,TK_Channel9_LP
	#endif
	#if TK_NUM_LP > 10
	,TK_Channel10_LP
	#endif
	#if TK_NUM_LP > 11
	,TK_Channel11_LP
	#endif
	#if TK_NUM_LP > 12
	,TK_Channel12_LP
	#endif
	#if TK_NUM_LP > 13
	,TK_Channel13_LP
	#endif
	#if TK_NUM_LP > 14
	,TK_Channel14_LP
	#endif
	#if TK_NUM_LP > 15
	,TK_Channel15_LP
	#endif
	#if TK_NUM_LP > 16
	,TK_Channel16_LP
	#endif
	#if TK_NUM_LP > 17
	,TK_Channel17_LP
	#endif
	#if TK_NUM_LP > 18
	,TK_Channel18_LP
	#endif
	#if TK_NUM_LP > 19
	,TK_Channel19_LP
	#endif
};

const uint Threshold_table[TK_NUM]=    // Threshold table for tk channel
{
	#if TK_NUM > 0
	TK_Threshold_Channel0
	#endif
	#if TK_NUM > 1
	,TK_Threshold_Channel1
	#endif
	#if TK_NUM > 2
	,TK_Threshold_Channel2
	#endif
	#if TK_NUM > 3
	,TK_Threshold_Channel3
	#endif
	#if TK_NUM > 4
	,TK_Threshold_Channel4
	#endif
	#if TK_NUM > 5
	,TK_Threshold_Channel5
	#endif
	#if TK_NUM > 6
	,TK_Threshold_Channel6
	#endif
	#if TK_NUM > 7
	,TK_Threshold_Channel7
	#endif
	#if TK_NUM > 8
	,TK_Threshold_Channel8
	#endif
	#if TK_NUM > 9
	,TK_Threshold_Channel9
	#endif
	#if TK_NUM > 10
	,TK_Threshold_Channel10
	#endif
	#if TK_NUM > 11
	,TK_Threshold_Channel11
	#endif
	#if TK_NUM > 12
	,TK_Threshold_Channel12
	#endif
	#if TK_NUM > 13
	,TK_Threshold_Channel13
	#endif
	#if TK_NUM > 14
	,TK_Threshold_Channel14
	#endif
	#if TK_NUM > 15
	,TK_Threshold_Channel15
	#endif
	#if TK_NUM > 16
	,TK_Threshold_Channel16
	#endif
	#if TK_NUM > 17
	,TK_Threshold_Channel17
	#endif
	#if TK_NUM > 18
	,TK_Threshold_Channel18
	#endif
	#if TK_NUM > 19
	,TK_Threshold_Channel19
	#endif
};

const uint Threshold_table_9_10[TK_NUM]= //Threshold * 9 / 10
{
	#if TK_NUM > 0
	TK_Threshold_Channel0 * 9 / 10
	#endif
	#if TK_NUM > 1
	,TK_Threshold_Channel1 * 9 / 10
	#endif
	#if TK_NUM > 2
	,TK_Threshold_Channel2 * 9 / 10
	#endif
	#if TK_NUM > 3
	,TK_Threshold_Channel3 * 9 / 10
	#endif
	#if TK_NUM > 4
	,TK_Threshold_Channel4 * 9 / 10
	#endif
	#if TK_NUM > 5
	,TK_Threshold_Channel5 * 9 / 10
	#endif
	#if TK_NUM > 6
	,TK_Threshold_Channel6 * 9 / 10
	#endif
	#if TK_NUM > 7
	,TK_Threshold_Channel7 * 9 / 10
	#endif
	#if TK_NUM > 8
	,TK_Threshold_Channel8 * 9 / 10
	#endif
	#if TK_NUM > 9
	,TK_Threshold_Channel9 * 9 / 10
	#endif
	#if TK_NUM > 10
	,TK_Threshold_Channel10 * 9 / 10
	#endif
	#if TK_NUM > 11
	,TK_Threshold_Channel11 * 9 / 10
	#endif
	#if TK_NUM > 12
	,TK_Threshold_Channel12 * 9 / 10
	#endif
	#if TK_NUM > 13
	,TK_Threshold_Channel13 * 9 / 10
	#endif
	#if TK_NUM > 14
	,TK_Threshold_Channel14 * 9 / 10
	#endif
	#if TK_NUM > 15
	,TK_Threshold_Channel15 * 9 / 10
	#endif
	#if TK_NUM > 16
	,TK_Threshold_Channel16 * 9 / 10
	#endif
	#if TK_NUM > 17
	,TK_Threshold_Channel17 * 9 / 10
	#endif
	#if TK_NUM > 18
	,TK_Threshold_Channel18 * 9 / 10
	#endif
	#if TK_NUM > 19
	,TK_Threshold_Channel19 * 9 / 10
	#endif
};

const uint Threshold_table_LP[TK_NUM_LP]=    // Threshold table for tk channel
{
	#if TK_NUM_LP > 0
	TK_Threshold_Channel0_LP
	#endif
	#if TK_NUM_LP > 1
	,TK_Threshold_Channel1_LP
	#endif
	#if TK_NUM_LP > 2
	,TK_Threshold_Channel2_LP
	#endif
	#if TK_NUM_LP > 3
	,TK_Threshold_Channel3_LP
	#endif
	#if TK_NUM_LP > 4
	,TK_Threshold_Channel4_LP
	#endif
	#if TK_NUM_LP > 5
	,TK_Threshold_Channel5_LP
	#endif
	#if TK_NUM_LP > 6
	,TK_Threshold_Channel6_LP
	#endif
	#if TK_NUM_LP > 7
	,TK_Threshold_Channel7_LP
	#endif
	#if TK_NUM_LP > 8
	,TK_Threshold_Channel8_LP
	#endif
	#if TK_NUM_LP > 9
	,TK_Threshold_Channel9_LP
	#endif
	#if TK_NUM_LP > 10
	,TK_Threshold_Channel10_LP
	#endif
	#if TK_NUM_LP > 11
	,TK_Threshold_Channel11_LP
	#endif
	#if TK_NUM_LP > 12
	,TK_Threshold_Channel12_LP
	#endif
	#if TK_NUM_LP > 13
	,TK_Threshold_Channel13_LP
	#endif
	#if TK_NUM_LP > 14
	,TK_Threshold_Channel14_LP
	#endif
	#if TK_NUM_LP > 15
	,TK_Threshold_Channel15_LP
	#endif
	#if TK_NUM_LP > 16
	,TK_Threshold_Channel16_LP
	#endif
	#if TK_NUM_LP > 17
	,TK_Threshold_Channel17_LP
	#endif
	#if TK_NUM_LP > 18
	,TK_Threshold_Channel18_LP
	#endif
	#if TK_NUM_LP > 19
	,TK_Threshold_Channel19_LP
	#endif
};

const uchar DF_TK_Singlepress = 0;//TK_Singlepress;
uint  Opr_state;
/*
Bit15  Scan Enable bit   1 on 0 off
Bit14  Tempdata is full  1 full 0 receive
Bit13  Jillter sample enable bit  1 Enable     0  Disable
Bit12  Once scan complete bit     1 complete   0  busy
Bit11  Slider bit    1 Slider was be touch 0 not be touch
Bit10  Wheel  bit    1 Wheel  was be touch 0 not be touch
Bit9   Matrix Row bit     1   was be touch 0 not be touch
Bit8   Matrix Column bit  1   was be touch 0 not be touch
Bit7   Mode bit  0  Mode default  1  Mode2  
Bit6   Mode switch start switching  if 1 else 0       
Bit5   Powersave flag setting if 1 else 0
Bit4
Bit3
Bit2
Bit1
Bit0
*/

TKValueStru TK_Value_Arr[TK_NUM];
TKValueStru curr_tk_value;

#if TK_Lowpowermode == ON
uchar TK_Sleep_cnt;
uint TK_md2average_backup[TK_NUM];
uint TK_mode1_nopresstimer;
#if TK_UARToutput_function == ON
uint TK_md2value_origin[TK_NUM];
uchar uart_send_flag;
#endif
#endif

uchar g_wakeup_flag; //0: ˯ģʽ 1: ģʽ
uchar Lock_averageconter;
uchar Lock_averageconter2;
uchar TKCTL2_ram;
ulong TK_state;
ulong TK_state_bk;
ulong TK_state_single;
uint  TK_Base_percounter;
uint  TK_jitter_Value;
uint  TK_value;              //ɨʱȡֵ
uchar TK_value_get;          //ɨɱ־
uchar TK_chnum;              //TKͨ
uchar Tkscan_sampcounter;    //
uchar BaseLineInitFlag;		 //߳ʼɱ־
uchar BaseLineInitCount;	 //߳ʼ
uchar BaseLineInitChannelNum;//߳ʼͨ
uchar BaseLineInitStart;
/*********************************************************
:	void proc_curr_tk_value(uchar idx, uchar direct)
  :	ṹݴ
ֵ: uchar idx, uchar direct
ֵ: TK_Value_Arr[]
ֵ:  
**********************************************************/
void proc_curr_tk_value(uchar idx, uchar direct)
{
	char * ptr_d = (char *)&curr_tk_value;
	char * ptr_s = (char *)&TK_Value_Arr[idx];
	char * tmp = ptr_d;

	if (direct == 1)	//0:   1:д
	{
		ptr_d = ptr_s;
		ptr_s = tmp;
	}
	unsigned char i = 0;

	for (i=0; i < sizeof(TKValueStru); i++)
	{
		*ptr_d = *ptr_s;
		ptr_d++;
		ptr_s++;
	}

	//memcpy(ptr_d, ptr_s, sizeof(TKValueStru));
}

/*********************************************************
:	void TK_init(void)
  :	TKʼ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void TK_init(void)
{
	uchar i,j,k;

	TKEN = 0;					//For TK module reset
	TKGO = 0;					//Ӧģر
	TKIF = 0;

	TKCTL6 = TK_reg_TKCTL6;		//TKVREF_EN ʹܺһʱȶ
	TKCTL0 = TK_reg_TKCTL0;
	TKCTL1 = TK_reg_TKCTL1;
	TKCTL2 = TK_reg_TKCTL2;
	TKCTL2_ram =TK_reg_TKCTL2;
	TKCTL3 = TK_reg_TKCTL3;             
	TKCTL4 = TK_reg_TKCTL4;              
	TKCTL5 = TK_reg_TKCTL5;
	              
	//#if TK_Guardsensor_output == ON 
	//PAT0 = 0;
	//TKDCS = 1;	//ͬƵͬ
	//TKDCE = 1;	//PA0
	//#endif	 

	//#if Auto_Jitter_hradware == ON

	//#endif	
	
	TKINTE = TK_reg_TKINTE;
	TKINTF &= 0xF0;     //жϱ־			

	TKMODL = 0xFF;		//÷ŴϵĴ24λ
	TKMODM = 0xFF;
	TKMODH = 0x0F;
	TKMODU = 0x00;	    //Ŵϵ4λ=0
				
	TKCHSL = (uchar)(TK_Channel_Sel & 0xFF);
	TKCHSM = (uchar)((TK_Channel_Sel>>8) & 0xFF);
	TKCHSH = (uchar)((TK_Channel_Sel>>16) & 0xFF);

	//TKFJCTL = TK_reg_TKFJCTL;
	//TKSFJT0 = 1;  //4M init 
	//TKSFJT1 = 1;  

	TKIE = 1; 
	PCT0 = 1;
	TK_value_get = 0;
	TK_chnum = TK_NUM;		
	Opr_state = 0x8000;

	for(i = 0;i < TK_chnum;i++)
	{
		j = (Channel_table[i] & 0x1F);
		j = REG_PORT[j];
		k = (Channel_table[i] & 0xE0);
		if(k == PA_PORT)             // PA
		{
			PAT |= j;//
			PAS |= j;//ģ
		}
		else if(k == PB_PORT)        // PB
		{
			PBT |= j;
			PBS |= j;
		}
		else if(k == PE_PORT)        // PE
		{
			PET |= j;
			PES |= j;
		}
	}

	#if TK_Lowpowermode == ON
	TK_mode1_nopresstimer = 0;
	Opr_state |= 0x0020;
	clr_wdt();               // TK 幷ظ幷 õWDTʱ ֹطֱ幷
	#endif
}

/*********************************************************
:	void TK_service(void)
  :	TK״̬
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void TK_service(void)
{
	uchar i,j;
	uchar Lock_average = 0;			
	uint Jitter = 0;
	ulong pow_2 = 0;
	uint curr_Threshold = 0;
	uint curr_Threshold_9_10 = 0;
	if(Opr_state & 0x4000)						//Ѳɣ
	{          	
		clr_wdt();// 幷ʹô˺ õWDTʱ ֹطֱ幷 
		//#if  Max_Minvalueoff_filter == ON     //ĬȥСֵ														  
		Jitter = DataJitter();
		TK_jitter_Value = Jitter;               //ݶֵ
		//#endif

		Software_jitterprocess(Jitter,Jitter_level1_Threshold,Jitter_level2_Threshold,TK_reg_TKCTL2,TK_reg_TKCTL2_bk1,TK_reg_TKCTL2_bk2);

		BaseLineInitChannelNum = 0;

        TK_Base_percounter++;					//ÿһۼһ   
		for(i = 0;i < TK_chnum;i++)
	    { 
			pow_2 = pow_ulong[i];
			curr_Threshold = Threshold_table[i];
			curr_Threshold_9_10 = Threshold_table_9_10[i];
	     		
			proc_curr_tk_value(i,0);

			#if (TK_UARToutput_function == ON)||(TK_IICoutput_function == ON)			//´						      
				UploadSampByte[2*i]     = (uchar)(curr_tk_value.tk_value_origin>>8);
				UploadSampByte[(2*i)+1] = (uchar)(curr_tk_value.tk_value_origin);
				//UploadRawByte[2*i]      = (uchar)(ptr->tk_value_filter>>8);
				//UploadRawByte[(2*i)+1]  = (uchar)(ptr->tk_value_filter);
				//UploadBaseByte[2*i]     = (uchar)(ptr->tk_value_average>>8);
				//UploadBaseByte[(2*i)+1] = (uchar)(ptr->tk_value_average);		 
			#endif	 

			if(BaseLineInitFlag)//߳ʼ
			{
				curr_tk_value.tk_value_filter = DataFilter(curr_tk_value.tk_value_origin,curr_tk_value.tk_value_filter);//˲		
			}
			else if(TK_jitter_Value < TK_Threshold_Channel0*TK_chnum)//Զʱ» 20
			{
				if(BaseLineInitStart == 0)
				{
					if(curr_tk_value.tk_value_average)//ϵжθ´
					{
						curr_tk_value.tk_value_filter = DataFilter(curr_tk_value.tk_value_origin,curr_tk_value.tk_value_filter);
						curr_tk_value.tk_value_average = DataFilter(curr_tk_value.tk_value_average,curr_tk_value.tk_value_filter);				
					}
					else//ʼ
					{
						curr_tk_value.tk_value_filter  = curr_tk_value.tk_value_origin;
						curr_tk_value.tk_value_average = curr_tk_value.tk_value_origin;			
					}
					BaseLineInitChannelNum++;
					curr_tk_value.tk_value_origin = 0;
					proc_curr_tk_value(i,1);
					continue;
				}
				else
				{
					for(j = 0;j < TK_chnum;j++)
					{
						TK_Value_Arr[j].tk_value_origin = 0;
					}
					break;				
				}
			}
			else//ϵݶ쳣߳ʼ
			{
				for(j = 0;j < TK_chnum;j++)
				{
					TK_Value_Arr[j].tk_value_origin = 0;
				}
				break;
			}

			if(curr_tk_value.tk_value_origin > (curr_tk_value.tk_value_average + curr_Threshold))      		 
			{		   		                                                  
				Lock_average = 1;        //		 
			}	 	
			else 
			{
				Lock_average = 0;
				if((curr_tk_value.tk_press_table < TK_Debounce_press)||(TK_jitter_Value > Jitter_level2_Threshold))   //Ч򶶶ϴ
				{
					curr_tk_value.tk_press_table = 0;						//  press counter											
				}

				//#if Jitter_Function == ON
				//if(ptr->tk_press_table && (ptr->tk_press_table < TK_Debounce_press))       // No key press  but at press conter state  (TK_state &((ulong)1<<i))==0
				//{
					//TK_Jitter_tolerance[i]++;
					//if(TK_Jitter_tolerance[i] > Jitter_tolerance)
					//{
						//ptr->tk_press_table = 0;												// Clear press counter
						//TK_Jitter_tolerance[i] = 0;
					//}
				//}
				//else 
				//{
					//TK_Jitter_tolerance[i] = 0;
				//}
				//#endif
			}
		/********************************************** Check Trigger *****************************************/	
			uchar Mucheck = 1;
			//#if TK_Mult_inhibition > 0
			//if(Mult_inhibition((curr_tk_value.tk_value_filter - curr_tk_value.tk_value_average),TK_Mult_inhibition))
			//{
				//Mucheck = 1;
			//}
			//else
			//{
				//Mucheck = 0;
				//Lock_average = 0;
				//if(TK_state & pow_2)
				//{
					//curr_tk_value.tk_release_table = TK_Debounce_release;
					//TK_state &= ~pow_2;
					//TK_Base_percounter = 0;
					//Customer_Keystatejustrelease();
					//if(curr_tk_value.tk_timeout_counter != 0)
					//{
						//curr_tk_value.tk_timeout_counter = 0;
					//}
					//curr_tk_value.tk_D_value = 0;
				//}
			//}
			//#endif
			if((curr_tk_value.tk_value_filter > (curr_tk_value.tk_value_average + curr_Threshold)) && Mucheck )			
			{
				curr_tk_value.tk_press_table++;	
				#if TK_Lowpowermode == ON
				if(g_wakeup_flag == 2)
				{
					g_wakeup_flag = 1;//߽׶
					TKEN = 1;
					TKGO = 1;
				}		   
				#endif
				curr_tk_value.tk_release_table = 0;			   
				if(curr_tk_value.tk_press_table > TK_Debounce_press) 			
				{
					if(TK_jitter_Value < Jitter_level2_Threshold)
					{
						curr_tk_value.tk_press_table = TK_Debounce_press;			 
						TK_state |= pow_2;                                               //ð״̬	
						Customer_Keystatejustpress();
						if(curr_tk_value.tk_timeout_counter == 0)
						{
							curr_tk_value.tk_timeout_counter = 1;
						}			  			 	
						//#if TK_Singlepress == ON                                       //Dltֵڵģʽ
						//curr_tk_value.tk_D_value = curr_tk_value.tk_value_filter - curr_tk_value.tk_value_average ;
						//#endif	
					}
					else
					{
						curr_tk_value.tk_press_table = 0;                                         //  press counter 
					}
				}
			}
			else
			{
				curr_tk_value.tk_press_table = 0;                             //  press counter	
				//#if Jitter_Function == ON
				//TK_Jitter_tolerance[i] = 0;
				//#endif		   
				if(TK_state & pow_2)                        //尴°״̬
				{			     
					//if(curr_tk_value.tk_value_filter < (curr_tk_value.tk_value_average + (curr_Threshold*9)/10))
					if(curr_tk_value.tk_value_filter < (curr_tk_value.tk_value_average + curr_Threshold_9_10))
					{				
						curr_tk_value.tk_release_table++;					
						if(curr_tk_value.tk_release_table > TK_Debounce_release)     //ͷż
						{
							curr_tk_value.tk_release_table = TK_Debounce_release;
							TK_state &= ~pow_2;//~((ulong)1<<i);                     //״̬
							TK_Base_percounter = 0;
							Customer_Keystatejustrelease();					   
							if(curr_tk_value.tk_timeout_counter != 0)
							{
								curr_tk_value.tk_timeout_counter = 0;
							}       // Close timer counter
							//#if TK_Singlepress == ON                                 //Dltֵڵģʽ
							//curr_tk_value.tk_D_value = 0;
							//#endif
						}				    
					}
					else
					{
						curr_tk_value.tk_release_table = 0;                          // release counter
					}
				}
				else if((Lock_average == 0)&&(TK_Base_percounter > (1000/TK_NUM))&&(Lock_averageconter == 0))
				{				 				  					    
					curr_tk_value.tk_value_average = DataFilter(curr_tk_value.tk_value_filter,curr_tk_value.tk_value_average);//»			 	                       				 				 	                       
				}
			}
		/********************************************** Check Trigger *****************************************/
			curr_tk_value.tk_value_origin = 0;                                       //ԭʼ 	 
			proc_curr_tk_value(i,1);
		}
		 
		if(BaseLineInitChannelNum >= TK_chnum)
		{
			BaseLineInitStart = 1;		
		}

		if(TK_Base_percounter > ((1000/TK_NUM) + 0))
		{
			TK_Base_percounter = 0;	//߸¼
		}
		Opr_state &=~0x4000;        //尴״̬

		//#if TK_Singlepress == ON    //ǿ  
		//if(TK_state)
		//{                                     
			//Singlekeyprocess();
		//}
		//else
		//{
			//TK_state_single = 0;
		//}
		//#endif
	  
		#if TK_Lowpowermode == ON
		if(TK_state)
		{
			TK_mode1_nopresstimer = 0;
		}
		#endif

		Opr_state |= 0x8000;	//ɨ
		#if TK_Lowpowermode == ON
		if(g_wakeup_flag == 2)
		{
			g_wakeup_flag = 0;  //߽׶
		}
		#endif				 			  		  
	}	    
}


/*********************************************************
:	void Timer_check(void)
  :	TKʱ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void Timer_check(void)
{
	uchar i;
	if(Timer_10ms > 9) //125 *80 10ms
	{
		Timer_10ms = 0;

		if(BaseLineInitStart == 1)
		{
			BaseLineInitStart = 0;
			BaseLineInitCount++;
			if (BaseLineInitCount >= 30) 
			{
				BaseLineInitFlag = 1;//߳ʼ
			}		
		}

		#if TK_Lowpowermode == ON
			TK_mode1_nopresstimer++;       //߼ʱ
		#endif

		#if TK_UARToutput_function == ON
			if(Tx_timer)
			{
				Tx_timer++;
				if(Tx_timer > 125)		   //ͳʱλ
				{
					Tx_timer = 0;
					g_tp = 0;
				}
			}
		#endif

        Timer_counter++;
		if(Timer_counter > 5)              //ɨ賬50msδʱɨ
		{		
			Timer_counter = 0;
			if(Opr_state & 0x8000)
			{
				TK_init();
				TKEN = 1;
				for(i = 0; i < 20; i++)		//ѹȶҪʱ
				{
					nop();
					clr_wdt();    // 忴Ź
				}
				TKGO = 1;
			}                
		}
		 
		if(Lock_averageconter > 2)
		{
			Lock_averageconter--;
			if(Lock_averageconter < 5)
			{
				Lock_averageconter = 0;
			}		 
		}

		if(Lock_averageconter2 > 2)
		{
			Lock_averageconter2--;
			if(Lock_averageconter2 < 5)
			{
				Lock_averageconter2 = 0;
			}		 
		}    
		    
		//for(i = 0;i < TK_chnum;i++)                   //ʱ
		//{
			//proc_curr_tk_value(i,0);
			//if(curr_tk_value.tk_timeout_counter == 0) //ͨްлһͨ
		    //{
				//continue;
		    //}
			//else
		    //{
				//curr_tk_value.tk_timeout_counter = curr_tk_value.tk_timeout_counter + 1;		     
				//if(curr_tk_value.tk_timeout_counter >= 12000) //³趨ʱ䣨120SǿƸ»
				//{
					//curr_tk_value.tk_timeout_counter = 0;											   
					//Force_average(i);							   
				//}				
		    //}
			//proc_curr_tk_value(i,1);
		//}
	}
}

/*********************************************************
:	void Update_TKdata(void)
  :	TKݴ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void Update_TKdata(void)//¸ͨ
{
	uint *ptr2;
	uchar i;
	if(Opr_state & 0x8000)
	{
		if(TK_value_get == 1)
		{
			for(i = 0;i < TK_NUM;i++)
			{
				proc_curr_tk_value(i,0);
				ptr2 = 0x60C0;
				ptr2 += (Channel_table[i] & 0x1F);
				TK_value = *ptr2; //*((uint*)ptr2);

				curr_tk_value.tk_value_origin += TK_value;
				//#if  Max_Minvalueoff_filter ==ON  
					if(Tkscan_sampcounter == 0)
					{
						curr_tk_value.tk_value_max = TK_value;
						curr_tk_value.tk_value_min = TK_value;
					}
					else if(TK_value > curr_tk_value.tk_value_max)
					{
						curr_tk_value.tk_value_max = TK_value;
					}		  
					else if(TK_value < curr_tk_value.tk_value_min)
					{
						curr_tk_value.tk_value_min = TK_value;
					}
				//#endif
				proc_curr_tk_value(i,1);
			}
			
			Tkscan_sampcounter++;
			if(Tkscan_sampcounter >= TK_Samples_perscan)
			{
				#if TK_Lowpowermode == ON
				if(TK_mode1_nopresstimer > TK_Mode0_nokeytoswitch_time)
				{
					g_wakeup_flag = 2;	//׼߽׶2							
					TK_mode1_nopresstimer = 0;							 
				}			
				#endif
			
				Tkscan_sampcounter = 0;
				Opr_state |= 0x4000;	//ݸɴһ		 
			}

			if(Opr_state & 0x4000)
			{
				Opr_state &= ~0x8000;   //ͣɨȴݴ		
			} 

			PCT0 = 1;
			if(g_wakeup_flag != 2)
			{
				TKGO = 1;	
				TK_value_get = 0;				
			}					                           
		}
	}
}

#if TK_Lowpowermode == ON
/*********************************************************
:	void TKStandby(void)
  :	TK˯ɨӳ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void TKStandby(void)
{
	uchar *ptr;
	uchar i,j;
	uint cmp1 = 0;
	uint cmp2 = 0;
	union {
		uchar dl[2];
		uint  data;
	}tkdata;

	WDT_set(TK_Wdttimer_sleepsetting);
	__Asm IDLE;
	TKVREF_EN = 1;	 //idleӲ Ѻλ
	__Asm CWDT;
	WDT_set(WDT_Close);

#if PINT_WAKE_function == ON
	if((PIF0 == 1) && (PIE0 == 1))
	{
		PIF0 = 0;
		//TKVREF_EN ȶҪʱ ܻѹʱ豣֤200us
		for(i = 0; i < 150; i++)	//160us@16M
		{
			nop();
			clr_wdt();    //忴Ź
		}
		Customer_wakeupfromsleepmode_init();
		return;
	}
#endif

#if KINT_WAKE_function == ON
	if((KIF == 1) && (KIE == 1))
	{
		PB6 = 1;
		KIF = 0;
		//TKVREF_EN ȶҪʱ ܻѹʱ豣֤200us
		for(i = 0; i < 150; i++)	//160us@16M
		{
			nop();
			clr_wdt();    //忴Ź
		}
		Customer_wakeupfromsleepmode_init();
		return;
	}
#endif

	while(TKIF == 0);//check if scan complete 
	TKIF = 0;
	PC0  = 0;		 // Cxŵ
	PCT0 = 0;        // Output0
	TK_value_get = 0;
	if(DONEIF)		
	{
		TK_value_get = 1;
	}
	TKINTF &= 0xF0;         //Clear Flag by software 0 to 1 to TKIF
	PCT0 = 1;				//When scan the PC0 must set input
	//TKVREF_EN ȶҪʱ С8ʱע ܻѹʱ豣֤200us
	for(i = 0; i < 100; i++)	//110us@16M
	{
		nop();
		clr_wdt();    //忴Ź
	}
	if(TK_value_get)
	{
		if(TK_Sleep_cnt < 250)
		{
			for(i = 0;i < TK_NUM_LP;i++)
			{
				ptr = 0x60C0;
				ptr += (Channel_table_LP[i] & 0x1F)<<1;
				tkdata.dl[0] = *ptr;
				tkdata.dl[1] = *(ptr+1);
#if TK_UARToutput_function == ON		
				TK_md2value_origin[i] = tkdata.data;
#endif
				cmp1 = (uint)tkdata.data;
				if(cmp1 != 0)
				{
					cmp2 = (uint)(TK_md2average_backup[i] + Threshold_table_LP[i]);
					if(cmp1 > cmp2)
					{
						if(TK_md2average_backup[i] == 0)
						{
							TK_md2average_backup[i] = cmp1;
							for(j = 0; j < 10; j++)	//TKVREF_EN ȶҪʱ
							{
								nop();
								clr_wdt();
							}
						}
						else
						{
							TK_state |= 1<<i;
							TK_Value_Arr[i].tk_value_filter = TK_Value_Arr[i].tk_value_average + Threshold_table[i] + 10;
							TK_Value_Arr[i].tk_value_origin += Threshold_table[i] + 10;
							TK_Value_Arr[i].tk_press_table = TK_Debounce_press + 2;
							TK_Value_Arr[i].tk_release_table = 0;	
							Customer_wakeupfromsleepmode_init();
							break;
						}
					}
					else
					{
						//if(TK_Sleep_cnt % 10 == 0)
						//{
							if(cmp1 < TK_md2average_backup[i])
							{
								TK_md2average_backup[i]--;
							}
							if(cmp1 > TK_md2average_backup[i])
							{
								//TK_md2average_backup[i]++;
								TK_md2average_backup[i] = cmp1;
							}
						//}
					}
				}
			}
			if(TK_Sleep_cnt == 249)
			{
				TKCHSL = (uchar)(TK_Channel_Sel & 0xFF);
				TKCHSM = (uchar)((TK_Channel_Sel>>8) & 0xFF);
				TKCHSH = (uchar)((TK_Channel_Sel>>16) & 0xFF);	
			}	
#if TK_UARToutput_function == ON						
			CLKG |= 0x02;

			PBT &= ~0x10;//UART_TXΪ
			PBT |= 0x20; //UART_RXΪ

			RX0EN = 1;	//UARTʹ	
			RX0IE = 1;	//ʹUARTж

			TX0EN = 1;	//UARTʹ	
			TX0IE = 0;	//ֹUARTжϣҪʱʹ

			RX0IF = 0;
			TX0IF = 0;

			g_tp = 0;

			GIE  = 1;
	
			uart_send_flag = 1;
#endif
		}
		else
		{
			for(i = 0;i < TK_NUM;i++)
			{
				ptr = 0x60C0;
				ptr += (Channel_table[i] & 0x1F)<<1;
				tkdata.dl[0] = *ptr;
				tkdata.dl[1] = *(ptr+1);
				TK_value	 = tkdata.data;
				//#if  Max_Minvalueoff_filter == ON 
				TK_value *= TK_Samples_perscan - 2;
				//#else
				//TK_value *=TK_Samples_perscan;
				//#endif
				TKValueStru * ptr = &TK_Value_Arr[i];
				ptr->tk_value_filter = DataFilter(TK_value,ptr->tk_value_filter);
				ptr->tk_value_average = DataFilter(ptr->tk_value_filter,ptr->tk_value_average);
			}
			TK_Sleep_cnt = 0;
				
			TKCHSL = (uchar)(TK_Channel_Sel_LP & 0xFF);
			TKCHSM = (uchar)((TK_Channel_Sel_LP>>8) & 0xFF);
			TKCHSH = (uchar)((TK_Channel_Sel_LP>>16) & 0xFF);
		}
		TK_Sleep_cnt++;
	}
	else
	{
		//TKVREF_EN ȶҪʱ С8ʱע ܻѹʱ豣֤200us
		for(i = 0; i < 100; i++)	//110us@16M
		{
			nop();
			clr_wdt();    //忴Ź
		}	
	}
#if TK_UARToutput_function == ON
	if(g_wakeup_flag == 0)
	{
		if(uart_send_flag)
		{
			while(uart_send_flag != 4) 
			clr_wdt();    // 忴Ź
		}
		GIE = 0;        //رжʹ
		TX0EN = 0;		//رUART-TX0
		TX0IE = 0;
		RX0EN = 0;		//رUART-RX0 
		RX0IE = 0;
		PBT = 0x00;	
		CLKG &= ~0x02;
	}
	uart_send_flag = 0;
#endif
}
#endif

#if TK_IOoutput_NUM > 0
/*********************************************************
:	void TK_IO_output(void)
  :	TK״̬IOӳ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void TK_IO_output(void)
{ 
    uchar i = 0;
	ulong TK_state_temp;
	//#if TK_Singlepress == ON
	//TK_state_temp = TK_state_single;
	//#else
	TK_state_temp = TK_state;
	//#endif
	                        //  pow_ulong[i]
	#if TK_IOoutput_NUM > 0
	if(TK_state_temp & ((uint)1<<i)){TK_IOoutput_port0 = LED_On;}else{TK_IOoutput_port0 = LED_Off;}i++;  
	#endif												 							   
	#if TK_IOoutput_NUM > 1								 							   
	if(TK_state_temp & ((uint)1<<i)){TK_IOoutput_port1 = LED_On;}else{TK_IOoutput_port1 = LED_Off;}i++;
	#endif												 							   
	#if TK_IOoutput_NUM > 2								 							   
	if(TK_state_temp & ((uint)1<<i)){TK_IOoutput_port2 = LED_On;}else{TK_IOoutput_port2 = LED_Off;}i++;
	#endif												 							   
	#if TK_IOoutput_NUM > 3								 							   
	if(TK_state_temp & ((uint)1<<i)){TK_IOoutput_port3 = LED_On;}else{TK_IOoutput_port3 = LED_Off;}i++;
	#endif												 							   
	#if TK_IOoutput_NUM > 4								 							   
	if(TK_state_temp & ((uint)1<<i)){TK_IOoutput_port4 = LED_On;}else{TK_IOoutput_port4 = LED_Off;}i++;
	#endif												 							   
	#if TK_IOoutput_NUM > 5								 							   
	if(TK_state_temp & ((uint)1<<i)){TK_IOoutput_port5 = LED_On;}else{TK_IOoutput_port5 = LED_Off;}i++;
	#endif												 							   
	#if TK_IOoutput_NUM > 6								 							   
	if(TK_state_temp & ((uint)1<<i)){TK_IOoutput_port6 = LED_On;}else{TK_IOoutput_port6 = LED_Off;}i++;
	#endif												 							   
	#if TK_IOoutput_NUM > 7								 							   
	if(TK_state_temp & ((uint)1<<i)){TK_IOoutput_port7 = LED_On;}else{TK_IOoutput_port7 = LED_Off;}i++;
	#endif												 							   
	#if TK_IOoutput_NUM > 8								 							   
	if(TK_state_temp & ((uint)1<<i)){TK_IOoutput_port8 = LED_On;}else{TK_IOoutput_port8 = LED_Off;}i++;
	#endif												 							   
	#if TK_IOoutput_NUM > 9								 							   
	if(TK_state_temp & ((uint)1<<i)){TK_IOoutput_port9 = LED_On;}else{TK_IOoutput_port9 = LED_Off;}i++;
	#endif												 
	#if TK_IOoutput_NUM > 10								 
	if(TK_state_temp & ((uint)1<<i)){TK_IOoutput_port10 = LED_On;}else{TK_IOoutput_port10 = LED_Off;}i++;
	#endif												 
	#if TK_IOoutput_NUM > 11								 
	if(TK_state_temp & ((uint)1<<i)){TK_IOoutput_port11 = LED_On;}else{TK_IOoutput_port11 = LED_Off;}i++;
	#endif	 	 
	#if TK_IOoutput_NUM > 12								 							   
	if(TK_state_temp & ((uint)1<<i)){TK_IOoutput_port12 = LED_On;}else{TK_IOoutput_port12 = LED_Off;}i++;
	#endif												 							   
	#if TK_IOoutput_NUM > 13								 							   
	if(TK_state_temp & ((uint)1<<i)){TK_IOoutput_port13 = LED_On;}else{TK_IOoutput_port13 = LED_Off;}i++;
	#endif												 							   
	#if TK_IOoutput_NUM > 14								 							   
	if(TK_state_temp & ((uint)1<<i)){TK_IOoutput_port14 = LED_On;}else{TK_IOoutput_port14 = LED_Off;}i++;
	#endif												 							   
	#if TK_IOoutput_NUM > 15								 							   
	if(TK_state_temp & ((uint)1<<i)){TK_IOoutput_port15 = LED_On;}else{TK_IOoutput_port15 = LED_Off;}i++;
	#endif												 							   
	#if TK_IOoutput_NUM > 16								 							   
	if(TK_state_temp & ((uint)1<<i)){TK_IOoutput_port16 = LED_On;}else{TK_IOoutput_port16 = LED_Off;}i++;
	#endif												 							   
	#if TK_IOoutput_NUM > 17								 							   
	if(TK_state_temp & ((uint)1<<i)){TK_IOoutput_port17 = LED_On;}else{TK_IOoutput_port17 = LED_Off;}i++;
	#endif												 							   
	#if TK_IOoutput_NUM > 18								 							   
	if(TK_state_temp & ((uint)1<<i)){TK_IOoutput_port18 = LED_On;}else{TK_IOoutput_port18 = LED_Off;}i++;
	#endif												 							   
	#if TK_IOoutput_NUM > 19								 							   
	if(TK_state_temp & ((uint)1<<i)){TK_IOoutput_port19 = LED_On;}else{TK_IOoutput_port19 = LED_Off;}i++;
	#endif	
}
#endif
