/*********************************************************
*Copyright (C), 2020, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	main.c
*  :	AE Team 
*  :	V1.3
*  :	2023/11/10
*  :	ʾ
*  ע:    ESD-TKT-7P2131-Button 
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "main.h"

/*********************************************************
:	void main()
  :	
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void main()
{
	MCU_init();
	Delay100ms(1);
	Timer_T10_init();
	Timer_T20_init();
	TK_init();
	Int_vectors_init();
	#if  TK_UARToutput_function == ON
	UART_init();
	#endif
	Beep_On();
	SEG_CON1_0();
	SEG_CON2_0();
    SEG_CON3_0();
    SEG_CON4_0();

	SEGA_1();
	SEGB_1();
	SEGC_1();
	SEGD_1();
	SEGE_1();
	SEGF_1();
	SEGG_1();
	SEGH_1();

	GIE = 1;	
	while(1)
	{
		clr_wdt();
		#if TK_Lowpowermode == ON
		if(g_wakeup_flag == 0)
		{
			TKStandby();	                   // sleep mode								
		}
		else
		#endif	
		{
			TK_service();
			Timer_check();                     // Check if 10ms tick
			Update_TKdata();                   // Update channel data
			//TK_state                         // Check the TK_state parameter to do the application   TK_state bits if press 1 no press 0
			#if TK_IOoutput_NUM > 0
			TK_IO_output();
			#endif 
			#if TK_Lowpowermode == ON
			if(g_wakeup_flag == 0)
			{
				Customer_prepareforsleepmode_init();			
			}
			#endif 
		}
	}
}

/*********************************************************
:	void Delay100ms(uint time)
  :	ʱӳ
ֵ: timeʱλ100ms
ֵ: 
ֵ: 
**********************************************************/
void Delay100ms(uchar time)
{
	uchar i, j, k;
	for(i = 0; i < time; i++)
	{
		for(j = 0; j < 249; j++)			
		{
			for(k = 0; k < 249; k++)
			{
				nop();
				nop();
				nop();
				nop();
				nop();
				clr_wdt();    // 忴Ź
			}
		}
	}
}

#if TK_UARToutput_function == ON
/*********************************************************
:	void UART_init(void)
  :	UARTʼӳ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void UART_init(void)
{
	#if TK_UARToutput_port == PB45
	PBS4 =0;
	PBS5 =0;
	PBT4  = 0;	//UART_TXΪ	
	PBT5  = 1;	//UART_RXΪ
	PBPU5 = 1;
	#elif TK_UARToutput_port == PA01
	PAS0 = 0;
	PAS1 = 0;
	PSFT3 = 1;  //UART ӳPA0 PA1
	PAT1  = 0;	//UART_TXΪ	
	PAT0  = 1;	//UART_RXΪ
	PAPU0 = 1;
	#endif
	#if TK_UARToutput_Databit == 8
	TX0LEN = 0;	//8λݸʽ
	RX0LEN = 0;
	#elif TK_UARToutput_Databit == 9
	TX0LEN = 1;	//9λݸʽ
	RX0LEN = 1;
	#endif
	BRGH0 = 1;	//ģʽ
	#if TK_UARToutput_Baudrate == 115200
	BR0R = 8;	//115200bps=Fosc/(16(BRR<7:0> + 1))@16MHz 
	#elif TK_UARToutput_Baudrate == 57600
	BR0R = 16;	//57600bps=Fosc/(16(BRR<7:0> + 1))@16MHz 	
	#elif TK_UARToutput_Baudrate == 56000
	BR0R = 17;	//56000bps=Fosc/(16(BRR<7:0> + 1))@16MHz  
	#elif TK_UARToutput_Baudrate == 38400
	BR0R = 25;	//38400bps=Fosc/(16(BRR<7:0> + 1))@16MHz  
	#elif TK_UARToutput_Baudrate == 19200
	BR0R = 51;	//19200bps=Fosc/(16(BRR<7:0> + 1))@16MHz 
	#elif TK_UARToutput_Baudrate == 9600
	BR0R = 103;	//9600bps=Fosc/(16(BRR<7:0> + 1))@16MHz 
	#elif TK_UARToutput_Baudrate == 4800
	BR0R = 207;	//4800bps=Fosc/(16(BRR<7:0> + 1))@16MHz 
	#endif
	RX0EN = 1;	//UARTʹ	
	RX0IE = 1;	//ʹUARTж

	TX0EN = 1;	//UARTʹ	
	TX0IE = 0;	//ֹUARTжϣҪʱʹ

	RX0IF = 0;
	TX0IF = 0;
	g_tp = 0;
}
#endif

/*********************************************************
:	void Customer_Keystatejustpress(void)
  : ͨոռ⵽״̬
ֵ: 
ֵ: TK_state
ֵ:  
**********************************************************/
void Customer_Keystatejustpress(void)
{ //TK_state was just freshed  you can use the  parameter as you want
	if(TK_state > TK_state_bk)		//¼·Ӧ
	{
		KeyPressed_Flag = 1;
		TK_state_bk = TK_state;
		Beep_On();
		Presscounter++;
		dispBuf[3] = dispNumTab[(uchar)TK_state & 0x0F];
		dispBuf[2] = dispNumTab[(uchar)(TK_state >> 4) & 0x0F];
		dispBuf[1] = dispNumTab[(uchar)(TK_state >> 8) & 0x0F];
		dispBuf[0] = dispNumTab[Presscounter % 0x10];
	}	
}

/*********************************************************
:	void Customer_Keystatejustrelease(void)
  : ͨոռ⵽ͷ
ֵ: 
ֵ: TK_state
ֵ:  
**********************************************************/
void Customer_Keystatejustrelease(void)
{ 
	if(TK_state < TK_state_bk)
	{
		TK_state_bk = TK_state;
		dispBuf[3] = dispNumTab[(uchar)TK_state & 0x0F];
		dispBuf[2] = dispNumTab[(uchar)(TK_state >> 4) & 0x0F];
		dispBuf[1] = dispNumTab[(uchar)(TK_state >> 8) & 0x0F];
	}
}

#if TK_Lowpowermode == ON
/*********************************************************
:	void Customer_prepareforsleepmode_init(void)
  : ˯ߵĳʼ׼
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void Customer_prepareforsleepmode_init(void)
{
	TK_Sleep_cnt = 0;	

	//رʹģ鼰жʹ
	GIE = 0;        //رжʹ
	T10EN = 0;		//رT10	
	T10IE = 0;
	T20EN = 0;
	T2nOC = 0;
	TKEN = 0;
	TKGO = 0;
	TKCHSL = (uchar)(TK_Channel_Sel_LP & 0xFF);
	TKCHSM = (uchar)((TK_Channel_Sel_LP>>8) & 0xFF);
	TKCHSH = (uchar)((TK_Channel_Sel_LP>>16) & 0xFF);
	TKIE = 0;
	TKDIST0 = 0;	//֤˯ߵһ֡ŵ
	TKDIST1 = 0;
	TKDIST2 = 1;
	EXTEN = 1;
	TX0EN = 0;		//رUART-TX0
	TX0IE = 0;
	RX0EN = 0;		//رUART-RX0 
	RX0IE = 0;

	//ùܽŷ״̬ƽ  
	PAT = 0x00;		
	PBT = 0x00;		
	PCT = 0x01;		// When scan the PC0 must set input
	PET = 0x00;

	PA3 = 0;
	PE3 = 0;
	PB7 = 0;
	PE1 = 0;
	PE2 = 0;
	PA4 = 0;
	PB6 = 0;
	PE0 = 0;

	PB3 = 0;
	PB2 = 0;
	PB1 = 0;
	PB0 = 0;

	PA1 = 0;
	PA2 = 0;
	PA6 = 0;
	PA7 = 0;
	PE7 = 0;
	PE6 = 0;
	PE5 = 0;
	PE4 = 0;

	PA5 = 0;

	PB4 = 0;
	PB5 = 0;

	PC0 = 0;	//Cx
	PC1 = 1;	//MRST

#if PINT_WAKE_function == ON
	PBT7 = 1;	//PB7Ϊ
	PBS7 = 0;	//PB7ڳʼΪֶ˿

	PEG02 = 1;	//˫شPINTж
	PIE0 = 1;	//ʹPINT0ж
#endif

#if KINT_WAKE_function == ON
	PBT6 = 1;	//PB6Ϊ
	PBS6 = 0;	//PB6ڳʼΪֶ˿
	PBPU6 = 1;
	PB6 = 1;

	KMSK0 = 1;	//KIN0벻
	KIF = 0;
	KIE = 1;	//ʹⲿж
#endif

	CLKG &= 0x18;
}

/*********************************************************
:	void Customer_wakeupfromsleepmode_init(void)
  : Ѻĳʼ ָʱ״̬ʼ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void Customer_wakeupfromsleepmode_init(void)
{
	uchar i;

#if PINT_WAKE_function == ON
	PIE0 = 0;	//رPINT0ж
#endif
#if KINT_WAKE_function == ON
	KMSK0 = 0;	//KIN0
	KIF = 0;
	KIE = 0;	//رⲿж
#endif
	CLKG |= 0xEF;
	TKCHSL = (uchar)(TK_Channel_Sel & 0xFF);
	TKCHSM = (uchar)((TK_Channel_Sel>>8) & 0xFF);
	TKCHSH = (uchar)((TK_Channel_Sel>>16) & 0xFF);
	TKCTL4 = TK_reg_TKCTL4;  
	EXTEN = 0;
	TKIE = 0;
	TKIF = 0;
	TKEN = 1;

	Tkscan_sampcounter  = 0;	
	Opr_state			= 0x8000;//Enable scan
	//TK_state 			= 0;
	TK_Base_percounter 	= 0;	
	TK_value_get        = 0;
	Timer_10ms          = 0;
	Lock_averageconter  = 0;	
	Timer_counter = 0;	

	g_wakeup_flag = 1;
	TK_mode1_nopresstimer = 0;
	for(i = 0;i < TK_NUM;i++)
	{
#if TK_UARToutput_function == ON
		TK_md2value_origin[i] = 0;
#endif
		TK_md2average_backup[i] = 0;
	}	

#if  TK_UARToutput_function == ON
	UART_init();
#endif 

	WDT_set(WDT_4080ms);

	T10EN = 1;
	T10IE = 1;
	T10IF = 0;	
	T20EN = 1;

	GIE  = 1;
	TKGO = 1;
}
#endif

/*********************************************************
:	void RAM_Clear(void) 
  :	ͨRAMӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
//ݴ洢ռΪ1024 ֽڣΪ8 洢飨SRAM SECTION 0~7ÿSRAM洢Ϊ128 ֽڣѰַַΧΪ0000H~03FFH
void RAM_clear(void)
{
    GIE = 0;
    for(IAAH = 0; IAAH < 0x04; IAAH++)
    {
		for(IAAL = 0; IAAL < 0xFF; IAAL++)
		{
		   IAD = 0x00;
		}
		IAD = 0x00;
		//clr_wdt(); 
    }
}

/*********************************************************
:	void WDT_Set(void) 
  :	ͨWDTӳ
ֵ: uchar time
ֵ: 
ֵ:  
**********************************************************/
void WDT_set(uchar time)
{
	WDTUL = 0xA5;	//unlock
	WDTC = time;
	WDTC |= 0xC0;
	WDTUL = 0xA0;	//lock
}

/*********************************************************
:	void SysClk_Set(void) 
  :	ͨϵͳʱ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void SysClk_set(void)
{
	volatile uchar sys_divs,sys_scks;
    OSCWP = 0x55;
	HRCEN = 1;
	HRCSEL = 1;		//ѡHRCʱƵΪ16MHz
	while(!HRCON){} //ȴHRC״̬λ

	sys_divs = 0x00;	//1:1Ƶ
	//sys_divs = 0x10;	//1:2Ƶ
	//sys_divs = 0x20;	//1:4Ƶ
	//sys_divs = 0x30;	//1:8Ƶ
	//sys_divs = 0x40;	//1:16Ƶ
	//sys_divs = 0x50;	//1:32Ƶ
	//sys_divs = 0x60;	//1:64Ƶ
	//sys_divs = 0x70;	//1:128Ƶ
	sys_scks = 0x00;	//HRCʱԴ
	//sys_scks = 0x01;	//LRCʱԴ
	//sys_scks = 0x02;	//HOSCʱԴ
	//sys_scks = 0x03;	//EXTCLK(ⲿʱ)
	
	OSCC1 = sys_divs | sys_scks;

	while(CHG){}	//жʱת־
	if((SST0 != 0) || (SST1 != 0))	//((SST0 != 0) || (SST1 != 1))
	{
		while(1);
	}
	CLKOEN = 0;		//ʱʹ
	//CLKO_FSEL = 0;	//ѡϵͳʱ128Ƶʱ
	OSCWP = 0x5A;
}

/*********************************************************
:	void Int_vectors_init(void)
  :	ͨжģʽӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void Int_vectors_init(void)
{
	INTVEN0 = 1;		// жģʽ
	INTV0   = 0;
	INTV1   = 0;		// ȼ00
	INTP    = 0;
#if  TK_UARToutput_function == ON
	INTP    = 0x20;		// RX TX ȼ
#endif
	GIEL    = 1;
}

/*********************************************************
:	void GPIO_Set(void) 
  :	ͨGPIOӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void GPIO_set(void)
{
    PES = 0xFF;		
	PAS = 0xFF;
	PBS = 0xFF;
	PCS = 0xFF;

	//Display init
	PBS = 0x30;
	PES = 0xF0;
	PAS3 = 0;	
	PAS4 = 0;

	PBT =  0x30;
	PET =  0xF0;
	PAT3 = 0;
	PAT4 = 0;
	//Display init

	PCT0 = 1;	// When scan the PC0 must set input
	PCS0 = 1;

	#if TK_IOoutput_NUM > 0
	TK_IOoutput_port0 = LED_Off;
	TK_IOoutput_trise0 = 0;
	#endif
	#if TK_IOoutput_NUM > 1
	TK_IOoutput_port1 = LED_Off;
	TK_IOoutput_trise1 = 0;
	#endif
	#if TK_IOoutput_NUM > 2
	TK_IOoutput_port2 = LED_Off;
	TK_IOoutput_trise2 = 0;
	#endif
	#if TK_IOoutput_NUM > 3
	TK_IOoutput_port3 = LED_Off;
	TK_IOoutput_trise3 = 0;
	#endif
	#if TK_IOoutput_NUM > 4
	TK_IOoutput_port4 = LED_Off;
	TK_IOoutput_trise4 = 0;
	#endif
	#if TK_IOoutput_NUM > 5
	TK_IOoutput_port5 = LED_Off;
	TK_IOoutput_trise5 = 0;
	#endif
	#if TK_IOoutput_NUM > 6
	TK_IOoutput_port6 = LED_Off;
	TK_IOoutput_trise6 = 0;
	#endif
	#if TK_IOoutput_NUM > 7
	TK_IOoutput_port7 = LED_Off;
	TK_IOoutput_trise7 = 0;
	#endif
	#if TK_IOoutput_NUM > 8
	TK_IOoutput_port8 = LED_Off;
	TK_IOoutput_trise8 = 0;
	#endif
	#if TK_IOoutput_NUM > 9
	TK_IOoutput_port9 = LED_Off;
	TK_IOoutput_trise9 = 0;
	#endif
	#if TK_IOoutput_NUM > 10
	TK_IOoutput_port10 = LED_Off;
	TK_IOoutput_trise10 = 0;
	#endif
	#if TK_IOoutput_NUM > 11
	TK_IOoutput_port11 = LED_Off;
	TK_IOoutput_trise11 = 0;
	#endif
	#if TK_IOoutput_NUM > 12
	TK_IOoutput_port12 = LED_Off;
	TK_IOoutput_trise12 = 0;
	#endif
	#if TK_IOoutput_NUM > 13
	TK_IOoutput_port13 = LED_Off;
	TK_IOoutput_trise13 = 0;
	#endif
	#if TK_IOoutput_NUM > 14
	TK_IOoutput_port14 = LED_Off;
	TK_IOoutput_trise14 = 0;
	#endif
	#if TK_IOoutput_NUM > 15
	TK_IOoutput_port15 = LED_Off;
	TK_IOoutput_trise15 = 0;
	#endif
	#if TK_IOoutput_NUM > 16
	TK_IOoutput_port16 = LED_Off;
	TK_IOoutput_trise16 = 0;
	#endif
	#if TK_IOoutput_NUM > 17
	TK_IOoutput_port17 = LED_Off;
	TK_IOoutput_trise17 = 0;
	#endif
	#if TK_IOoutput_NUM > 18
	TK_IOoutput_port18 = LED_Off;
	TK_IOoutput_trise18 = 0;
	#endif
	#if TK_IOoutput_NUM > 19
	TK_IOoutput_port19 = LED_Off;
	TK_IOoutput_trise19 = 0;
	#endif
}

/***********************************************************
:	void MCUInit(void) 
  :	ϵͳʼӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void MCU_init(void) 
{
	RAM_clear();
	WDT_set(WDT_4080ms);
	SysClk_set();
	GPIO_set();

	#if TK_Lowpowermode == ON
		g_wakeup_flag = 1;
	#endif
}

