/*********************************************************
*Copyright (C), 2020, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	int.c
*  :	AE Team 
*  :	V1.1
*  :	2023/11/10
*  :	жϴӳ
*  ע:    ESD-TKT-7P2131-Button 
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "main.h"

uchar Timer_counter;         //Timer counter        
uchar Timer_10ms;
uchar Timer20_Cnt;
uchar rst_flag = 0;

#if TK_UARToutput_function == ON

uchar Cnt_Mask;
uchar g_com;				//
uchar g_length;				//ݳ
uchar g_rp;					//ָ
uchar g_tp;					//ָ
uchar g_checksum;			//У
uchar Tx_timer;
uchar UploadSampByte[(TK_NUM*2) + 5];		//ֽ
//uchar UploadRawByte[(TK_NUM*2)+5];		//˲ֽ
//uchar UploadBaseByte[(TK_NUM*2)+5];		//ֽ
uchar UploadBuf[(TK_NUM*2) + 5];	        //ͻ

#endif

/*********************************************************
:	void Timer_T10_init(void)
  :	T10ʱʼ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void Timer_T10_init(void)
{                       
    T10		= 131;			//趨ʱֵʱ1ms
	T10C	= 0x0D;			//T10Ϊʱģʽ,ؼʹԤƵ64Ƶ  8M/64=0.125M  8us/Clock    
    T10IE	= 1;			//ʹT10ʱж
    T10EN	= 1;			//T10ENʱ
}

/*********************************************************
:	void TimerT20init(void)
  :	T20ʱʼ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void Timer_T20_init(void)
{                       
	T20PL =	0xF9;		   // ڼĴ (16(Ƶ)/16M)*250 = 250us 
	T20PH = 0x00;
	
	T20R0L = 0x7C;         // ȼĴ (16(Ƶ)/16M)*124 = 125us 
	T20R0H = 0x00;
	
	T20CL = 0xC1;			// ˫PWMT20TR β
	T20CM = 0x0F;			// Ƶ16	

	T20PIE = 0;				//ʹT20ʱж
	T20EN = 1;
}

/*********************************************************
:	void isr_T10_handler(void)
  : T10жϴ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void isr_T10_handler(void) interrupt_low 0x0010
{
	if(T10IE && T10IF)		//1ms Timer
    {					    //붨ʱж
        T10IF = 0;		    //жϱ־
        T10 = 131;			//سֵ

		Timer_10ms++;
		//Timer20_Cnt++;
		//if(Timer20_Cnt > 8)
		//{
			//Timer20_Cnt = 0;
			if(KeyPressed_Flag)
			{
				Display();	
			}
		//}
		if(FMQ_counter)
		{
			FMQ_counter--;
			//PA5 = ~PA5;
			if(FMQ_counter == 0)
			{
				//PA5 = 0;
				T2nOC = 0x00;			// ֹPWM200 
			}
		}
    }
}

/*********************************************************
:	void isr_TK_handler(void)
  : TKжϴ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void isr_TK_handler(void) interrupt_low 0x0020
{
	if(TKIE && TKIF)//ɨ
	{
		TKIF = 0;
				
		PC0  = 0;		   // Cxŵ
		PCT0 = 0;          // 
		  		 
		if(TKOVIF||TKERRIF||SCANOVIF)      //ɨ쳣
		{
			TK_value_get = 0;										  										  			  
		}
		else 
		{
			Timer_counter = 0;             //TKмʱ
			TK_value_get  = 1;             //ɨ
		}
		TKINTF &= 0xF0;                    //жϱ־

		#if Auto_Jitter_software == ON	   //Ƶ
		//if(Lock_averageconter > 2)
		//{
			//TKCTL2 = 0x20;  // 4M TKCTL2 = 0x30;  // 2M
		//}
		//else
		//{
			//TKCTL2 = 0x20;  // 4M TKCTL2 = 0x30;  // 2M //TKCTL2 = 0x20;  // 4M
		//}
		TKCTL2_ram &= 0xF0;
		TKCTL2_ram |= (TKCTL2 &0x0F);
		TKCTL2      = TKCTL2_ram;
		#endif
				
		//#if Auto_Jitter_hradware == ON

		//#endif

		if(TK_value_get == 0)
		{
			PCT0 = 1;
			if(g_wakeup_flag != 2)
			{
				TKGO = 1;
			}
		}
	}
}

#if TK_UARToutput_function == ON
/*********************************************************
:	void isr_uartx_handler(void)
  : UARTжϴ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void isr_uartx_handler(void) interrupt_high 0x001C
{
	uchar i;
	TKValueStru * ptr;   
	if(RX0IE && RX0IF)			//UARTж	
	{  
		g_com = RX0B;			//UARTݼĴͬʱӲRXIF־  
		UploadBuf[0] = 0x68;
		UploadBuf[1] = 0x68;
		g_rp = 0;			 //ָ0
		Cnt_Mask = 0;
		g_checksum = 0;		 //У0
		if(g_tp == 0)        //ڷ״̬
		{
			if(g_com == COMMOND1)
			{
				UploadBuf[2] = g_com;
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2];	//Уͣۼֵ
#if TK_Lowpowermode == ON
				if(g_wakeup_flag == 0)
				{
					while(Cnt_Mask < (TK_NUM*2))
					{
						if(((long)0x00000001 << (Cnt_Mask/2)))
						{
							UploadBuf[g_rp + 4] = 0;					
							g_checksum += UploadBuf[g_rp + 4];	//Уͣۼֵ
							g_rp++;
							Cnt_Mask++;
						}
						else
						{
							Cnt_Mask++;
						}
					}
				}
				else
#endif
				{
					while(Cnt_Mask < (TK_NUM*2))
					{
						if(((long)0x00000001 << (Cnt_Mask/2)))
						{
							UploadBuf[g_rp + 4] = UploadSampByte[Cnt_Mask];					
							g_checksum += UploadBuf[g_rp + 4];	//Уͣۼֵ
							g_rp++;
							Cnt_Mask++;
						}
						else
						{
							Cnt_Mask++;
						}
					}
				}

				g_length = g_rp;
				UploadBuf[3] = g_rp;
				g_checksum += UploadBuf[3];
				UploadBuf[g_rp + 4] = g_checksum;
				TX0B = UploadBuf[0];	//дͻ
				g_tp = 1;
				TX0IE = 1;				//ʹTXж 
			}
			else if(g_com == COMMOND2)
			{
				UploadBuf[2] = g_com;
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] ;	//Уͣۼֵ
#if TK_Lowpowermode == ON					
				if(g_wakeup_flag == 0)
				{
					for(i = 0;i < TK_NUM; i++)
					{
						UploadBuf[4+(i*2)] = (uchar)(TK_md2value_origin[i]>>8);
						g_checksum += UploadBuf[g_rp+4];	//Уͣۼֵ
						g_rp ++;
						UploadBuf[4+(i*2) + 1] = (uchar)(TK_md2value_origin[i]);
						g_checksum += UploadBuf[g_rp+4];	//Уͣۼֵ
						g_rp ++;
					}
				}
				else
#endif
				{
					for(i = 0; i < TK_NUM; i++)
					{
						ptr = &TK_Value_Arr[i];
						UploadBuf[4 + (i*2)] = (uchar)(ptr->tk_value_filter>>8);
						g_checksum += UploadBuf[g_rp + 4];	//Уͣۼֵ
						g_rp++;
						UploadBuf[4 + (i*2) + 1] = (uchar)(ptr->tk_value_filter);
						g_checksum += UploadBuf[g_rp + 4];	//Уͣۼֵ
						g_rp++;
					}
				}

				g_length = g_rp;
				UploadBuf[3] = g_rp;
				g_checksum += UploadBuf[3];
				UploadBuf[g_rp + 4] = g_checksum;
				TX0B = UploadBuf[0];	//дͻ
				g_tp = 1;
				TX0IE = 1;				//ʹTXж 
			}
			else if(g_com == COMMOND3)
			{				
				UploadBuf[2] = g_com;
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] ;	//Уͣۼֵ
					
#if TK_Lowpowermode == ON
				if(g_wakeup_flag == 0)
				{
					for(i = 0; i < TK_NUM; i++)
					{
						UploadBuf[4+(i*2)] = (uchar)(TK_md2average_backup[i]>>8);
						g_checksum += UploadBuf[g_rp+4];	//Уͣۼֵ
						g_rp ++;
						UploadBuf[4+(i*2) +1] = (uchar)(TK_md2average_backup[i]);
						g_checksum += UploadBuf[g_rp+4];	//Уͣۼֵ
						g_rp ++;
					}					
				}
				else
#endif
				{
					for(i = 0; i < TK_NUM; i++)
					{
						ptr = &TK_Value_Arr[i];
						UploadBuf[4 + (i*2)] = (uchar)(ptr->tk_value_average>>8);
						g_checksum += UploadBuf[g_rp + 4];	//Уͣۼֵ
						g_rp++;
						UploadBuf[4 + (i*2) + 1] = (uchar)(ptr->tk_value_average);
						g_checksum += UploadBuf[g_rp + 4];	//Уͣۼֵ
						g_rp++;
					}
				}

				g_length = g_rp;
				UploadBuf[3] = g_rp;
				g_checksum += UploadBuf[3];
				UploadBuf[g_rp + 4] = g_checksum;
				TX0B = UploadBuf[0];	//дͻ
				g_tp = 1;
				TX0IE = 1;				//ʹTXж 
#if TK_Lowpowermode == ON
				if(uart_send_flag)
				{
					uart_send_flag++;					
				}
#endif
			}
			else if(g_com == COMMOND4)  //ֵ
			{
				UploadBuf[2] = g_com;
				g_length = 9;
				UploadBuf[3] = 9;

				UploadBuf[4] = (uchar)(Opr_state);	     //Mode
				//#if  TK_Singlepress == ON  
				//UploadBuf[5] = (uchar)(TK_state_single>>16); //ֵH
				//UploadBuf[6] = (uchar)(TK_state_single>>8);	 //ֵM
				//UploadBuf[7] = (uchar)(TK_state_single);	 //ֵL
				//#else
				UploadBuf[5] = (uchar)(TK_state>>16);    //ֵH
				UploadBuf[6] = (uchar)(TK_state>>8);	 //ֵM
				UploadBuf[7] = (uchar)(TK_state);		 //ֵL
				//#endif

				#if  TK_Slider_Function == ON  
				UploadBuf[8] = (uchar)(TK_slider_value>>8);    //Byte H
				UploadBuf[9] = (uchar)(TK_slider_value);       //Byte L
				#elif TK_JITTER_DEBUG == ON
				UploadBuf[8] = (uchar)(TK_jitter_Value>>8);    //Byte H
				UploadBuf[9] = (uchar)(TK_jitter_Value);       //Byte L
				#else
				UploadBuf[8] = 0;		//Byte H
				UploadBuf[9] = 0;       //Byte L				
				#endif

				#if  TK_Wheel_Function == ON  
				UploadBuf[10] = (uchar)(TK_wheel_value>>8);    //Byte H
				UploadBuf[11] = (uchar)(TK_wheel_value);       //Byte L
				#else
				UploadBuf[10] = 0;
				UploadBuf[11] = 0;
				#endif

				#if  TK_Matrix_Function == ON  
				UploadBuf[12] = TK_Matrix_value ;              //Byte 			
				#else			
				UploadBuf[12] = 0;
				#endif
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] + UploadBuf[3] + UploadBuf[4] + UploadBuf[5];	//Уͣۼֵ
				g_checksum += UploadBuf[6] + UploadBuf[7] + UploadBuf[8] + UploadBuf[9] + UploadBuf[10] + UploadBuf[11]+ UploadBuf[12];	//Уͣۼֵ
				UploadBuf[13] = g_checksum;
				TX0B = UploadBuf[0];	//дͻ
				g_tp = 1;
				TX0IE = 1;				//ʹTXж 
			}
			else if(g_com == COMMOND0)  //ͨ
			{
				UploadBuf[2] = g_com;
				g_length     = 1;
				UploadBuf[3] = 1;
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] + UploadBuf[3];	    //Уͣۼֵ				
				UploadBuf[4] = TK_NUM;
				g_checksum += UploadBuf[4];	                                                //Уͣۼֵ
				g_rp++;								
				UploadBuf[g_rp + 4] = g_checksum;
				TX0B = UploadBuf[0];	    //дͻ
				g_tp = 1;
				TX0IE = 1;				//ʹTXж 
			}
			else if(g_com == COMMOND5)  //оƬλ
			{
				UploadBuf[2] = g_com;
			    g_length     = 2;
				UploadBuf[3] = 1;
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] + UploadBuf[3];	    //Уͣۼֵ						
				UploadBuf[4] = 0xAA;
				g_checksum += UploadBuf[4];	                                                //Уͣۼֵ
				g_rp++;								
				UploadBuf[g_rp+4] = g_checksum;
				TX0B = UploadBuf[0];	    //дͻ
				g_tp = 1;
				TX0IE = 1;				//ʹTXж 
				rst_flag = 1;	
			}
			else
			{
				//temp = ((g_com & 0xF0) >> 4 ) -6;
				//ChannelMask &= ~(0x0000000F << (temp*4));
				//ChannelMask |= ((g_com & 0x0F) << (temp*4));
				//g_length     = 0;
				//UploadBuf[3] = 0;
				//g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] + UploadBuf[3];	    //Уͣۼֵ	
				//g_rp ++;								
				//UploadBuf[4] = g_checksum;
				//TX0B = UploadBuf[0];	    //дͻ
				//g_tp =1;
				//TX0IE = 1;				//ʹTXж 
			}
		}					
		else
		{
			if(Tx_timer == 0)
			{
				Tx_timer = 1;
			}
		}
	}	

	if(TX0IE && TX0IF)				//UARTж  
	{	
		if(g_tp < g_length + 5)
		{
			TX0B = UploadBuf[g_tp];	//дͻ
			g_tp++; 
		}
		else
		{
			g_tp = 0;				//ָ0
			TX0IE = 0;				//ֹTXж 	
			Tx_timer = 0;           //巢ͼʱ
			g_length = 0;
#if TK_Lowpowermode == ON
			if(uart_send_flag > 2)
			{
				uart_send_flag = 4;
			}
#endif
			if(rst_flag)
			{
				rst_flag = 0;
				rst();
			}
		}
	}
}
#endif