/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  main.c
*  :  AE Team
*  :  V1.0
*  :  2021/12/08
*  :  T8P1ʱģUART,PA6ΪTXţPA7Ϊģ
*  ע:  ES7P7021
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>
#include "sys.h"

#define PIN_TXD PA6

unsigned int  adc_value @0x20;
unsigned char TxdBuf = 0;

unsigned char RxdOrTxd = 0;
unsigned char TxdEnd = 0;

/*********************************************************
:	void uart_io_init(void)
  : PA7ģTXPA6ģRX
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void uart_io_init(void)
{
	PAT6   = 0;  //	TX_PIN
	PA6  = 1;		
	ANS06  = 0;
	N_PAU6 = 0;
	N_PAD6 = 1;
}

/*********************************************************
:	void t8p1_uart_init(void)
  : T8P1ʱʼ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void t8p1_uart_init(void)
{
	T8P1M = 0;		// ʱģʽ
	T8P1 = 0x00;	// ʼֵ 
	T8P1P = 0x33;	// 8Mhz/16 /9600 = 104
	T8P1PRS0 = 1;	// ǰƵ 16
	T8P1PRS1 = 1; 

	T8P1POS0 = 0;	// Ƶ 1Ƶ
	T8P1POS1 = 0;
	T8P1POS2 = 0;
	T8P1POS3 = 0;
	GIE = 1;
}

/*********************************************************
:	void StartTXD(unsigned char dat)
  : ڷ
ֵ: dat, 
ֵ: 
ֵ:  
**********************************************************/
void StartTXD(unsigned char dat)
{
	TxdBuf = dat;
	T8P1P = 0x33;	// 8Mhz/16 /9600 = 52
	T8P1IE = 1;		// ʹT8P1ж
	T8P1E = 0x1;	// ʹ T8P1 
	PIN_TXD = 0;
	TxdEnd = 0;
	RxdOrTxd = 1;
}

void led_io_init(void)
{
	PBT2   = 0;  //
	
	PB2    = 1;	 //ʼΪߵƽ
	ANS12  = 0;  //ֶ˿
	
	N_PBU2 = 1;  //ֹ
	N_PBD2 = 1;  //ֹ
	
}

/*********************************************************
:	void adc_init(void)
  : ADCʼ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void adc_init(void)
{
	// ģ˿ PA7 
	PAT7  = 1;   //PA7
	ANS07 = 1;   //PA7ģ 

	// ADC ʱ FOSC/8 
	ADCKS0 = 1;  
	ADCKS1 = 1;	 
	ADCKS2 = 0;	 

	// οѹԴѡ 2.1v 
	ADVREFS0 = 1; 
	ADVREFS1 = 1; 
	ADVREFS2 = 0; 

	// ģģʽ ģʽ 
	ADSDIF = 0;     

	// ģͨѡ PA7 AIN5
	ADCH0 = 1; 
	ADCH1 = 0; 
	ADCH2 = 1; 

	// תʽ 
	ADCMS = 0; 

	// λ뷽ʽ 
	ADFM = 1; 

	// ʹADC 
	ADEN = 1;

	// Ӳλ 
	ADRSTMD = 0;
	while(ADRSTST != 1);
}

/*********************************************************
:	uint16_t adc_read(void)
  : ADCתֵȡ
ֵ: 
ֵ: 
ֵ: ADCתֵ
**********************************************************/
uint16_t adc_read(void)
{
	uint16_t adc_result = 0;

	ADIF = 0;
	// ADCת 
	ADSOC = 1;
	// ȴתɱ־λ 
	while(ADIF == 0); 
	// ȡADCתֵ
	adc_result = ADCRH << 8;
	adc_result |= ADCRL;
	
	return adc_result;
}

unsigned char i = 0;
/*********************************************************
:	void main() 
  : 
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void main() 
{
	wdt_close();
	ram_clear();
	clock_init(CLOCK_SRC_HRC, DIV_1);
	uart_io_init();
	t8p1_uart_init();
	led_io_init();
	adc_init();

	
	while(1) {
		adc_value = 0;
		// ȡ12κȡƽ
		for (i = 0; i < 12; ++i) {
			delay(5000);
			adc_value += adc_read();
		}
		adc_value = adc_value / 12;

		StartTXD(adc_value);
		while(!TxdEnd);
		PB2 ^= 1;
	}
}

/*********************************************************
:	void isr (void) interrupt
  : жϴ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void irq(void) interrupt
{
	static unsigned char cnt = 0; //λջͼ

	if ((T8P1IE) && (T8P1IF)) {
			
		T8P1IF = 0;
		/* ʹ */
		if( RxdOrTxd) {
			cnt++;
			if (cnt <= 8) {
				PIN_TXD = TxdBuf & 0x01;
				TxdBuf >>= 1;
			} else if (cnt == 9) {		//ֹͣλ
				PIN_TXD = 1;
			} else {
				cnt = 0;
				T8P1E = 0;              //ر T8P1
				TxdEnd = 1;				//λͽ־
			}
		} 
	}	
}