/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  main.c
*  :  AE Team
*  :  V1.0
*  :  2021/12/08
*  :  T8P1ʱģUARTշ
*  ע:  ES7P7021
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>
#include "sys.h"

#define PIN_TXD PA7
#define PIN_RXD PA6

unsigned char RxdBuf = 0;
unsigned char TxdBuf = 0;

unsigned char RxdOrTxd = 0;
unsigned char RxdEnd = 0;
unsigned char TxdEnd = 0;

/*********************************************************
:	void uart_io_init(void)
  : PA7ģTXPA6ģRX
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void uart_io_init(void)
{
	PAT7   = 0;  //	TX_PIN
	PAT6   = 1;  // RX_PIN
	
	PA7    = 1;	 //ʼΪߵƽ

	ANS07  = 0;  //ֶ˿
	ANS06  = 0;

	N_PAU7 = 0;  //ֹ
	N_PAD7 = 1;  //ֹ
	N_PAU6 = 0;
	N_PAD6 = 1;
}

/*********************************************************
:	void t8p1_uart_init(void)
  : T8P1ʱʼ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void t8p1_uart_init(void)
{
	T8P1M = 0;		// ʱģʽ
	T8P1 = 0x00;	// ʼֵ 
	T8P1P = 0x33;	// 8Mhz/16 /9600 = 104
	T8P1PRS0 = 1;	// ǰƵ 16
	T8P1PRS1 = 1; 

	T8P1POS0 = 0;	// Ƶ 1Ƶ
	T8P1POS1 = 0;
	T8P1POS2 = 0;
	T8P1POS3 = 0;
	GIE = 1;
}

/*********************************************************
:	void StartTXD(unsigned char dat)
  : ڷ
ֵ: dat, 
ֵ: 
ֵ:  
**********************************************************/
void StartTXD(unsigned char dat)
{
	TxdBuf = dat;
	T8P1P = 0x33;	// 8Mhz/16 /9600 = 52
	T8P1IE = 1;		// ʹT8P1ж
	T8P1E = 0x1;	// ʹ T8P1 
	PIN_TXD = 0;
	TxdEnd = 0;
	RxdOrTxd = 1;
}

/*********************************************************
:	void StartRXD(void)
  : ڽգݴRxdBuf
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void StartRXD(void)
{
	T8P1P = 0x19;
	T8P1IE = 1;		// ʹT8P1ж 
	T8P1E = 0x1;	// ʹ T8P1 
	RxdEnd = 0;
	RxdOrTxd = 0;		
}

/*********************************************************
:	void main() 
  : 
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void main() 
{
	wdt_close();
	ram_clear();
	clock_init(CLOCK_SRC_HRC, DIV_1);
	uart_io_init();
	t8p1_uart_init();

	while(1) {

		StartTXD(0Xa5);
		while(!TxdEnd);

		while(PIN_RXD);
		StartRXD();
		while(!RxdEnd);

		StartTXD(RxdBuf);
		while(!TxdEnd);

		StartTXD(0XCD);
		while(!TxdEnd);
	}
}

/*********************************************************
:	void isr (void) interrupt
  : жϴ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void irq(void) interrupt
{
	static unsigned char cnt = 0; //λջͼ

	if ((T8P1IE) && (T8P1IF)) {
			
		T8P1IF = 0;
		/* ʹ */
		if( RxdOrTxd) {
			cnt++;
			if (cnt <= 8) {
				PIN_TXD = TxdBuf & 0x01;
				TxdBuf >>= 1;
			} else if (cnt == 9) {		//ֹͣλ
				PIN_TXD = 1;
			} else {
				cnt = 0;
				T8P1E = 0;              //ر T8P1
				TxdEnd = 1;				//λͽ־
			}
		} else {	//нմ

			if (cnt == 0) {

				T8P1P = 0x33;

				if (!PIN_RXD) {
					RxdBuf = 0;
					cnt++;
				} else {
					T8P1E = 0;         //رT8P1
				}
			} else if (cnt <= 8) {
				RxdBuf >>= 1;
				if (PIN_RXD) {
					RxdBuf |= 0x80;
				}
				cnt++;
			} else {
				cnt = 0;
				T8P1E = 0;			//رT8P1
				if (PIN_RXD) {
					RxdEnd = 1;		//ս
				}
			}
		}
	}	
}