/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  main.c
*  :  AE Team
*  :  V1.0
*  :  2021/12/08
*  :  T8P1/T8P2ʱ̶жзתIO
*  ע:  ES7P7021
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>
#include "sys.h"

uint16_t cnt = 0;
uint16_t cnt1 = 0;

/*********************************************************
:	void io_init(void)
  : ųʼ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void io_init(void)
{
	PBT0   = 0;	//
	PBT1   = 0;
	PBT3   = 0; 

	PB0    = 1;  //ʼΪߵƽ
	PB1    = 1;
	PB3    = 1;
	
	ANS10  = 0;  //ֶ˿
	ANS11  = 0;
	ANS13  = 0;

	N_PBU0 = 1;  //ֹ
	N_PBD0 = 1;  //ֹ
	N_PBU1 = 1; 
	N_PBD1 = 1; 
	N_PBU3 = 1; 
	N_PBD3 = 1; 
}

/*********************************************************
:	void t8p1_init(void)
  : t8p1ʼ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void t8p1_init(void)
{
	T8P1M = 0; 
	T8P1 = 0;		// ʼֵ
	T8P1P = 0xFF;	// ֵ

	T8P1PRS0 = 1;	// ǰƵ 16
	T8P1PRS1 = 1; 

	T8P1POS0 = 1;	// Ƶ 16
	T8P1POS1 = 1;
	T8P1POS2 = 1;
	T8P1POS3 = 1;

	T8P1IE = 1;		// ʹT8P1ж
	T8P1E = 0x1;	// ʹ T8P1 
}

/*********************************************************
:	void t8p2_init(void)
  : t8p2ʼ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void t8p2_init(void)
{
	T8P2M = 0; 
	T8P2 = 0;		// ʼֵ
	T8P2P = 0xFF;	// ֵ

	T8P2PRS0 = 1;	// ǰƵ 16
	T8P2PRS1 = 1; 

	T8P2POS0 = 1;	// Ƶ 16
	T8P2POS1 = 1;
	T8P2POS2 = 1;
	T8P2POS3 = 1;

	T8P2IE = 1;		// ʹT8P2ж
	T8P2E = 0x1;	// ʹ T8P2 
}

/*********************************************************
:	void main() 
  : 
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void main() 
{
	wdt_close();
	ram_clear();
	clock_init(CLOCK_SRC_HRC, DIV_1);
	io_init();
	t8p1_init();
	t8p2_init();

	GIE = 1;

	while(1) {}
}

/*********************************************************
:	void isr (void) interrupt
  : жϴ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void irq(void) interrupt
{
	if ((T8P1IE) && (T8P1IF)) {
		T8P1IF = 0;
		++cnt;
		if (cnt == 100) {
			cnt = 0;
			PB1 = ~PB1;
		}	
	}

	if ((T8P2IE) && (T8P2IF)) {
		T8P2IF = 0;
		++cnt1;
		if (cnt1 == 50) {
			cnt1 = 0;
			PB3 = ~PB3;
		}
		T8P1P = 0xFF;
	}
}