/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd.
*文件名:  sys.h
*作  者:  AE Team
*版  本:  V1.0
*日  期:  2021/12/08
*描  述:  系统相关函数接口
*备  注:  适用于ES7P7021
本软件仅供学习和演示使用，对用户直接引用代码所带来的风险或后果不承担任何法律责任。
**********************************************************/
#ifndef __SYS_H__
#define __SYS_H__

#include "type.h"

/**
  * @brief Clock source select
  */
typedef enum {
	CLOCK_SRC_HRC = 0,
	CLOCK_SRC_LRC = 1,
} clock_src_t;

/**
  * @brief Type of clock div
  */
typedef enum {
    DIV_1 = 0x0,
	DIV_2 = 0x1,
	DIV_4 = 0x2,
	DIV_8 = 0x3,
	DIV_16 = 0x4,
	DIV_32 = 0x5,
	DIV_64 = 0x6,
	DIV_128 = 0x7,
} clock_div_t;

/**
  * @brief wdt in idle mode enable bit select
  */
typedef enum {
	Idisable = 0,
	Ienable  = 1,
}wdt_idle_t;

/**
  * @brief Type of wdt div
  */
typedef enum {
    WDT_DIV_1   = 0x0,
	WDT_DIV_8   = 0x1,
	WDT_DIV_16  = 0x2,
	WDT_DIV_32  = 0x3,
	WDT_DIV_64  = 0x4,
	WDT_DIV_128 = 0x5,
	WDT_DIV_256 = 0x6,
	WDT_DIV_512 = 0x7,
} wdt_div_t;

/**
  * @brief PA3 select function
  */
typedef enum {
	IO = 0,
	MRST  = 1,
}mrst_select_t;

/**
  * @brief reset flag
  */
typedef enum {
	BOR_FLAG  = 0x1,
	POR_FLAG  = 0x2,
	IDLE_FLAG = 0x4,
	WDT_FLAG  = 0x8,
	IRST_FLAG = 0x10,
}reset_flag_t;

typedef enum {
	VALID    = 0,
	INVALID  = 1,
}flag_status_t;

/**
  * @brief IDLE modules clock
  */
typedef enum {
	T8P1_ICLK = 0x2,
	T8P2_ICLK = 0x4,
	ADC_ICLK  = 0x20,
	ALL_ICLK  = 0xFF,
}idle_modules_clk_t;

/**
  * @addtogroup SYSTEM_Public_Functions
  * @{
  */ 
void ram_clear(void);
void delay(uint16_t times);

/**
  * @addtogroup CMU_Public_Functions
  * @{
  */ 
void clko_io_init(void);
func_status_t clock_init(clock_src_t src, clock_div_t div);

/**
  * @addtogroup RMU_Public_Functions
  * @{
  */ 
void wdt_close(void);
void wdt_enable(void);
void clear_wdt(void);
void wdt_init(type_func_t func, wdt_idle_t idle, wdt_div_t div);
void soft_reset(void);
flag_status_t get_reset_flag(reset_flag_t flag);

/**
  * @addtogroup PMU_Public_Functions
  * @{
  */ 
void enter_idle(void);
void idle_clk_init(idle_modules_clk_t module, type_func_t func);

#endif /* __SYS_H__ */
