/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  sys.c
*  :  AE Team
*  :  V1.0
*  :  2021/12/08
*  :  ϵͳغ
*  ע:  ES7P7021
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/

#include <hic.h>
#include "sys.h"

/*********************************************************
:	void ram_clear(void)
  : RAM
ֵ: ʱʱ䳤
ֵ: 
ֵ:  
**********************************************************/
void ram_clear(void)
{
    for (IAAH=0; IAAH<=0x00; IAAH++) {
        for (IAAL=0; IAAL<0x7F; IAAL++)
            IAD = 0x00;
        IAD = 0x00;
    }
}

/*********************************************************
:	void delay(uint16_t times)
  : ʱ
ֵ: ʱʱ䳤
ֵ: 
ֵ:  
**********************************************************/
void delay(uint16_t times)
{
	uint16_t loop = 0;

	for (; loop < times; loop++) {
		__asm{
			NOP
			NOP
			NOP
			NOP
			NOP
			NOP
			NOP
			NOP
			NOP
			NOP
		}
	}
}

/*********************************************************
:	void clko_io_init(void)
  : ʱIOʼ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void clko_io_init(void)
{
	PAT4   = 0;  //    
	PA4    = 0;	 //ʼΪ͵ƽ
	ANS04  = 0;  //ֶ˿
	N_PAU4 = 1;  //ֹ
	N_PAD4 = 1;  //ֹ
}

/*********************************************************
:	func_status_t clock_init(clock_src_t src, clock_div_t div)
  : ϵͳʱѡ
ֵ: srcʱԴ
ֵdivƵֵ
ֵ: OK
**********************************************************/
func_status_t clock_init(clock_src_t src, clock_div_t div)
{	
	uint8_t cmp = 0;

	OSCWP = 0x55;         // ʱӽ
	if (src == CLOCK_SRC_HRC) {
		HFS   = 1;        // HRCѡ16M
		HRCEN = 1;        // ʱԴѡHRC
	}

	OSCC1 = src;

	DIVS0 = div & 0x01;	  // ʱӷƵ
	DIVS1 = (div >> 1)& 0x01;
	DIVS2 = (div >> 2)& 0x01;  
	
	while (CHG == 1);     // жʱǷл
	
	if (SST != src)
		return ERROR;     // жʱԴ־Ƿȷ
	
	CLKOEN = 0;           // ֹʱӴPA4
	OSCWP = 1;            // ʱ

	return OK;	
}

/*********************************************************
:	void wdt_close(void)
  : ؿŹ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void wdt_close(void)
{
	WDTUL  = 0xA5;
	SWDTEN = 0;
}

/*********************************************************
:	void wdt_enable(void)
  : Źʹ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void wdt_enable(void)
{
	WDTUL  = 0xA5;
	SWDTEN = 1;
}

/*********************************************************
:	void clear_wdt(void)
  : ιŹ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void clear_wdt(void)
{
	__Asm CWDT;	
}

/*********************************************************
:	void wdt_init(type_func_t func, wdt_idle_t idle, wdt_div_t div)
  : Źʼ
ֵ: func,״̬
ֵ: idle,idle״̬
ֵ: div,Ƶֵ
ֵ:  
**********************************************************/
void wdt_init(type_func_t func, wdt_idle_t idle, wdt_div_t div)
{
	if (idle == Ienable) {
		WDTUL = 0xA5;
		WDTIEN = 1;     // ͹ Źʹ
	}
	WDTUL = 0xA5;
	WDTPRS0 = div & 0x1;
	WDTUL = 0xA5;
	WDTPRS1 = (div & 0x10) >> 1;
	WDTUL = 0xA5;
	WDTPRS2 = (div & 0x100) >> 2;
	
	if (func == ENABLE) {
		WDTUL = 0xA5;
		SWDTEN = 1;     // Źʹ
	}
}

/*********************************************************
:	void soft_reset(void)
  : λ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void soft_reset(void)
{
	__Asm RST;	
}

/*********************************************************
:	flag_status_t get_reset_flag(reset_flag_t flag)
  : ȡλ־λ
ֵ: flag־λ
ֵ: 
ֵ: λ״̬
**********************************************************/
flag_status_t get_reset_flag(reset_flag_t flag)
{
	if ((PWRC & flag) == 0)
		return VALID;
	else
		return INVALID;
}

/*********************************************************
:	void enter_idle(void)
  : idle״̬
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void enter_idle(void)
{
	__Asm IDLE;
}

/*********************************************************
:	void idle_clk_init(idle_modules_clk_t module, type_func_t func)
  : idle״̬ʱʱ
ֵ: module,
ֵ: func,Ƿ
ֵ: 
ֵ: 
**********************************************************/
void idle_clk_init(idle_modules_clk_t module, type_func_t func)
{
	if (func == ENABLE)
		CLKG |= module;
	else 
		CLKG &= ~(module);
}
