/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  main.c
*  :  AE Team
*  :  V1.0
*  :  2021/12/08
*  :  KINTж
*  ע:  ES7P7021
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>
#include "sys.h"

/*********************************************************
:	void led_io_init(void)
  : ųʼ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void led_io_init(void)
{
	PBT2   = 0;  //
	PBT3   = 0; 
	
	PB2    = 1;	 //ʼΪߵƽ
	PB3    = 1;
	
	ANS12  = 0;  //ֶ˿
	ANS13  = 0;

	N_PBU2 = 1;  //ֹ
	N_PBD2 = 1;  //ֹ
	N_PBU3 = 1;  //ֹ
	N_PBD3 = 1;  //ֹ
}

/*********************************************************
:	void kint_io_init(void)
  : KINTųʼ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void kint_io_init(void)
{
	volatile unsigned char tmp;
	
	ANS06 = 0;   //PA6ֶ˿
	PAT6  = 1;   //
	N_PAU6 = 0;  //
	N_PAD6 = 1;  //ֹ
	
	tmp = PA;    //˿KIF־λ
	
	KMSK6 = 1;	 //벻
	KIE = 1;	 //ʹܰж
	PA6 = 0;
	KIF = 0;	 //жϱ־
	GIE  = 1;    //ж
}

/*********************************************************
:	void led_on(void)
  : PB3
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void led_on(void)
{
	PB3    = 0;
}

/*********************************************************
:	void led_off(void)
  : PB3
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void led_off(void)
{
	PB3    = 1;
}

/*********************************************************
:	void delay_(uint16_t times)
  : ʱ
ֵ: ʱʱ䳤
ֵ: 
ֵ:  
**********************************************************/
void delay_(uint16_t times)
{
	uint16_t i = 0;

	for (i = 0; i < times; i++) {
		delay(5000);
	}
}

/*********************************************************
:	void main() 
  : 
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void main() 
{
	wdt_close();
	ram_clear();
	clock_init(CLOCK_SRC_HRC, DIV_1);
	led_io_init();
	kint_io_init();

	while(1) {
		led_on();
		delay_(50);
		led_off();
		delay_(50);
	}
}

/*********************************************************
:	void isr (void) interrupt
  : жϴ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void isr (void) interrupt
{
	volatile unsigned char tmp;
	
	if (KIF) {
		tmp = PA; 
		KIF = 0;
		PB2 = ~PB2;
	}
}