/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  main.c
*  :  AE Team
*  :  V1.0
*  :  2021/12/08
*  :  IDLEģʽ£PINT
*  ע:  ES7P7021
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>
#include "sys.h"

/*********************************************************
:	void led_io_init(void)
  : ųʼ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void led_io_init(void)
{
	PBT2   = 0;  //	
	PB2    = 1;	 //ʼΪߵƽ

	ANS12  = 0;  //ֶ˿

	N_PBU2 = 1;  //ֹ
	N_PBD2 = 1;  //ֹ
}

/*********************************************************
:	void pint_io_init(void)
  : PINTųʼ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void pint_io_init(void)
{
	ANS06 = 0;   //PA6ֶ˿
	PAT6  = 1;   //
	N_PAU6 = 1;  //ֹ
	N_PAD6 = 0;  //ʹ
	PEG2 = 0;    //سж
	PINT2S0 = 0; //жԴѡPA6
	PINT2S1 = 0;
	PIE2 = 1;    //ʹж
	PIF2 = 0;
	GIE  = 1;    //ж
}

/*********************************************************
:	void delay_(uint16_t times)
  : ʱ
ֵ: ʱʱ䳤
ֵ: 
ֵ:  
**********************************************************/
void delay_(uint16_t times)
{
	uint16_t i = 0;

	for (i = 0; i < times; i++) {
		delay(5000);
	}
}

/*********************************************************
:	void io_init(void)
  : ųʼ0
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void io_init(void)
{
	PBT   = 0;	  //
	PAT   = 0; 
	
	PA    = 0X0;  //˿ڶ͵ƽ
	PB    = 0X0;
	
	ANS1  = 0;    //ֶ˿
	ANS0  = 0;

	N_PAU  = 0XFF;  //ֹ
	N_PAD  = 0XFF;  //ֹ
	N_PBU = 0XFF;   //ֹ
	N_PBD = 0XFF;   //ֹ
}

/*********************************************************
:	void main() 
  : 
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void main() 
{
	uint8_t cnt = 0;

	wdt_close();
	ram_clear();
	clock_init(CLOCK_SRC_HRC, DIV_1);
	io_init();
	led_io_init();

	pint_io_init();
	idle_clk_init(ALL_ICLK, ENABLE);

	while(1) {
		delay_(50);
		++cnt;
		if (cnt == 5) {
			cnt = 0;
			enter_idle();
		}
	}
}

/*********************************************************
:	void isr (void) interrupt
  : жϴ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void isr (void) interrupt
{
	if (PIE2 && PIF2) {
		PIF2 = 0;
		PB2 = ~PB2;
	}
}