/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  iap.c
*  :  AE Team
*  :  V1.0
*  :  2021/12/08
*  :  IAPӿں
*  ע:  ES7P7021
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "iap.h"

/*********************************************************
:	func_status_t flash_erase(uint16_t addr)
  : ַ
ֵ: addr, Ҫҳַ
ֵ: 
ֵ: 
**********************************************************/
func_status_t flash_erase(uint16_t addr)
{
	uint8_t  i = 0;

	LVDC  = 1;				  //رLVD
	IAPCLR = 1;               //IAP״̬

	FRAL   = addr;
	FRALN  = ~(addr & 0xff);
	FRAH   = (addr >> 8);
	FRAHN  = ~(addr >> 8);

	IAPUL = 0xA5;             //Ᵽ

	while (IAPUL == 0) {
		delay(100);
		i++;
		if (i == 100)
			return ERROR;
	}                         //жǷɹ 

	IAPERSS = 0xAE;			  //ҳ

	while (IAP_DONE != 1) {
		delay(100);
		i++;
		if (i == 100)
			return ERROR;
	}                         //жϲǷ*/  

	IAPCLR = 1;               //IAP״̬
	IAPUL = 0x00;             //д

	return OK;
}

/*********************************************************
:	func_status_t flash_write(uint16_t addr, uint16_t *buf, uint16_t len)
  : ҳַд
ֵ: addr, Ҫдҳַ
ֵbuf, Դʼַ
ֵlen, Ҫдݳ
ֵ: 
ֵ: д
**********************************************************/
func_status_t flash_write(uint16_t addr, uint16_t *buf, uint16_t len)
{
	uint8_t  i = 0;
	uint16_t loop = 0;
	
	/* LVD */
	LVDC  = 1;				  

	IAPCLR = 1;             //IAP״̬
	IAPUL = 0xA5;           //Ᵽ
	
	/*жǷɹ*/
	while (IAPUL == 0) {
		delay(100);
		i++;
		if (i == 100)
			return ERROR;
	}                       
	
	for (loop = 0; loop < len; loop++) {
		i = 0;
		FRAL   = addr;
		FRALN  = ~(addr & 0xff);
		FRAH   = (addr >> 8);
		FRAHN  = ~(addr >> 8);
		ROMDL  = (buf[loop]) & 0xff;
		ROMDH  = ((buf[loop]) >> 8);	//ñ̵ַ

		IAPPRGS = 0xC6;					//IAP BIT 
		/* ж IAP ɹ */
		while(IAPPRGS == 0);
	   
	    /*жϱǷ*/
		while (IAP_DONE != 1) {
			delay(100);
			i++;
			if (i == 100)
				return ERROR;
		}                     
		addr  += 1;						//һд 
		IAPCLR = 1;						//IAP״̬
	}
	
	IAPUL = 0x00; 
	       
	return OK;
}

/*********************************************************
:	func_status_t flash_read(uint16_t addr, uint16_t *buf, uint16_t len)
  : ҳַĶ
ֵ: addr, Ҫҳַ
ֵbuf, ݴʼַ
ֵlen, Ҫݳ
ֵ: 
ֵ: д
**********************************************************/
func_status_t flash_read(uint16_t addr, uint16_t *buf, uint16_t len)
{
	uint16_t i;
	
	for (i = 0; i < len; i++) {
		ROMDH = 0;
		ROMDL = 0;

		FRAH  = addr >> 8;
		FRAHN = ~(addr >> 8);
		FRAL  = addr;
		FRALN = ~addr;                          //öȡַ

		__Asm TBR;
		*buf = (ROMDH << 8) | ROMDL;			//öȡ
		buf++;
		addr += 1;                              //һβ16λ
	}

	return OK;
}

/*********************************************************
:	void iap_irq_config(void)
  : IAPжϵʹ
ֵ: 
ֵ: 
**********************************************************/
void iap_irq_config(void)
{    
	GIE = 1;         //ʹж
	IAPIE = 1;       //ʹIAPж
}
