/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd.
*文件名:  type.h
*作  者:  AE Team
*版  本:  V1.0
*日  期:  2021/12/08
*描  述:  系统相关宏定义
*备  注:  适用于ES7P7021
本软件仅供学习和演示使用，对用户直接引用代码所带来的风险或后果不承担任何法律责任。
**********************************************************/
#ifndef __TYPE_H__
#define __TYPE_H__

#include <hic.h>

typedef char		int8_t;
typedef unsigned char	uint8_t;
typedef short		int16_t;
typedef unsigned short	uint16_t;
typedef long		int32_t;
typedef unsigned long	uint32_t;

typedef enum {
	ERROR = 0x0,
	OK    = 0x1,
} func_status_t;

typedef enum {
	RESET = 0x0,
	SET   = 0x1,
} it_status_t;

typedef enum {
	BIT_RESET = 0x0,
	BIT_SET   = 0x1,
} bit_status_t;

typedef enum {
	DISABLE = 0x0,
	ENABLE  = 0x1,
} type_func_t;
#define IS_FUNC_STATE(x)	(((x) == DISABLE) || ((x) == ENABLE))

typedef enum {
	FALSE = 0x0,
	TRUE  = 0x1,
} type_bool_t;

typedef enum {
	UNLOCK = 0x0,
	LOCK   = 0x1,
} lock_state_t;

#define IS_LOCK_STATE(x)	(((x) == UNLOCK) || ((x) == LOCK))

#define SET_BIT(reg, bit)	((reg) |= (bit))
#define CLEAR_BIT(reg, bit)	((reg) &= ~(bit))
#define READ_BIT(reg, bit)	((reg) & (bit))
#define CLEAR_REG(reg)		((reg) = (0x0))
#define WRITE_REG(reg, val)	((reg) = (val))
#define READ_REG(reg)		((reg))
#define MODIFY_REG(reg, clearmask, setmask)	\
	WRITE_REG((reg), (((READ_REG(reg)) & (~(clearmask))) | (setmask)))
#define UNUSED(x)	((void)(x))
#define sleep()			__Asm IDLE;
#define CLRWDT()   		__Asm CWDT;	

#ifdef USE_ASSERT
#define assert_param(x)			\
do {					\
	if (!(x)) {			\
		__disable_irq();	\
		while (1)		\
			;		\
	}				\
} while (0)
#else
#define assert_param(x)
#endif

#endif /* __TYPE_H__ */