/*********************************************************
*Copyright (C), 2018, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  main.c
*  :  Liut
*  :  V1.00
*  :  2018/07/04
*  :  Bootloaderʾ
          MCUHR8P287
          RXPA0  TXPA1  BootPinPA23
          ʣ115200  УλżУ  ֹͣλ1λ
          ʾοĵ AN082_Ӧñʼ_ES8PϵMCU bootloader
*  ע:  ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "HR8P287.h"
#include "macro.h"
#include "typedef.h"
#include "lib_flashiap.h"

extern isp_data_t g_isp_data;
extern uint32_t  g_boot_timer;
extern uint8_t   g_boot;

void uart_init(UART_TypeDef *uartx);
void uart_proc_fsm(void);
void fsm_init(void);
void JumpToApp(uint32_t addr);

/***************************************************************
systick_init
  : Systickʼ
ֵ
ֵ
ֵ
***************************************************************/
void systick_init(void)
{
    SysTick->CTRL = 0x07;
    SysTick->LOAD = 16000;  //ϵͳʱ16M1msһж
    SysTick->VAL = 0;
}

/***************************************************************
gpio_init
  : GPIOʼ
ֵ
ֵ
ֵ
***************************************************************/
void gpio_init(void)
{
    SCU->PROT.Word = 0X55AA6996;
    SCU->PCLKEN0.GPIO_EN = 1;
    SCU->PCLKEN1.UART0_EN = 1;
    SCU->PCLKEN0.IAP_EN = 1;


    GPIO->PROT.Word = 0x78879669;

    //BootPIN:PA23
    GPIO->PADIR.DIR_23 = 1;                 //ر
    GPIO->PAPDEN.PDEN_23 = 1;               //

    //RX:PA0
    GPIO->PADIR.DIR_0 = 1;                  //ر
    GPIO->PAFUN0.PA0 = 2;                       //FUNC2 RXD

    //TX:PA1
    GPIO->PADIR.DIR_1 = 0;                  //
    GPIO->PAFUN0.PA1 = 2;                       //FUNC2 TXD

    GPIO->PROT.Word = 0;
}

int SystemInit(void)
{
    return 0;
}

/***************************************************************
main
  : Bootloader
ֵ
ֵ
ֵ
***************************************************************/
int main()
{
    gpio_init();
    uart_init(UART0);
    fsm_init();
    NVIC_EnableIRQ(UART0_IRQn);
    systick_init();

    while (1)
    {

        if (g_isp_data.triger == 1)
        {
            __disable_irq();  //ٽδ뱣

            while (g_isp_data.triger == 1)
            {
                uart_proc_fsm();  //isp״̬
            }

            __enable_irq();
        }

        if (g_boot == 1) //Ҫflash
        {
            JumpToApp(APP_ADDR);
        }
    }
}
